/*globals define*/
define(['module', 'angular', './mainBase', 'ng/services/injector', 'qed_list', 'widgets', 'ng/services/lang', 
], function(module, angular, mainCtrl, inject) {
    'use strict';

    function FortiviewSessionsDrilldown($scope, $routeParams, injector, fortiviewUtil,
                               fortiviewSearchState, fortiviewSessions, fortiviewFacets) {
        injector.injectMarked(this, {$scope: $scope});

        this.scope = $scope;
        $scope.noSummary = true;
        $scope.noRightMenu = true;
        $scope.disableDrilldown = true;
        this.maxValues = {};

        this.set_drilldown_value();

        $scope.qlistOptions = this.makeQlistConfig({
            prefix: 'qlist_sessions',
            default_columns: ['sources', 'sports', 'destinations', 'dports', 'Bytes', 'requests', 'policies', 'exist_time'],
            columns: [
                { selector: 'sources', lang_key: 'Source'},
                { selector: 'sports', lang_key: 'sports'},
                { selector: 'destinations', lang_key: 'Destination'},
                { selector: 'dports', lang_key: 'dports'},
                { selector: 'Bytes', lang_key: 'Bytes (Sent/Received)'},
                { selector: 'requests', lang_key: 'Requests'},
                { selector: 'policies', lang_key: 'Policy'},
                { selector: 'exist_time', lang_key: 'Exists'}
            ],
            options: {
                sort_source_order: {
                    selector: 'Bytes',
                    direction: 'desc'
                },
                sort_columns: {
                    Bytes: 'desc',
                    requests: 'desc'
                },
            },
            format_fn: {
                sources: fortiviewUtil.format_fn.address,
                destinations: fortiviewUtil.format_fn.address,
                exist_time: fortiviewUtil.format_fn.exist_time,
            },
            remove_session_entries: true
        });

        this.sourceSortBy = 'Bytes';
        $scope.sort = {value: this.sourceSortBy};
        $scope.$watch(function() {
            return this.sourceSortBy || 'Bytes';
        }.bind(this), function(value) {
            this.scope.sort.value = value;
        }.bind(this));
        this.scope.$watch('sort.value', function(value) {
            this.sourceSortBy = value;
            this.reloadSessionsQlistData();
        }.bind(this));

        this.reloadSessionsQlistData();
        this.scope.$on('reload', function() {
            this.reloadSessionsQlistData();
        }.bind(this));
    }

    FortiviewSessionsDrilldown.prototype.calculateMaxima = 
    inject.mark(function($injector, $route, fortiviewGraph, fortiviewData, fortiviewSearchState, fortiviewRouteMetadata) {
        return function(target, details, sums) {
            sums = angular.extend({
                Bytes: ['Response', 'Request'],
            }, sums);
            var fields = {Bytes: 0};
            angular.extend(fields, target, sums);
            for (var key in fields) {
                fields[key] = 0;
            }
            if (details !== null) {
                details.reduce(calc_max, fields);
                for (var f in fields) {
                    target[f] = Math.max(1, fields[f]);
                }
            }
            function calc_max(fields, row) {
                for (var f in fields) {
                    var value;
                    if (f in sums && sums[f].every(value_exists(row))) {
                        value = sums[f].map(values(row)).reduce(sum);
                    } else {
                        value = parseInt(row[f]) || 0;
                    }
                    fields[f] = Math.max(fields[f], value);
                }
                return fields;
            }
        };
    });
    function sum(result, value) { return result + value; }
    function values(row) { return function(col) { return parseInt(row[col]); }; }
    function value_exists(row) { return function(col) { return row[col] !== null; }; }

    FortiviewSessionsDrilldown.prototype.reloadSessionsQlistData = 
    inject.mark(function($q, fortiviewUtil, fortiviewRouteMetadata, fortiviewVisualization, fortiviewSearchState, adminEvent, fortiviewInterfaceLookup) {
        return function() {
            for (var k in this.maxValues) {
                this.maxValues[k] = 0;
            }

            var reqs = [this.getData()];
            var promise = $q.all(reqs);
            promise.then(function() {
                this.restartAutoReload();
            }.bind(this));
            this.scope.qlistSource = promise.then(function(data) {
                var details = data[0].data.results.details;
                var sum = this.maxSumFields;
                this.calculateMaxima(this.maxValues, details, sum);
                return details;
            }.bind(this));
            promise.then(function(data) {
                this.scope.d3Source = fortiviewVisualization.processSource(
                    data[0].data.results.details, this.sourceSortBy, null, data);
            }.bind(this));
        };
    });

    FortiviewSessionsDrilldown.prototype.getData = 
    inject.mark(function($injector, $route, fortiviewGraph, fortiviewData, fortiviewSearchState, fortiviewRouteMetadata) {
        return function() {
            var sort = this.sourceSortBy || 'Bytes',
                pathParams = $route.current.pathParams, 
                filter = {};
            filter[pathParams.segment] = pathParams.drilldownValue;
            filter[pathParams.tab] = pathParams.drilldownTabValue;

            var params = {
                sort_by: sort,
                filter: filter
            };

            if (!fortiviewSearchState.is_realtime()) {
                params.count = fortiviewData.getRequestCount();
            }

            return fortiviewData.get(params)
            .then(function(result) {
                return result;
            }.bind(this), fail);

            function fail(error) {
                return $injector.invoke(function($log, $q) {
                    Notify.post(error.message, 'error');
                    $log.error(error);
                    return $q.reject(error);
                });
            }
        };
    });

    FortiviewSessionsDrilldown.prototype.set_drilldown_value =
    inject.mark(function(fortiviewSearchState, fortiviewFacets, $location, ftntRoute, $route,
                         $routeParams, $scope, fortiviewUtil) {
        var ss = fortiviewSearchState;

        var addDrilldownValues = function(object, facetIds, values) {
            if (facetIds.length > 1) {
                values = fortiviewUtil.splitDrilldownValues(values);
            } else {
                values = [decodeURIComponent(values)];
            }
            facetIds.forEach(function(id, index) {
                object[id] = [values[index]];
            });
        };

        var getDrilldownValue = function(object, facetIds) {
            function getValue(id) {
                return object[id][0];
            }

            function getEscapeValue(id) {
                return fortiviewUtil.escapeDrilldownValue(object[id][0]);
            }

            return facetIds.length > 1 ? facetIds.map(getEscapeValue).join(':') :
                facetIds.map(getValue);
        };

        var getSegment = function() {
            var segment;
            if ($routeParams.segment) {
                segment = $routeParams.segment + ($routeParams.type ?
                    ('-' + $routeParams.type) : '');
            }
            return segment;
        };

        return function() {
            ss.clear_filters();
            var drilldownValues = {};
            var segment = getSegment();
            var searchFacets = fortiviewFacets.primaryFacets(segment);
            var tabFacets = fortiviewFacets.primaryFacets($routeParams.tab);

            if (searchFacets.length) {
                addDrilldownValues(drilldownValues, searchFacets,
                                   decodeURIComponent($routeParams.drilldownValue));
            }
            if (tabFacets.length) {
                addDrilldownValues(drilldownValues, tabFacets,
                                   decodeURIComponent($routeParams.drilldownTabValue));
            }
            ss.drilldownValues = drilldownValues;

            $scope.$watch('searchState.drilldownValues', function(values, old) {
                var originalPath, routeParams;
                var additional = 0;
                var missing = [];
                if (values !== old) {
                    Object.keys(old).forEach(function(id) {
                        if (!values[id]) {
                            missing.push(id);
                        }
                    });
                    if (!missing.length) {
                        originalPath = $route.current.$$route.originalPath;
                        routeParams = angular.copy($routeParams);
                        routeParams.drilldownValue = getDrilldownValue(values, searchFacets);
                        routeParams.drilldownTabValue = getDrilldownValue(values, tabFacets);
                        $location.path(ftntRoute.interpolate(originalPath, routeParams));
                    } else if ($scope.canGoUp()) {
                        missing.forEach(function(id) {
                            if (tabFacets.indexOf(id) < 0) {
                                additional = 1;
                            }
                        });
                        $scope.goUp(additional);
                    }
                }
            }, true);
        };
    });

    return function(providers, loader) {
        providers.$controller.register('FortiviewSessionsDrilldown', mainCtrl(FortiviewSessionsDrilldown));
        return loader.initModules([
            '../services/util', '../services/searchState', '../services/visualization'
        ].concat(mainCtrl.requires), module);
    };
});
