/*global define*/

define(['module', 'angular'],  function(module) {
    'use strict';

    var SettingsController = function($scope, $location, structure) {
        $scope.$watch('form.$valid', function(value) {
            $scope.disable_dialog_button(0, !value);
        });

        $scope.openThreatWeightSettings = function() {
            $location.path(structure.ngURI('/p/utm/client_reputation/'));
        };
    };

    return function(providers, loader) {
        providers.$controller.register('SettingsController', SettingsController);
        return loader.initModules(['../services/settings'], module);
    };
});
