/*globals define*/
define([
	'module', 'angular', './mainBase'
], function(module, angular, mainCtrl) {
	'use strict';

	function TCountry($injector, $scope, $location, fortiviewUtil, fortiviewSearchState) {
		this.scope = $scope;
		$injector.invoke(this.init, this);

		fortiviewUtil.onLangUpdatedApply($scope,
			'fortiview$root.category_title',
			'{{ "Countries" | lang }}');

		fortiviewSearchState.disableRealtime();

		this.watchSearchState();

		this.drilldownTo = function(entry) {
			$location.path([
				$location.path(),
				encodeURIComponent(entry.srccountry)
			].join('/'));
		};

		$scope.drilldownDisplayItems = this.getSummaryItems([
			'HTNumber', 'services', 'version', 'Bytes', 'time'
		]);

		this.sourceSortBy = "HTNumber";
		$scope.qlistOptions = this.makeQlistConfig({
			prefix: 'qlist_t_country',
			columns: [
				{ selector: 'srccountry', lang_key: 'Country'},
				{ selector: 'HTNumber', lang_key: 'HTTP Transactions'},
				{ selector: 'services', lang_key: 'Service (HTTP/HTTPS)'},
				{ selector: 'version', lang_key: 'HTTP Version (HTTP1.X/HTTP2)'},
				{ selector: 'Bytes', lang_key: 'Bytes (Sent/Received)'},
			],
			default_columns: ['srccountry', 'HTNumber', 'services', 'version', 'Bytes'],
			options: {
				sort_source_order: {
					selector: 'HTNumber',
					direction: 'desc'
				}
			}
		});

		this.initQlist();
	}

	return function(providers, loader) {
		providers.$controller.register('FortiviewTCountry', mainCtrl(TCountry));
		return loader.initModules(mainCtrl.requires, module);
	};
});
