/*globals define*/
define([
	'module', 'angular', './drilldownBase'
], function(module, angular, drilldown) {
	'use strict';

	function TCountryDrilldown($scope, $injector, fortiviewSearchState) {

		$injector.invoke(this.init, this, {
			$scope: $scope,
			blocked_tabs: [
				'sources',
				'policies',
				'destinations',
				'sessions',

				'threat',
				'source',
				'country',
				'action',
				'device',
				'http_method',
				'http_url',

				'tSource',
				"aPolicy",
				"signature_cve_id",
				"owasp_top10"
			]
		});

		fortiviewSearchState.disableRealtime();

		$scope.drilldownDisplayItems = this.getSummaryItems([
			'HTNumber', 'services', 'version', 'Bytes', 'time'
		]);

		$scope.drilldownData = {
			tDestination: {qlistOptions: this.makeQlistConfig('tDestination')},
			tPolicy: {qlistOptions: this.makeQlistConfig('tPolicy')},
			tHttpHost: {qlistOptions: this.makeQlistConfig('tHttpHost')},
			tHttpMethod: {qlistOptions: this.makeQlistConfig('tHttpMethod')},
			tHttpRetcode: {qlistOptions: this.makeQlistConfig('tHttpRetcode')},
			tHttpUrl: {qlistOptions: this.makeQlistConfig('tHttpUrl')},
		};

		this.reloadData();
	}

	return function(providers, loader) {
		providers.$controller.register(
			'FortiviewTCountryDrilldown',
			drilldown(TCountryDrilldown)
		);
		return loader.initModules(drilldown.requires, module);
	};
});
