/*globals define*/
define(['module', 'angular', './mainBase', 'qed_list',
    'widgets', 'ng/services/lang', 'ng/services/injector'
], function(module, angular, mainCtrl) {
    'use strict';

    function Source($injector, $scope, $location, fortiviewUtil, fortiviewSearchState) {
        this.scope = $scope;
        $injector.invoke(this.init, this);
        fortiviewSearchState.disableRealtime();

        fortiviewUtil.onLangUpdatedApply($scope,
            'fortiview$root.category_title', '{{ "Sources" | lang }}');

        this.watchSearchState();

        this.drilldownTo = function(entry) {
            $location.path($location.path() + '/' + encodeURIComponent(entry.src));
        };

        $scope.drilldownDisplayItems = this.getSummaryItems([
            'HTNumber', 'services', 'version', 'Bytes', 'time'
        ]);
        this.sourceSortBy = "HTNumber";
        $scope.qlistOptions = this.makeQlistConfig({
            prefix: 'qlist_source',
            default_columns: ['src', 'HTNumber', 'services', 'version', 'Bytes'],
            columns: [
                { selector: 'src', lang_key: 'Source'},
                { selector: 'HTNumber', lang_key: 'HTTP Transactions'},
                { selector: 'services', lang_key: 'Service (HTTP/HTTPS)'},
                { selector: 'version', lang_key: 'HTTP Version (HTTP1.X/HTTP2)'},
                { selector: 'Bytes', lang_key: 'Bytes (Sent/Received)'},
            ],
            options: {
                sort_source_order: {
                    selector: 'HTNumber',
                    direction: 'desc'
                }
            }
        });

        this.initQlist();
    }

    return function(providers, loader) {
        providers.$controller.register('FortiviewSource', mainCtrl(Source));
        return loader.initModules([
            '../services/util', '../services/searchState', '../services/visualization'
        ].concat(mainCtrl.requires), module);
    };
});
