/*globals define*/
define(['module', 'angular', './drilldownBase', 'fweb.util'],
function(module, angular, drilldown, fweb_util) {
    'use strict';

    function SourceDrilldown($scope, $injector, $interpolate, fortiviewUtil, fortiviewSessions,
    	fortiviewSearchState) {
        var blocked_tabs = [
            "sources",
            "policies",
            "destinations",
            "sessions",
            "threat",
            "source",
            "country",
            "action",
            "device",
            "http_method",
            "http_url",
            "tCountry",
	    "aPolicy",
	    "signature_cve_id",
	    "owasp_top10"
        ];
        $injector.invoke(this.init, this, {$scope: $scope, blocked_tabs: blocked_tabs});

        fortiviewSearchState.disableRealtime();

        $scope.drilldownDisplayItems = this.getSummaryItems([
            'HTNumber', 'services', 'version', 'Bytes', 'time'
        ]);

        angular.extend($scope.excludeDrilldown, {
        });

        $scope.drilldownData = {
            tDestination: {qlistOptions: this.makeQlistConfig('tDestination')},
            tPolicy: {qlistOptions: this.makeQlistConfig('tPolicy')},
            tHttpHost: {qlistOptions: this.makeQlistConfig('tHttpHost')},
            tHttpMethod: {qlistOptions: this.makeQlistConfig('tHttpMethod')},
            tHttpRetcode: {qlistOptions: this.makeQlistConfig('tHttpRetcode')},
            tHttpUrl: {qlistOptions: this.makeQlistConfig('tHttpUrl')},
        };

        this.reloadData();
    }

    return function(providers, loader) {
        providers.$controller.register('FortiviewSourceDrilldown', drilldown(SourceDrilldown));
        return loader.initModules(drilldown.requires, module);
    };

});
