/*globals define*/
define(['module', 'angular', './mainBase'],
function(module, angular, mainCtrl) {
    'use strict';

    /*jshint maxparams:10*/
    function FortiviewThreat($scope, $injector, $location, $q, fortiviewUtil,
                             fortiviewSearchState,
                             fortiviewFacets) {
        this.scope = $scope;
        $injector.invoke(this.init, this);
        fortiviewSearchState.disableRealtime();

        fortiviewUtil.onLangUpdatedApply($scope,
            'fortiview$root.category_title',
            '{{ "Threats" | lang }}');

        this.watchSearchState();

        this.drilldownTo = function(entry) {
            /* FWB_CHANGE var threat_facet = fortiviewFacets.byId('threatname'),
                threat_name = threat_facet.reverseLookup(entry.threat,
                    entry.utm);
            $q.when(threat_name).then(function(threat) {
                $location.path($location.path() + '/' +
                               fortiviewUtil.encodeDrilldownValue(entry.utm) + ':' +
                               fortiviewUtil.encodeDrilldownValue(threat));
            });*/
            $location.path($location.path() + '/' + entry.attack_type);
        };

        /* FWB_CHANGE this.sourceSortBy = 'score';
        $scope.qlistOptions = this.makeQlistConfig({
            prefix: 'qlist_threats',
            default_columns: ['threat', 'type', 'apps', 'category', 'level', 'score', 'sessions'],
            columns: [
                { selector: 'threat', lang_key: 'Threat' },
                { selector: 'utm',   lang_key: 'category' },
                { selector: 'level', lang_key: 'Threat Level' },
                { selector: 'score', lang_key: 'Threat Score (Blocked/Allowed)' },
                { selector: 'sessions', lang_key: 'Sessions' }
            ],
            format_fn: {
                threat: fortiviewUtil.format_fn.threat,
                utm: fortiviewUtil.format_fn.threat_type
            },
            options: {
                sort_source_order: {
                    selector: 'score',
                    direction: 'desc'
                }
            }
        });*/
        $scope.drilldownDisplayItems = this.getSummaryItems([
            'TNumber', 'TScore', 'actions', 'services', 'time'
        ]);
        this.sourceSortBy = "Level";
        $scope.qlistOptions = this.makeQlistConfig({
            prefix: "qlist_threats",
            default_columns: ["attack_type", "Level", "TNumber", "TScore", "actions", "services"],
            columns: [
                { selector: 'attack_type', lang_key: 'Threat'},
                { selector: 'Level', lang_key: 'Threat Level'},
                { selector: 'TNumber', lang_key: 'Threat Number'},
                { selector: 'TScore', lang_key: 'Threat Score'},
                { selector: 'actions', lang_key: 'Action (Block/Alert)'},
            ],
            options: {
                sort_source_order: {
                    selector: 'Level',
                    direction: 'desc'
                }
            }
        });

        this.initQlist();
    }

    return function(providers, loader) {
        providers.$controller.register('FortiviewThreat', mainCtrl(FortiviewThreat));
        return loader.initModules(['../services/util'].concat(mainCtrl.requires), module);
    };

});
