/*globals define*/
define(['module', 'angular', './drilldownBase', 'fgd_common', 'ng/services/injector', 'fweb.util'],
function(module, angular, drilldown, fgd_common, inject) {
    'use strict';

    function ThreatDrilldown($scope, $injector, $interpolate,
                                                  fortiviewSearchState) {
        //FWB_CHANGE var blocked_tabs = ['application', 'policy'];
        //var blocked_tabs = ['sources', 'policies', 'destinations', 'sessions', 'destination'];
        var blocked_tabs = [
            "sources",
            "policies",
            "destinations",
            "sessions",

            "tSource",
            "tCountry",
            "tDestination",
            "tPolicy",
            "tHttpHost",
            "tHttpMethod",
            "tHttpRetcode",
            "tHttpUrl",
	    "aPolicy",
//	    "signature_cve_id"
        ];
        $injector.invoke(this.init, this, {$scope: $scope, blocked_tabs: blocked_tabs});
        this.set_drilldown_text();
        fortiviewSearchState.disableRealtime();

        /*FWB_CHANGE $scope.drilldownDisplayItems = this.getSummaryItems([
            'threat', 'source', 'user', 'device', 'app', 'data', 'cloud', 'common'
        ]);*/
        $scope.drilldownDisplayItems = this.getSummaryItems([
            'Level', 'TNumber', 'TScore', 'actions', 'services', 'time'
        ]);

        /*FWB_CHANGE $scope.drilldownData = {
            source: {qlistOptions: this.makeQlistConfig('source')},
            destination: {qlistOptions: this.makeQlistConfig('destination')},
            country: {qlistOptions: this.makeQlistConfig('country')}
        };*/
        $scope.drilldownData = {
            action: {qlistOptions: this.makeQlistConfig('action')},
            country: {qlistOptions: this.makeQlistConfig('country')},
            source: {qlistOptions: this.makeQlistConfig('source')},
            device: {qlistOptions: this.makeQlistConfig('device')},
            http_method: {qlistOptions: this.makeQlistConfig('http_method')},
            http_url: {qlistOptions: this.makeQlistConfig('http_url')},
	    signature_cve_id: {qlistOptions: this.makeQlistConfig('signature_cve_id')},
	    owasp_top10: {qlistOptions: this.makeQlistConfig('owasp_top10')},
        };
        this.reloadData();
    }

    /**
    * @override
    */
    ThreatDrilldown.prototype.get_drilldown_values = inject.mark(
    function($routeParams, fortiviewUtil) {
        return function() {
            var result = {};
            var values = fortiviewUtil.splitDrilldownValues($routeParams.drilldownValue);
            //FWB_CHANGE result.threattype = [values.shift()];
            //FWB_CHANGE result.threatname = [values.shift()];
            result.attack_type = [values.shift()];//FWB_CHANGE
            return result;
        };
    });

    ThreatDrilldown.prototype.set_drilldown_text =
    inject.mark(function($injector, fortiviewFacets, $q, $scope, $sce) {
        return function() {
            var values = $injector.invoke(this.get_drilldown_values, this),
                //FWB_CHANGE facet = fortiviewFacets.byId('threatname');
                facet = fortiviewFacets.byId("attack_type");
            /*FWB_CHANGE $q.when(facet.lookup(values.threatname, false, values.threattype))
            .then(function(threat_name) {
                if (isNaN(parseInt(values.threatname, 10))) {
                    $scope.drilldownText = threat_name;
                } else {
                    $scope.drilldownText = get_app_icon(values.threatname,
                                                        threat_name);
                }
            });
            function get_app_icon(id, app_name) {
                var html = fgd_common.gen_app_html(id, app_name, {});
                return $sce.trustAsHtml(html);
            }*/
        };
    });

    return function(providers, loader) {
        providers.$controller.register('FortiviewThreatDrilldown', drilldown(ThreatDrilldown));
        return loader.initModules(drilldown.requires, module);
    };


});
