/* globals define */

define(['angular', 'module'], function(angular, module) {
    'use strict';

    function bubbleOptions(fortiviewVisualization) {
        return {
            templateUrl: 'fortiview/partials/bubble_options.html',
            replace: true,
            scope: true,
            link: function(scope) {
                scope.visualization = fortiviewVisualization;
                scope.optionMap = {};
                fortiviewVisualization.BUBBLE_OPTIONS.forEach(function(option) {
                    scope.optionMap[option.type] = option;
                });
            }
        };
    }

    function accessDeviceOptions(fortiviewVisualization, $routeParams) {
        return {
            templateUrl: 'fortiview/partials/access_device_options.html',
            replace: true,
            scope: true,
            link: function(scope) {
                scope.visualization = fortiviewVisualization;
                scope.isPhysicalTopology = function() {
                    return $routeParams.type === fortiviewVisualization.TOPOLOGY_ENUM.PHYSICAL;
                };
            }
        };
    }
    return function(providers, loader) {
        providers.$compile.directive('bubbleOptions', bubbleOptions);
        providers.$compile.directive('accessDeviceOptions', accessDeviceOptions);
        return loader.initModules(['../services/visualization'], module);
    };
});
