/* globals define */

define(['module', 'angular', 'highcharts/highcharts'],
function(module, angular) {
    'use strict';

    function fHighcharts($window, fortiviewSearchState) {
        return {
            restrict: 'A',
            scope: {
                params: '=fHighcharts'
            },
            link: function(scope, elem) {
            	var chart;
            	if(scope.params)
            	    chart = Highcharts.chart(elem[0], scope.params);

                scope.$watch('params', function(params) {
                    if(params)
                        chart = Highcharts.chart(elem[0], params);
                });

                scope.$watch(function() {
                    return {
                        width: elem.width(),
                        height: elem.height()
                    };
                }, function(dimensions) {
                    if (chart && dimensions.height && dimensions.width) {
                        chart.setSize(dimensions.width, dimensions.height);
                    }
                }, true);
            }
        };
    }

    return function(providers, loader) {
        providers.$compile.directive('fHighcharts', fHighcharts);
        return loader.initModules(['../services/searchState'], module);
    };
});
