/* globals define */

define(['module', 'angular', '../services/learningReport'
], function(module, angular, fortiviewLearningReportData) {
    'use strict';
    var TEMPLATE_URL = '/ng/fortiview/partials/f-learning-report-display-options.html';

    function fLearningReportDisplayOptions(loader) {
        return {
            templateUrl: loader.cache_path(TEMPLATE_URL),
            replace: true,
            scope: true,
            bindToController: true,
            controllerAs: 'reportDisplay',
            controller: LearningReportDisplayOptions
        };
    }

    function LearningReportDisplayOptions($scope, injector, fortiviewLearningReportData) {
        injector.injectMarked(this, {$scope: $scope});
        this.reportService = fortiviewLearningReportData;
    }

    LearningReportDisplayOptions.prototype = {
        DISPLAY_MODES: [
            {
                type: 'full',
                lang: 'Full Report'
            },
            {
                type: 'summary',
                lang: 'Report Summary'
            }
        ]
    };

    return function(providers, loader) {
        providers.$compile.directive(
            'fLearningReportDisplayOptions', fLearningReportDisplayOptions);
        return loader.initModules([fortiviewLearningReportData], module);
    };
});
