/* globals define */

define(['angular', 'ng/services/injector'
], function(angular, inject) {
    'use strict';
    var TEMPLATE_URL = '/ng/fortiview/partials/f-learning-report-sections.html';

    function fLearningReportSections(loader) {
        return {
            templateUrl: loader.cache_path(TEMPLATE_URL),
            replace: true,
            scope: true,
            bindToController: true,
            controllerAs: 'learningReportNav',
            controller: LearningReportSections
        };
    }

    function LearningReportSections($scope, injector) {
        injector.injectMarked(this, {$scope: $scope});
        this.selectedSection = 'deployment_methodology';
    }

    LearningReportSections.prototype = {
        selectedSection: null,

        getSection: function() {
            return this.selectedSection;
        },

        gotoSection: inject.mark(function($location, $anchorScroll) {
            return function gotoSection(section) {
                this.selectedSection = section;
                $location.hash(section);
                $anchorScroll();
            };
        })
    };

    return function(providers) {
        providers.$compile.directive('fLearningReportSections', fLearningReportSections);
    };
});
