/*global define*/
define(['angular', 'fgd_common', 'jquery'], function(angular, fgd_common) {
    'use strict';
    /**
    * @ngdoc directive
    * @name ng.directive:fFgdTip
    *
    * @description
    * setup fgd_common tooltips on this element
    *
    * Example
    * <div f-fgd-tip="span.tooltip"><span class='tooltip' ... ></span></div>
    */
    function fFgdTip() {
        return {
            link: function(scope, elem, attr) {
                //TODO: make fromclass configurable?
                fgd_common.setup_tooltips(elem.find(attr.fFgdTip), 'fromclass');
            }
        };
    }
    return function($providers) {
        $providers.$compile.directive('fFgdTip', fFgdTip);
    };
});
