/* globals define */

define(['module', 'angular', 'fweb', 'ng/services/persistent_storage'],
function(module, angular, fweb) {
    'use strict';

    var SHOW_GRAPH_KEY = 'fortiview_show_graph';

    var partials = /* FWB_CHANGE '/' + fweb.CONFIG_GUI_NO +*/ '/ng/fortiview/partials/';

    function graphDropdown($window, fortiviewSearchState, persistentStorage) {
        return {
            templateUrl: partials + 'graph_dropdown.html',
            replace: true,
            scope: {
                graph: '='
            },
            link: function(scope) {
                var previous = persistentStorage.get(SHOW_GRAPH_KEY);
                scope.show_graph = previous != null ? previous : true;

                scope.toggle_show_graph = function() {
                    scope.show_graph = !scope.show_graph;
                    persistentStorage.put(SHOW_GRAPH_KEY, scope.show_graph);
                    angular.element($window).trigger('resize');
                };

                scope.$watch(function() {
                    return fortiviewSearchState.state.timeframe;
                }, function(timeframe) {
                    scope.show = timeframe !== 'realtime';
                });
            }
        };
    }

    return function(providers, loader) {
        providers.$compile.directive('graphDropdown', graphDropdown);
        return loader.initModules(['../services/searchState',
        	'../directives/f-highcharts',//FWB_CHANGE
        	], module);
    };
});
