/* globals define */

define(['angular', '../services/searchState'], function(angular, searchStateRegister) {
    'use strict';

    function timeframeOptions(fortigateInfo, fortiviewSearchState) {
        return {
            templateUrl: 'fortiview/partials/timeframe_options.html',
            replace: true,
            scope: true,
            controller: function($scope) {
                $scope.qtip_options = {
                    hide: {
                        fixed: true,
                        delay: 300
                    }
                };
                $scope.qtip_position = {
                    my: 'top right',
                    at: 'bottom left'
                };
            },
            link: function(scope) {
                var search_state = scope.search_state = fortiviewSearchState;

                /* FWB_CHANGE scope.disk_logging_supported = (
                    fortigateInfo.info.capabilities.disk_logging_supported
                );*/
                scope.disk_logging_supported = true;

                scope.set_period = function(value) {
                    var index;
                    if (typeof value === 'number') {
                        index = value;
                        value = search_state.customHistory[value];
                        search_state.customHistory = search_state.customHistory.slice(index + 1);
                    }
                    search_state.state.timeframe = value;
                    scope.$broadcast('qtip_hide');
                };

                scope.go_back = function() {
                    scope.set_period(0);
                };

                scope.$watch(function() {
                    return search_state.state.timeframe;
                }, function(timeframe) {
                    var is_custom = function(timeframe) {
                        return timeframe.indexOf('custom') === 0;
                    };
                    var parse_timeframe = function(timeframe) {
                        var split, result;
                        if (is_custom(timeframe)) {
                            split = timeframe.split(':');
                            result = {
                                start: split[1] * 1000,
                                end: split[2] * 1000
                            };
                        } else {
                            result = timeframe;
                        }
                        return result;
                    };

                    scope.options = search_state.timeframeOptions.slice();
                    if (is_custom(timeframe)) {
                        scope.custom = parse_timeframe(timeframe);
                        scope.previous_periods = search_state.customHistory.map(parse_timeframe);
                    } else {
                        scope.custom = null;
                        search_state.customHistory = [];
                    }
                    scope.current = timeframe;
                });
            }
        };
    }

    return function(providers, loader) {
        providers.$compile.directive('timeframeOptions', timeframeOptions);
        return loader.initModules([searchStateRegister]);
    };
});
