/* global define */

define(['../services/util', '../services/visualization'],
function(utilRegister, visualizationRegister) {
    'use strict';

    function visualizationControls(lang, loader, fortiviewUtil, fortiviewVisualization) {
        return {
            restrict: 'A',
            scope: {
                sortBy: '=',
                qlistOptions: '='
            },
            templateUrl: loader.base_path('/ng/fortiview/partials/visualization_controls.html'),
            link: function(scope) {
                scope.visualization = fortiviewVisualization;
                scope.$watch('qlistOptions', function(options) {
                    var supported;
                    var sortOptions = [];
                    var columnsMap = {};
                    var sortColumns = options && options.options && options.options.sort_columns;
                    if (sortColumns) {
                        options.columns.forEach(function(column) {
                            columnsMap[column.selector] = column;
                        });
                        Object.keys(sortColumns).forEach(function(selector) {
                            var column = columnsMap[selector];
                            if (column && !column.hidden) {
                                sortOptions.push({
                                    lang: lang(column.lang_key || selector),
                                    value: fortiviewUtil.client_to_server_sort_map[selector]
                                });
                            }
                        });

                        scope.sortOptions = sortOptions;
                        supported = sortOptions.some(function(sortOption) {
                            return scope.sortBy.value === sortOption.value;
                        });
                        if (!supported) {
                            scope.sortBy.value = sortOptions[0].value;
                        }
                    }
                }, true);

                scope.$watch(fortiviewVisualization.isAutoUpdateEnabled, function(enabled) {
                    scope.autoUpdate = enabled;
                });

                scope.$watch('visualization.autoUpdatePaused', function(paused) {
                    scope.paused = paused;
                });

                scope.$watch('sortBy.value', function(value) {
                    if (scope.qlistOptions) {
                        scope.qlistOptions.options.sort_source_order = {
                            selector: fortiviewUtil.server_to_client_sort_map[value],
                            direction: 'desc'
                        };
                    }
                });
            }
        };
    }

    return function(providers, loader) {
        providers.$compile.directive('visualizationControls', visualizationControls);
        return loader.initModules([utilRegister, visualizationRegister]);
    };
});
