/* globals define */

define(['angular', '../services/visualization'], function(angular, visualizationRegister) {
    'use strict';

    function visualizationOptions($window, fortiviewVisualization) {
        return {
            templateUrl: 'fortiview/partials/visualization_options.html',
            replace: true,
            scope: true,
            link: function(scope) {
                scope.visualization = fortiviewVisualization;
                scope.iconMap = {
                    table: 'table',
                    bubble: 'bubbles',
                    bubble_cluster: 'bubbles',
                    country: 'globe',
                    timeline: 'timeline',
                    chord: 'traffic'
                };
            }
        };
    }
    return function(providers, loader) {
        providers.$compile.directive('visualizationOptions', visualizationOptions);
        return loader.initModules([visualizationRegister]);
    };
});
