/*globals define*/
define(['module', 'angular', 'jquery', 'fweb.util', './searchState', './util',
    './routeMetadata', './facets', './loading'
], function(module, angular, $, fweb_util, searchStateR, utilR, routeMetadataR, facetsR, fortiviewLoadingR) {
    'use strict';

    module.cacheLimit = 10; // arbitrarily chosen
    module.cacheId = 'apiMonitorStatisticsDetail';
    // fraction of timespan that a request is considered valid until we request
    // the data again
    // i.e. 720 -> 3600 (1 hour) / 720 = cache for 5 seconds
    // module.cacheRatio = 720;
    module.cacheRatio = 1440;
    // module.cacheSeconds = 5;

    /* jshint maxparams:12 */
    function FortiviewData($http, $q, $cacheFactory, $routeSegment, fortiviewSearchState,
                           fortiviewUtil, fortiviewRouteMetadata, $log, lang, FOSError,
                           fortiviewFacets, fortigateInfo, fortiviewLoading) {

        var HISTORICAL_LIMIT_ENTRIES = 100;
        var FORTIVIEW_DATA_TIMEOUT = 20 * 60 * 1000;//timeout in milliseconds
        //FWB_CHANGE var uri = '/api/v2/monitor/fortiview/statistics';
        var uri = "/ng/fortiview/statistics";
        var abort_uri = "/ng/fortiview/clear";
        var base_params = {
            ip_version: 'ipboth',
            // defaults
            report_by: 'all'
        };
        this.getRequestCount = function() { return HISTORICAL_LIMIT_ENTRIES; };

        var cacheId = module.cacheId;
        var cache = $cacheFactory(cacheId, { capacity: module.cacheLimit });

        /**
         * Retrieve the current api status from the fgt
         * @param  {object} params An object containing the query values
         *               filter_on:  the drilldown target
         *
         *               filter_val: the drilldown value
         *
         *               report_by:
         *                 ( migbase/include/sys_monitors.h - REPORT_BY_ATTR_* )
         *                      "source" "destination" "application"
         *                      "dlp-rule" "dlp-sensor" "policy" "protocol"
         *                      "profile" "all" "user"
         *
         *               show: the primary column to use (required)
         *                   src
         *                   dst
         *                   app
         *                   session
         *               start: unixtime start limit
         *               end: unixtime end limit
         *               count: the limit of entries to return
         *
         * @return {$q.promise}   The http result, or result from cache
         */
        var get = this.get = function(params) {
            // NOTE: this uses manual caching rather than using $http's builtin
            //       caching in order to ignore the order of the values in the
            //       json param
            // TODO: measure the time it takes for a single request, and if it's
            //       within ~4x the request time's completion, use the cached
            //       version
            // don't cache if realtime or end time is newer than current time
            var useCache = !params.realtime && params.end != null;
            var time = Math.floor(Date.now() / 1000);
            var cachedPromise, cacheKey, paramsCacheKey, _ref;
            if (useCache) {
                paramsCacheKey = angular.extend({}, params);
                paramsCacheKey.timespan = paramsCacheKey.end -
                                          paramsCacheKey.start;
                delete paramsCacheKey.end;
                delete paramsCacheKey.start;
                cacheKey = fweb_util.objects.stable_string(paramsCacheKey);
                _ref = cache.get(cacheKey);
                var cache_time = paramsCacheKey.timespan / module.cacheRatio;
                if (_ref && _ref.time > time - cache_time) {
                    cachedPromise = _ref.promise;
                }
            }
            if (cachedPromise != null) { return cachedPromise; }
            var fullParams = makeParams(params);
            /* FWB_CHANGE var httpPromise = $http({
                method: 'GET',
                url: uri,
                // cache: useCache && cache,
                //  uncomment to use built in caching
                params: fullParams
            });*/

            // Added by Nan Mou
            // Change url according to current segment
            var segment = fortiviewRouteMetadata.baseSegment(false);
            var url = uri;
            if (segment == "sources" || segment == "policies") {
                url = "/fortiview/sessions/data_json";
            } else if (segment == "sessions") {
                url = "/fortiview/sessions/sessions_data_json";
            }

            fortiviewLoading.show();
            var httpPromise = $http({
                method: 'GET',
                url: url,
                params: fullParams,
                timeout: FORTIVIEW_DATA_TIMEOUT,
                paramSerializer: function(params) {
                    function serializeValue(v) {
                        if (angular.isObject(v)) {
                            return angular.isDate(v) ? v.toISOString() : angular.toJson(v);
                        }
                        return v;
                    }
                    
                    var parts = [];
                    angular.forEach(params, function(value, key) {
                        if (value === null || angular.isUndefined(value)) return;
                        if (angular.isArray(value)) {
                            angular.forEach(value, function(v) {
                                parts.push(encodeURIComponent(key)  + '=' + encodeURIComponent(serializeValue(v)));
                            });
                        } else {
                            parts.push(encodeURIComponent(key) + '=' + encodeURIComponent(serializeValue(value)));
                        }
                    });

                    return parts.join('&');
                }
            });

            var result = httpPromise.then(function(response) {
                response.params = fullParams;
                /*FWB_CHANGE if (response.data.results.error) {
                    var error = new FOSError(response.data.results.error);
                    return new $q.reject(error);
                }*/
                fortiviewLoading.hide();
                if (response.data.status == 0) {
                    switch(response.data.msg_id) {
                        case -30:
                            top.location.href = "/login";
                            break;
                        case -37:
                            document.location.href = "/noaccess";
                            break;
                        default :
                            document.location.href = "/error?msg=" + response.data.msg_id;
                            break;
                    }
                }

                return response;
            }, function(response) {
                fortiviewLoading.hide();
                if(response.status == -1)
                    abort();
                response.message = "Timeout";
                return $q.reject(response);
            });
            if (useCache) {
                cache.put(cacheKey, { promise: result, time: time });
            }

            return result;
        };
        this.cacheId = cacheId;

        var makeParams = this.makeParams = function(params) {
            var out = angular.extend({}, base_params, params);
            angular.forEach(out, function(key, value) {
                if (value === undefined) {
                    out[key] = '';
                }
            });
            return out;
        };

        // Helpers
        var getUrlParamsForCurrentState = this.getUrlParamsForCurrentState = function(params) {
            var ss = fortiviewSearchState;
            var time_period = {};
            var facets = fortiviewFacets.forCurrent().reduce(by_id, {});
            var query = fortiviewSearchState.getQuery();
            var limit_entries = {};
            if (query.timeframe) {
                if (ss.last_period) {
                    time_period = ss.last_period;
                } else {
                    time_period = ss.get_timeframe_as_range();
                }
                if (!time_period.start) {
                    time_period = {realtime: true};
                }
                delete query.timeframe;
            }
            for (var id in query) {
                if (!(id in facets)) {
                // if (!(id in facets) || id === params.report_by) {
                    delete query[id];
                } else {
                    //give the facet a chance to chime in.
                    var source = time_period.realtime ? 'session' : 'monitor_api';
                    query[id] = facets[id].tweakFilter.api_monitor(
                        query[id], params.report_by, source);
                    if (angular.isArray(query[id])) {
                        // use ',' separate multiple values when send request
                        // to api monitor
                        if (facets[id].meta.multiple_values) {
                            query[id] = query[id].join(',');
                        } else {
                            query[id] = query[id][0];
                        }
                    }
                }
            }
            if (!ss.is_realtime()) {
                limit_entries = {count: HISTORICAL_LIMIT_ENTRIES};
            }
            return angular.extend({ filter: query }, time_period, limit_entries, params);
            function by_id(result, facet) {
                result[facet.id] = facet;
                return result;
            }
        };

        var getForCurrentState = this.getForCurrentState = function(params) {
            return get(getUrlParamsForCurrentState(params));
        };

        /* FWB_CHANGE var _segmentToFieldName = {
            user: 'username',
            'vpn-user': 'vpn',
            'interface-srcintf': 'srcintf',
            'interface-dstintf': 'dstintf',
            'interface-intfpair': 'intfpair',
            'device-physical': 'device',
            'device-logical': 'device'
        };*/
        var _segmentToFieldName = {
            "threat": "attack_type",
            "country": "srccountry",
            "action": "action", 
            "source": "src", 
            "destination": "dst",
            "http_url": "http_url", 
            "http_method": "http_method", 
            "device": "dev_id",

            "tSource": "src",
            "tCountry": "srccountry",
            "tDestination": "dst",
            "tPolicy": "policy",
            "tHttpHost": "http_host",
            "tHttpMethod": "http_method",
            "tHttpRetcode": "http_retcode",
            "tHttpUrl": "http_url",
	    "aPolicy": "policy",
        }

        var segmentToFieldName = this.segmentToFieldName = function(segment) {
            return _segmentToFieldName[segment] || segment;
        };
        var fieldNameForRoute = this.fieldNameForRoute =
            function() {
                return segmentToFieldName(fortiviewRouteMetadata.baseSegment());
            };

        this.getForCurrentSegment = function(params) {
            return getForCurrentState(angular.extend({
                type: getType(),//FWB_CHANGE
                report_by: fieldNameForRoute()
            }, params));
        };

        this.getUrlParamsForCurrentSegment = function(params) {
            var _params = getUrlParamsForCurrentState(angular.extend({
                report_by: fieldNameForRoute()
            }, params));
            return {
                params: makeParams(_params),
                uri: uri
            };
        };

        /* FWB_CHANGE */
        var getType = this.getType = function() {
            var FTVW_MSG_LOG_SUB_EVENT = 0,
                FTVW_MSG_LOG_SUB_ATTACK = 1,
                FTVW_MSG_LOG_SUB_TRAFFIC = 2;
            var types = {
                    'threat': FTVW_MSG_LOG_SUB_ATTACK,
                    'country': FTVW_MSG_LOG_SUB_ATTACK,
                    'tSource': FTVW_MSG_LOG_SUB_TRAFFIC,
                    'tCountry': FTVW_MSG_LOG_SUB_TRAFFIC,
		    'aPolicy': FTVW_MSG_LOG_SUB_ATTACK,
                },
                segment = fortiviewRouteMetadata.baseSegment(false);

            return types[segment] || FTVW_MSG_LOG_SUB_ATTACK;
        }

        //FWB_CHANGE this.getDrilldownSummary = function() {
        // this.getDrilldownSummary = function(sort_by) {
        //     sort_by = sort_by || 'TNumber';//FWB_CHANGE
        //     var config = angular.extend({}, fortiviewSearchState.drilldown_values,
        //         //FWB_CHANGE {'view_level': 'drilldown', 'no_chart': true});
        //         {'sort_by': sort_by, type: getType()});
        //     //FWB_CHANGE return this.getForCurrentSegment(config)
        //     return (fortiviewSearchState.segmentData || this.getForCurrentSegment(config))
        //     .then(function(data) {
        //         //FWB_CHANGE return data.data.results.summary;
        //         var summary = {};
        //         var report_by = fieldNameForRoute();
        //         var query = fortiviewSearchState.getQuery();
        //         var details = data.data.results.details || [];
        //         var start = data.data.results.summary.start;
        //         var end = data.data.results.summary.end;
        //         details.forEach(function(detail) {
        //             if(detail[report_by] == query[report_by])
        //                 summary = detail;
        //         });
        //         angular.extend(summary, {'start': start, 'end': end});
        //         return summary;
        //     });
        // };

        /* FWB_CHANGE */
        // this.getSummary = function(params) {
        //     var config = angular.extend({}, params);
        //     return this.getForCurrentSegment(config)
        //     .then(function(data) {
        //         var summary = {};
        //         var report_by = fieldNameForRoute();
        //         var details = data.data.results.details || [];
        //         var start = data.data.results.summary.start;
        //         var end = data.data.results.summary.end;
        //         details.forEach(function(detail) {
        //             for(var property in detail){
        //                 if(!detail.hasOwnProperty(property)) continue;
        //                 var int_val = parseInt(detail[property]);
        //                 if(!isNaN(int_val)){
        //                 	summary[property] = summary[property] || 0;
        //                     summary[property] += int_val;
        //                 }
        //             } 
        //         });

        //         angular.extend(summary, {'start': start, 'end': end});
        //         return summary;
        //     });
        // };

        /**
        * @param {String} tab name of tab
        * @param {Object} options of api monitor json request
        * @param {Function(tab)} sort_by_fn Function that returns up to date
        *   sort_by value.
        */
        this.getForDrilldownTab = function(tab, options, sort_by_fn) {
            var params = angular.extend({
                type: getType(),//FWB_CHANGE
                report_by: segmentToFieldName(tab)
            }, options);

            if (typeof sort_by_fn === 'function') {
                params.sort_by = sort_by_fn(tab);
            }

            angular.extend(params, fortiviewSearchState.drilldown_values);
            return getForCurrentState(params).then(function(data) {
                var results = data.data.results;
                if (results.summary) {
                    results.graph = results.summary.graph;
                }
                return results;
            });
        };

        this.getRealtimeSessions = function(params) {
            var query = fortiviewSearchState.getQuery();
            Object.keys(query).forEach(function(key) {
                var value = query[key];
                // Sessions API doesn't accept multiple values
                if (Array.isArray(value)) {
                    query[key] = value[0];
                }
            });
            angular.extend(query, params, {
                summary: true,
                count: fortigateInfo.info.lines_per_page
            });
            //FWB_CHANGE return $http.get('/api/v2/monitor/firewall/session', {
            return $http.get('/ng/fortiview/session', {
                params: {json: JSON.stringify(query)}
            });
        };

        this.clearCache = function() {
            cache.removeAll();
        };

        var abort = this.abort = function(argument) {
            $.ajax({
                type: 'GET',
                async: false,
                url: abort_uri
            });
        }

        if (Object.freeze) { Object.freeze(this); }
    }

    return function(providers, loader) {
        providers.$provide.service('fortiviewData', FortiviewData);
        return loader.initModules([searchStateR, utilR, routeMetadataR, facetsR, fortiviewLoadingR]);
    };

});
