/*globals define*/
/*jshint maxparams: 13*/
define(['module', 'angular', 'fweb.util/objects', 'fweb.util/logs', 'fweb.util/legacy',
    'fweb.util/patterns', 'fweb.util/datetime', 'fweb.util/dom', 'jquery', 'ng/services/facets',
    // FWB_CHANGE './sandbox',
    /* FWB_CHANGE '../main',*/ 'fweb.util/shim', 'ng/services/cmdb'
], function(module, angular, fweb_util_o, util_logs, util_legacy, util_patterns,
            fweb_util_d, fDom, $, facetsRegister/*FWB_CHANGE, sandboxRegister*/) {
    'use strict';
    /* jshint maxparams: 17*/
    function FortiviewFacets(fortiviewUtil, fortiviewRouteMetadata, // FWB_CHANGE fortiviewSandbox,
                                         ActiveFacetModel, SearchFacet, CMDB,
                                         fortiviewSearchState,
                                         $q, lang, $window, $injector, $sce,
                                         $routeParams, FOSError, state, Facets, fortigateInfo) {
        var facets = new Facets();
        this.facets = facets;
        //FIXME: circular dependency... UGH
        fortiviewUtil.facets = this;
        // provider for logging api's facet data for intelligent faceted search
        var interfaces;
        var fortiviewFacets = this;

        var LOG_C0_EVENT = 1,
            LOG_C0_TRAFFIC = 2,
            LOG_C0_ATTACK = 3;

        function interfaceGetter() {
            if (!interfaces) {
                var prefs = CMDB.columnFormatPrefs(['name'], {
                    key: 'vdom',
                    pattern: state.current_vdom
                });
                var interfacesCMDB = new CMDB('system', 'interface').fetch(prefs);
                interfaces = interfacesCMDB.$promise.then(function(results) {
                    return $.map(results, pluckName);
                });
            }
            return interfaces;
            //jquery.map lets you return null to skip
            function pluckName(obj) { return obj.name || null }
        }

        function ssidGetter() {
            var prefs = CMDB.columnFormatPrefs(['ssid']);
            var vapCMDB = new CMDB('wireless-controller', 'vap').fetch(prefs);
            var vaps = vapCMDB.$promise.then(function(results) {
                return $.map(results, pluckName);
            });
            return vaps;
            //jquery.map lets you return null to skip
            function pluckName(obj) { return obj.ssid || null }
        }

        function sandboxStatusGetter() {
            return Object.keys(fortiviewSandbox.statusMap).filter(unique()).map(function(id) {
                var status = fortiviewSandbox.statusMap[id],
                    lstatus = fortiviewSandbox.statusLegendMap[status],
                    result = new SearchFacet.ValueOption(
                        String(id),
                        lang('Fortiview::Sandbox::Status::' + status),
                        $sce.trustAsHtml('<span class="legend ' + lstatus + '">&nbsp;' +
                        '</span>')
                    );
                return result;
            });
            function unique() {
                var exists = {};
                return function(id) {
                    var value = fortiviewSandbox.statusMap[id];
                    if (value in exists) {
                        return false;
                    }
                    exists[value] = true;
                    return true;
                };
            }
        }

        function indexSegmentFacets(result, facet) {
            var segments = facet.meta.segments;
            if (segments == null) {
                result.__all__.push(facet);
                return result;
            }
            if (!Array.isArray(segments)) { segments = [segments]; }
            segments.forEach(function(segment) {
                var _ref = result[segment];
                if (_ref == null) { _ref = result[segment] = []; }
                _ref.push(facet);
            });
            return result;
        }

        function appLookup(key, reverse) {
            return fortiviewUtil.get_applications()
                .$promise.then(function(result) {
                    var app;
                    if (!reverse) {
                        app = result.$map.id[key];
                        return app ? app.name : key;
                    } else {
                        app = result.$map.name[key];
                        return String(app ? app.id : key);
                    }
                });
        }

        function webcatLookup(key, reverse) {
            return fortiviewUtil.get_wf_categories()
                .$promise.then(function(result) {
                    var cat;
                    if (!reverse) {
                        cat = result.$all.$map.id[key];
                        return cat ? cat.name : key;
                    } else {
                        cat = result.$all.$map.name[key];
                        return String(cat ? cat.id : key);
                    }
                });
        }

        var reverseLang = {};
        /**
        * non-standard lookup function. 3rd param to be used when
        * there is no threat type in searchState.
        */
        function threatLookup(key, reverse, threatType) {
            if (!threatType) {
                var searchState = $injector.get('fortiviewSearchState');
                if (searchState.drilldownValues) {
                    threatType = searchState.drilldownValues.threattype;
                }
            }
            return fortiviewUtil.get_applications()
                .$promise.then(function(apps) {
                    var type = threatType;
                    if (!type || !(type in apps.categories.$map.name)) {
                        return langLookup(key, reverse);
                    } else {
                        return !reverse ?
                            apps.$map.id[key].name :
                            apps.$map.name[key].id;
                    }

                });
        }

        function langLookup(key, reverse) {
            if (!reverse) {
                var result = String(lang(key));
                reverseLang[result] = key;
                return result;
            } else {
                return reverseLang[String(key)] || key;
            }
        }
        /**
         * internal function used to define the facets used throughout fortiview
         */
        var createFacets = function() {

            function applicationGetter(entries, source) {
                /*jshint validthis: true*/
                var facet = this;
                var out = entries.map(function(entry) {
                    /* could be:
                    * {app_name: 'Appname', appid: 123} (session_table)
                    * {app: 'Appname', appid: 123} (history)
                    * {apps:[{id: 123, name: 'Appname'}]} (monitor_api)
                    */
                    var selector = facet.selectors[source],
                        appId = entry[selector],
                        label = appId;
                    if (appId !== undefined) {
                        label = entry.app_name || entry.app;
                    }
                    if (Array.isArray(appId)) {
                        var app = appId[0];
                        if (app) {
                            /* If the app id is null or 0 then we're dealing with
                            an Unknown app and will use the app's name to filter.
                            The backend supports filtering using "protocol/port"
                            as the value for the app ID */
                            if (!app.id || app.id === 0) {
                                appId = app.name;
                            } else {
                                appId = app.id;
                            }
                            label = app.name;
                        } else {
                            appId = 0;
                            label = null;
                        }
                    }
                    return new SearchFacet.ValueOption(
                        appId || 0,
                        label || lang('unknown')
                    );
                });
                return SearchFacet.uniqCompact(out, pluckKey);
                function pluckKey(app) { return app.key }
            }

            function appTweakFilter(filter) {
                //also add magical 'widget=0' filter (makes things work)
                var result = [
                    {
                        id: 'widget',
                        value: ['0'],
                        logic: {is: {}}
                    }
                ];
                // change the filter id because 'app' is a magic column
                filter.id = 'app';
                if (filter.value[0].indexOf('/') > 0) {
                    updateUnknownFilter();
                } else if (Number(filter.value[0]) === 0) {
                    filter.value = ['0'];
                } else {
                    if (Number(fortiviewSearchState.drilldownContext.appID) === 0) {
                        updateUnknownFilter(true);
                    } else {
                        if (fortiviewSearchState.drilldownContext.appName) {
                            filter.value = [fortiviewSearchState.drilldownContext.appName];
                        }
                    }
                }
                return result;

                function updateUnknownFilter(upperCase) {
                    //fake filter, will skipped after be parsed
                    filter.id = '_service';
                    if (!upperCase) {
                        filter.value = [filter.value[0].toLowerCase()];
                    }

                    result.push({
                        id: 'appcat',
                        value: ['unknown', 'unscanned'],
                        logic: {is: {}}
                    });
                    // the service must exact match; otherwise, searching for 'HTTP'
                    // might return 'HTTPS' entry
                    result.push({
                        id: 'service',
                        value: filter.value,
                        logic: {is: {}},
                        EXACT: 1
                    });
                }
            }

            function appNameTweakFilter(filter, reportBy, source) {
                var appId = filter[0];
                // realtime application still uses application id as filter
                if (source === 'session') {
                    return filter;
                }
                // Bug#290239: montior_api historical uses application name as filter
                // for drilldown
                if (!!fortiviewSearchState.drilldownContext.appName) {
                    return [fortiviewSearchState.drilldownContext.appName];
                }

                var apps = fortiviewUtil.get_applications();
                if (apps.$resolved) {
                    var app = apps.$map.id[appId];
                    if (app) {
                        var appName = app.name;
                        return appName ? [appName] : [appId];
                    }
                }
                return filter;
            }

            function deviceGetter(entries, source) {
                /*jshint validthis: true*/
                var facet = this;
                var out = entries.map(function(entry) {
                    var selector = facet.selectors[source],
                        mac = entry[selector],
                        label = mac;
                    if (mac !== undefined) {
                        label = entry.alias || entry.hostname || entry.mac;
                    }
                    return new SearchFacet.ValueOption(
                        mac,
                        label
                    );
                });
                return SearchFacet.uniqCompact(out, pluckKey);
                function pluckKey(device) { return device.key }
            }

            function apGetter(entries, source) {
                /*jshint validthis: true*/
                var facet = this;
                var out = entries.map(function(entry) {
                    var selector = facet.selectors[source],
                        apsn = entry[selector],
                        ap = entry.ap,
                        label = ap && (ap !== apsn) ? ap + ' (' + apsn + ')' : apsn;

                    return new SearchFacet.ValueOption(
                        apsn,
                        label
                    );
                });
                return SearchFacet.uniqCompact(out, pluckKey);
                function pluckKey(ap) { return ap.key }
            }

            function cloudAppTweakFilter(filter) {
                if (filter.id === 'appid') {
                    var apps = fortiviewUtil.get_applications();
                    var appids = [];
                    //will cause $digest when it resolves anyways.
                    if (apps.$resolved) {
                        var app = apps.$map.id[filter.value[0]];
                        if (app) {
                            var appName = app.name;
                            appName = util_patterns.re_escape(appName);

                            var exprStr = '^' + appName + '_.*',
                                expr = new RegExp(exprStr, 'i'),
                                test = expr.test.bind(expr);
                            appids = Object
                                .keys(apps.$map.name)
                                .filter(test)
                                .map(appId);
                        }
                    }
                    filter.logic.OR = 1;
                    filter.value = appids.concat(filter.value[0]);
                }
                function appId(name) {
                    return String(apps.$map.name[name].id);
                }
            }

            function threatTweakFilter() {
                //also add magical 'widget=0' filter that makes things work!
                return {
                    id: 'widget',
                    value: ['0'],
                    logic: {is: {}}
                };
            }

            function webSearchPhraseTweakFilter(filter) {
                if (filter.id === 'keyword') {
                    filter.EXACT = 1;
                }
            }

            function webDomainTweakFilter(filter) {
                if (filter.id === 'hostname') {
                    //domain.com,*.domain.com
                    filter.logic.OR = 1;
                    filter.value.push('*.' + filter.value[0]);
                }
            }

            function vpn_type_tweak_filter(filter) {
                var drilldownValues = fortiviewSearchState.drilldownValues;
                if (drilldownValues && filter.id === 'tunneltype') {
                    var tunneltype = drilldownValues.tunneltype;
                    if (angular.isArray(tunneltype) && tunneltype.length > 0 &&
                        tunneltype[0] === 'ipsec' && !('tunnelid' in drilldownValues)) {
                        // add tunnelip not 'N/A' to avoid fetch
                        // ipsec static logs
                        return {
                            id: 'tunnelip',
                            value: ['N/A'],
                            logic: {is: {}, NOT: 1}
                        };
                    }
                }
            }

            function vpn_user_tweak_filter(filter) {
                // retrieve ssl vpn events: use 'user' field
                // retrieve ipsec events: use field(Bug#259432)
                // 1) 'xauthuser' when vpnuser is xauthuser
                // 2) 'user' when the vpnuser is a peerid
                // 3) 'rempip'when the vpnuser is a remote ip
                var userfield = fortiviewSearchState.drilldownContext.userfield;
                var drilldownValues = fortiviewSearchState.drilldownValues;
                var vpnuser_map = {
                    'user': 'user',
                    'srcip': 'remip',
                    'xauthuser': 'xauthuser'
                };
                if (drilldownValues) {
                    var tunneltype = drilldownValues.tunneltype;
                    if (angular.isArray(tunneltype) && tunneltype.length > 0 &&
                        tunneltype[0] === 'ipsec') {
                        filter.id = vpnuser_map[userfield] || 'xauthuser';
                    } else {
                        filter.id = 'user';
                    }
                }
            }


            function sandboxStatusTweakFilter(filter) {
                // whitelist statuses
                if (!Array.isArray(filter)) {
                    filter = [filter];
                }
                var statuses = filter.map(statusNames);
                //TODO: return an array (and support that in the back-end) instead of csv
                return Object.keys(fortiviewSandbox.statusMap).filter(hasStatus).join(',');
                function hasStatus(key) {
                    return statuses.indexOf(fortiviewSandbox.statusMap[key]) > -1;
                }
                function statusNames(key) { return fortiviewSandbox.statusMap[key] }
            }

            function _unauthSrcTweakFilter(filter, drilldown_name, orig_id, field_name) {
                var drilldownValues = fortiviewSearchState.drilldownValues;
                if (drilldownValues && filter.id === orig_id) {
                    var values = drilldownValues[drilldown_name];
                    if (Array.isArray(values) && values.length > 0) {
                        var value = values[0];
                        var field = fortiviewSearchState.drilldownContext[field_name];
                        if (value && field) {
                            filter.id = field;
                            filter.value = [value];
                        }
                    }
                }
            }

            /**
             * Depending on src_field1 in the context
             * which comes from the entry is drilled down.
             * the filter could be unchanged or be set to a different id
             */
            function unauthUserTweakFilter(filter) {
                return _unauthSrcTweakFilter(filter, 'unauth_src1', '_user', 'src_field1');
            }

            /**
             * Depending on src_field2 in the context
             * which comes from the entry is drilled down,
             * the filter could be unchanged or be set to a different id.
             */
            function unauthSrcipTweakFilter(filter) {
                return _unauthSrcTweakFilter(filter, 'unauth_src2', '_srcip', 'src_field2');
            }

            /**
             * Depending on dst_field1, dst_field2, unauth_target1, unauth_target2
             * in the context which come from the entry is drilled down,
             * 1) The filter itself could be set to different id, value
             * 2) A new filter field could be added.
             * 3) The filter could be unchanged.
             */
            function unauthTargetTweakFilter(filter) {
                var drilldownValues = fortiviewSearchState.drilldownValues;
                if (drilldownValues && filter.id === '_dstip') {
                    var orig_value = drilldownValues.unauth_target;
                    if (Array.isArray(orig_value) && orig_value.length > 0) {
                        var drilldownContext = fortiviewSearchState.drilldownContext;
                        var field1 = drilldownContext.dst_field1;
                        var field2 = drilldownContext.dst_field2;
                        var v1 = drilldownContext.unauth_target1;
                        var v2 = drilldownContext.unauth_target2;
                        if (v1 && field1) {
                            filter.id = field1;
                            filter.value = [v1];
                        }
                        if (v2 && field2) {
                            return {
                                id: field2,
                                value: [v2]
                            };
                        }
                    }
                }
            }

            function unauthTypeTweakFilter(filter) {
                var drilldownValues = fortiviewSearchState.drilldownValues;
                if (drilldownValues && filter.id === 'logid') {
                    var unauth_type = drilldownValues.unauth_type;
                    if (Array.isArray(unauth_type) && unauth_type.length > 0) {
                        var logid = fortiviewSearchState.drilldownContext.logid;
                        filter.value = [logid];
                    }
                }
            }

            /*FWB_CHANGE var facetDefs = [
                {
                    id: 'application',
                    name: 'Application',
                    selectors: {
                        monitor_api: 'apps',
                        history: 'appid',
                        //FIXME: implement history: 'pcap_id' for cloud-app
                        session: 'apps'
                    },
                    tweakFilter: {
                        history: appTweakFilter,
                        api_monitor: appNameTweakFilter
                    },
                    getValues: applicationGetter,
                    getKey: facetGetAppid,
                    lookup: appLookup,
                    meta: {
                        segments: ['application', 'session']
                    }
                },
                {
                    id: 'srcintf',
                    name: 'Source Interface',
                    selectors: {
                        monitor_api: 'srcintf',
                        history: 'srcintf',
                        session: 'srcintf'
                    },
                    getValues: interfaceGetter,
                    unique: true,
                    meta: {
                        segments: [
                            'source', 'session', 'application', 'destination', 'country', 'threat',
                            'web-category', 'web-domain', 'policy', 'interface-srcintf',
                            'interface-dstintf', 'interface-intfpair', 'device'
                        ]
                    }
                },
                {
                    id: 'dstintf',
                    name: 'Destination Interface',
                    selectors: {
                        monitor_api: 'dstintf',
                        history: 'dstintf',
                        session: 'dstintf'
                    },
                    getValues: interfaceGetter,
                    unique: true,
                    meta: {
                        segments: [
                            'source', 'session', 'application', 'destination', 'country', 'threat',
                            'web-category', 'web-domain', 'policy', 'interface-srcintf',
                            'interface-dstintf', 'interface-intfpair', 'device'
                        ]
                    }
                },
                {
                    id: 'country',
                    name: 'Country',
                    selectors: {
                        monitor_api: 'country',
                        history: 'dstcountry',
                        session: 'country'
                    },
                    meta: {
                        segments: [
                            'source', 'session', 'application', 'destination', 'country', 'threat',
                            'policy', 'interface-srcintf', 'interface-dstintf'
                        ]
                    }
                },
                {
                    id: 'protocol',
                    name: 'Protocol',
                    selectors: {
                        session: 'proto'
                    },
                    meta: {
                        segments: ['session']
                    }
                },
                {
                    id: 'sourceport',
                    name: 'Source Port',
                    selectors: {
                        session: 'sport'
                    },
                    meta: {
                        segments: ['session']
                    }
                },
                {
                    id: 'destport',
                    name: 'Destination Port',
                    selectors: {
                        session: 'dport'
                    },
                    meta: {
                        segments: ['session']
                    }
                },
                {
                    id: 'natsourceaddress',
                    name: 'NAT Source IP',
                    selectors: {
                        session: 'snaddr'
                    },
                    type: 'ip',
                    meta: {
                        segments: ['session']
                    }
                },
                {

                    id: 'natsourceport',
                    name: 'NAT Source Port',
                    selectors: {
                        session: 'snport'
                    },
                    meta: {
                        segments: ['session']
                    }
                },
                {
                    id: 'policyid',
                    name: 'Policy',
                    selectors: {
                        monitor_api: 'policyid',
                        session: 'policyid',
                        history: 'policyid'
                    },
                    getValues: facets.policyIdGetter,
                    sort: SearchFacet.NO_SORT,
                    meta: {
                        segments: [
                            'source', 'session', 'application', 'destination', 'country', 'threat',
                            'web-category', 'web-domain', 'policy', 'interface-srcintf',
                            'interface-dstintf'
                        ]
                    }
                },
                {
                    id: 'fortiasic',
                    name: 'fortiasic',
                    selectors: {
                        // only add facet if model support NPU 
                        session: fortigateInfo.info.capabilities.net_npu ?
                            'accelerated' : null
                    },
                    getValues: function() {
                        // boolean filter: accelerated / not accelerated 
                        return [1, 0].map(function(act) {
                            return new SearchFacet.ValueOption(
                                act,
                                lang('fortiasic_' + act)
                            );
                        });
                    },
                    meta: {
                        segments: [
                            'session'
                        ]
                    }
                },
                {
                    id: 'utmaction',
                    name: 'Security Action',
                    selectors: {
                        monitor_api: 'utmaction',
                        history: 'utmaction'
                    },
                    getValues: function() {
                        return ['allow', 'block', 'traffic-shape', 'reset'].map(function(act) {
                            return new SearchFacet.ValueOption(
                                act,
                                lang('utmaction_' + act)
                            );
                        });
                    },
                    sort: SearchFacet.NO_SORT,
                    meta: {
                        realtime: false,
                        segments: [
                            'source', 'session', 'application', 'destination', 'country', 'threat',
                            'web-category', 'web-domain'
                        ]
                    }
                },
                {
                    id: 'threattype',
                    name: 'Threat Type',
                    selectors: {
                        monitor_api: 'utm',
                        history: 'threattype'
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ['threat']
                    }
                },
                {
                    id: 'threatname',
                    name: 'Threat',
                    selectors: {
                        monitor_api: 'threat',
                        history: 'threatname'
                    },
                    getKey: facetGetThreatid,
                    lookup: threatLookup,
                    tweakFilter: {
                        history: threatTweakFilter
                    },
                    meta: {
                        segments: ['threat', 'session']
                    }
                },
                {
                    id: 'username',
                    name: 'username',
                    meta: {
                        historical: false,
                        segments: ['source']
                    }
                },
                {
                    id: 'shaper',
                    name: 'Traffic Shaper',
                    selectors: {
                        monitor_api: 'shaper',
                        session: 'shaper'
                    },
                    meta: {
                        historical: false,
                        segments: ['source', 'shaper', 'session', 'application']
                    }
                },
                {
                    id: 'web-category',
                    name: 'Category',
                    selectors: {
                        monitor_api: 'category',
                        history: 'cat'
                    },
                    lookup: webcatLookup,
                    getKey: facetGetCategoryid,
                    meta: {
                        segments: ['web-category'],
                        LogType: 'web'
                    }
                },
                {
                    id: 'web-domain',
                    name: 'Domain',
                    selectors: {
                        monitor_api: 'domain',
                        history: 'hostname'
                    },
                    tweakFilter: {
                        history: webDomainTweakFilter
                    },
                    meta: {
                        segments: ['web-domain'],
                        logType: 'web'
                    }
                },
                {
                    id: 'keyword',
                    name: 'Search Phrases',
                    selectors: {
                        monitor_api: 'keyword',
                        history: 'keyword'
                    },
                    tweakFilter: {
                        history: webSearchPhraseTweakFilter
                    },
                    meta: {
                        segments: ['web-search-phrase', 'web-search-phrase-detail'],
                        logType: 'web'
                    }
                },
                {
                    id: 'hostname',
                    name: 'Host Name',
                    selectors: {
                        monitor_api: 'hostname',
                        history: 'hostname'
                    },
                    meta: {
                        segments: ['web-search-phrase-detail'],
                        logType: 'web'
                    }
                },
                {
                    id: 'cloud-user',
                    name: 'Cloud User',
                    selectors: {
                        monitor_api: 'clouduser',
                        history: 'clouduser'
                    },
                    meta: {
                        segments: ['cloud-user', 'session'],
                        logType: 'app'
                    }
                },
                {
                    id: 'cloud-app',
                    name: 'Cloud Application',
                    selectors: {
                        monitor_api: 'apps',
                        history: 'appid'
                    },
                    getValues: applicationGetter,
                    getKey: facetGetAppid,
                    lookup: appLookup,
                    tweakFilter: {
                        history: cloudAppTweakFilter
                    },
                    //the rest is copied from the 'application' facet later
                    meta: {
                        segments: ['cloud-app', 'session'],
                        logType: 'app'
                    }
                },
                {
                    id: 'level',
                    name: 'Severity',
                    selectors: {
                        monitor_api: 'level',
                        history: 'level'
                    },
                    getValues: function() {
                        return ['emergency', 'alert', 'critical', 'error', 'warning'].map(
                            function(level) {
                                return new SearchFacet.ValueOption(
                                    level,
                                    level === 'alert' ? lang('Alert') : lang(level)
                                );
                            });
                    },
                    sort: SearchFacet.NO_SORT,
                    meta: {
                        //FIXME: remove and replace with 'unique'?
                        multiple_values: true,
                        realtime: false,
                        segments: ['system'],
                        logType: 'system_events'
                    }
                },
                {
                    id: 'event',
                    name: 'Event Name',
                    selectors: {
                        monitor_api: 'event',
                        history: 'logdesc'
                    },
                    meta: {
                        segments: ['system'],
                        logType: 'system_events'
                    }
                },
                {
                    id: 'adminuser',
                    name: 'username',
                    selectors: {
                        monitor_api: 'adminuser',
                        history: 'user'
                    },
                    meta: {
                        segments: ['admin'],
                        logType: 'system_events'
                    }
                },
                {
                    id: 'vpnuser',
                    name: 'username',
                    selectors: {
                        monitor_api: 'vpnuser',
                        history: 'user'
                    },
                    tweakFilter: {
                        history: vpn_user_tweak_filter
                    },
                    meta: {
                        segments: ['vpn'],
                        logType: 'vpn_events'
                    }
                },
                {
                    id: 'tunneltype',
                    name: 'vpntype',
                    selectors: {
                        monitor_api: 'tunneltype',
                        history: 'tunneltype'
                    },
                    tweakFilter: {
                        history: vpn_type_tweak_filter
                    },
                    meta: {
                        segments: ['vpn'],
                        logType: 'vpn_events'
                    }
                },
                {
                    id: 'tunnelid',
                    name: 'tunnelid',
                    selectors: {
                        monitor_api: 'tunnelid',
                        history: 'tunnelid'
                    },
                    meta: {
                        segments: ['vpn-user'],
                        logType: 'vpn_events'
                    }
                },
                {
                    id: 'unauth_src1',
                    name: 'username',
                    selectors: {
                        monitor_api: 'unauth_src1',
                        history: '_user'
                    },
                    tweakFilter: {
                        history: unauthUserTweakFilter
                    },
                    meta: {
                        segments: ['unauth'],
                        logType: 'system_events'
                    }
                },
                {
                    id: 'unauth_src2',
                    name: 'srcip',
                    selectors: {
                        monitor_api: 'unauth_src2',
                        history: '_srcip'
                    },
                    tweakFilter: {
                        history: unauthSrcipTweakFilter
                    },
                    meta: {
                        segments: ['unauth'],
                        logType: 'system_events'
                    }
                },
                {
                    id: 'unauth_type',
                    name: 'unauth_type',
                    selectors: {
                        monitor_api: 'unauth_type',
                        history: 'logid'
                    },
                    tweakFilter: {
                        history: unauthTypeTweakFilter
                    },
                    meta: {
                        segments: ['unauth'],
                        logType: 'system_events'
                    }
                },
                {
                    id: 'unauth_cat',
                    name: 'type',
                    selectors: {
                        monitor_api: 'unauth_cat',
                        history: '_cat'
                    },
                    meta: {
                        segments: ['unauth'],
                        logType: 'system_events'
                    }
                },
                {
                    id: 'unauth_target',
                    name: 'dst',
                    selectors: {
                        monitor_api: 'unauth_target',
                        history: '_dstip'
                    },
                    tweakFilter: {
                        history: unauthTargetTweakFilter
                    },
                    meta: {
                        segments: ['unauth'],
                        logType: 'system_events'
                    }
                },
                {
                    id: 'filename',
                    name: 'filename',
                    selectors: {
                        'monitor_api': 'filename'
                    },
                    meta: {
                        segments: ['sandbox-file']
                    }
                },
                {
                    id: 'status',
                    name: 'status',
                    meta: {
                        segments: ['sandbox-file', 'sandbox-source']
                    },
                    getValues: sandboxStatusGetter,
                    sort: function(a, b) {
                        //sort reverse so highest is at the top
                        return n(a.key) - n(b.key);
                        function n(key) {
                            key = fortiviewSandbox.statusMap[key];
                            return fortiviewSandbox.statusOrder.indexOf(key);
                        }
                    },
                    allowUserInput: false,
                    tweakFilter: {
                        api_monitor: sandboxStatusTweakFilter
                    }
                },
                {
                    id: 'checksum',
                    name: 'checksum',
                    selectors: {
                        monitor_api: 'checksum',
                        history: 'analyticscksum'
                    },
                    meta: {
                        segments: ['sandbox-file']
                    }
                },
                {
                    id: 'username',
                    name: 'username',
                    selectors: {
                        monitor_api: 'username'
                    },
                    meta: {
                        segments: ['sandbox-file', 'sandbox-source']
                    }
                },
                {
                    id: 'srcssid',
                    name: 'srcssid',
                    getValues: ssidGetter,
                    selectors: {
                        monitor_api: 'srcssid',
                        history: 'srcssid'
                    },
                    meta: {
                        segments: ['wificlient', 'session']
                    }
                },
                {
                    id: 'wifiuser',
                    name: 'username',
                    selectors: {
                        monitor_api: 'wifiuser'
                    },
                    meta: {
                        segments: ['wificlient']
                    }
                },
                {
                    id: 'devtype',
                    name: 'devtype',
                    selectors: {
                        monitor_api: 'devtype',
                        history: 'devtype'
                    },
                    meta: {
                        realtime: false,
                        segments: ['source', 'wificlient', 'session']
                    }
                },
                {
                    id: 'mac',
                    name: 'Source Device',
                    getValues: deviceGetter,
                    selectors: {
                        monitor_api: 'mac',
                        history: 'srcmac'
                    },
                    meta: {
                        realtime: false,
                        segments: ['source', 'policy', 'wificlient', 'session']
                    }
                },
                {
                    id: 'apsn',
                    name: 'ap',
                    getValues:  apGetter,
                    selectors: {
                        monitor_api: 'apsn',
                        history: 'apsn'
                    },
                    meta: {
                        segments: ['wificlient', 'session']
                    }
                },
                {
                    id: 'srcip',
                    name: 'Source IP',
                    selectors: {
                        monitor_api: 'srcip',
                        history: 'srcip',
                        session: 'saddr'
                    },
                    meta: {
                        realtime: false,
                        segments: ['wificlient', 'session']
                    }
                }
            ];*/
            var facetDefs = [
                {
                    id: "attack_type",
                    name: "Threat",
                    selectors: {
                        monitor_api: "attack_type",
                        history: "attack_type"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["threat", "threatDrilldown", "countryDrilldown", "aPolicyDrilldown"],
                        logType: LOG_C0_ATTACK
                    }
                },
                {
                    id: "srccountry",
                    name: "Country",
                    selectors: {
                        monitor_api: "srccountry",
                        history: "srccountry"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["country", "tCountry", "threatDrilldown", "countryDrilldown", "aPolicyDrilldown", "tCountryDrilldown"]
                    }
                },
                {
                    id: 'signature_cve_id',
                    name: 'CVE ID',
                    selectors: {
                       monitor_api: 'signature_cve_id',
                       history: 'signature_cve_id'
                    },
                    lookup: langLookup,
                    meta: {
                       segments: ["threatDrilldown", "countryDrilldown", "aPolicyDrilldown"]
                    }
                },
		{
		    id: 'owasp_top10',
		    name: 'OWASP Top10',
		    selectors: {
			monitor_api: 'owasp_top10',
			history: 'owasp_top10'
		    },
		    lookup: langLookup,
		    meta: {
			segments: ["countryDrilldown", "threatDrilldown", "aPolicyDrilldown"]
		    }
		},
                {
                    id: "src",
                    name: "src",
                    selectors: {
                        monitor_api: "src",
                        history: "src"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["tSource", "threatDrilldown", "countryDrilldown", "aPolicyDrilldown", "tSourceDrilldown"]
                    }
                },
                {
                    id: "dst",
                    name: "dst",
                    selectors: {
                        monitor_api: "dst",
                        history: "dst"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["tSourceDrilldown", "tCountryDrilldown"]
                    }
                },
                {
                    id: "policy",
                    name: "policy",
                    selectors: {
                        monitor_api: "policy",
                        history: "policy"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["aPolicy", "tSourceDrilldown", "tCountryDrilldown", "aPolicyDrilldown"]
                    }
                },
                {
                    id: "action",
                    name: "action",
                    selectors: {
                        monitor_api: "action",
                        history: "action"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: [],
                        logType: LOG_C0_ATTACK
                    }
                },
                {
                    id: "http_method",
                    name: "HTTP Method",
                    selectors: {
                        monitor_api: "http_method",
                        history: "http_method"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["threatDrilldown", "countryDrilldown", "aPolicyDrilldown", "tSourceDrilldown", "tCountryDrilldown"]
                    }
                },
                {
                    id: "http_url",
                    name: "URL",
                    selectors: {
                        monitor_api: "http_url",
                        history: "http_url"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["threatDrilldown", "countryDrilldown", "aPolicyDrilldown", "tSourceDrilldown", "tCountryDrilldown"]
                    }
                },
                {
                    id: "http_host",
                    name: "Domain",
                    selectors: {
                        monitor_api: "http_host",
                        history: "http_host"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["tSourceDrilldown", "tCountryDrilldown"]
                    }
                },
                {
                    id: "http_retcode",
                    name: "HTTP Response Code",
                    selectors: {
                        monitor_api: "http_retcode",
                        history: "http_retcode"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["tSourceDrilldown", "tCountryDrilldown"],
                        logType: LOG_C0_TRAFFIC
                    }
                },
                {
                    id: "dev_id",
                    name: "dev_id",
                    selectors: {
                        monitor_api: "dev_id",
                        history: "dev_id"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["threatDrilldown", "countryDrilldown", "aPolicyDrilldown"]
                    }
                },
                {
                    id: "sources",
                    name: "Source",
                    selectors: {
                        monitor_api: "sources",
                        history: "sources"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["sources", "policies", "sourcesDrilldown", "policiesDrilldown"],
                        logType: "null"
                    }
                },
                {
                    id: "policies",
                    name: "Policy",
                    selectors: {
                        monitor_api: "policies",
                        history: "policies"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["sources", "policies", "sourcesDrilldown", "policiesDrilldown"],
                        logType: "null"
                    }
                },
                {
                    id: "destinations",
                    name: "Destination",
                    selectors: {
                        monitor_api: "destinations",
                        history: "destinations"
                    },
                    lookup: langLookup,
                    meta: {
                        segments: ["sourcesDrilldown", "policiesDrilldown"],
                        logType: "null"
                    }
                },
            ];

            var defsById = facetDefs.reduce(byId, {});
            defsById['cloud-app'] =
                angular.extend({}, defsById.application, defsById['cloud-app']);
            var fvFacets = facets.constructFacets(facetDefs);
            facets.addFacets(fvFacets);

            function byId(result, facet) {
                result[facet.id] = facet;
                return result;
            }

            function facetGetAppid(entry, source) {
                /*jshint validthis: true*/
                var appId = entry[this.selectors[source]];
                if (Array.isArray(appId)) {
                    var app = appId[0];
                    if (app && app.id) {
                        appId = String(app.id);
                    } else if (app && app.protocol_str) {
                        appId = app.protocol_str + (app.port ? '/' + app.port : '');
                    } else {
                        appId = 0;
                    }
                }
                return String(appId || 0);
            }

            function facetGetThreatid(entry, source) {
                /*jshint validthis: true*/
                var appFacet = fortiviewFacets.byId('application'),
                    appId = appFacet.getKey(entry, source);
                if (!Number(appId)) {
                    appId = SearchFacet.prototype.getKey
                                .call(this, entry, source);
                }
                return appId;
            }

            function facetGetCategoryid(entry, source) {
                /*jshint validthis: true*/
                if (source === 'monitor_api') {
                    return entry.category_id;
                } else {
                    return entry[this.selectors[source]];
                }
            }
        };
        this.byId = facets.byId.bind(facets);

        this.bySelector = function(source) {
            var currentFacets = this.forCurrent();
            return this.fvFacets.reduce(indexBySelector, {});
            function indexBySelector(index, facet) {
                var value = facet.selectors[source];
                if (value && currentFacets.some(matchFacet)) {
                    index[value] = facet;
                }
                return index;

                function matchFacet(sfFacet) {
                    return sfFacet.id === facet.id;
                }
            }
        };
        createFacets();
        this.fvFacets = facets.facets.filter(notLogType);
        // process the facets definitions so that forCurrent can
        // efficiently find the appropriate facets for the current route
        var segmentFacets = this.fvFacets.reduce(indexSegmentFacets, {__all__: []});


        // adopted from ng/log/view/facets.js: initFacets():hasLogType()
        function notLogType(facet) {
            return facet.meta.logTypes === true ||
                !(facet.meta.logTypes || []).length;
        }
        var getWificlientPrimaryFacet = function() {
            var mac = fortiviewSearchState.drilldownContext.mac;
            return mac ? ['mac'] : ['srcip'];
        };

        /*FWB_CHANGE var _primaryFacets = {
            app: ['application'],
            threat: ['threattype', 'threatname'],
            system: ['event'],
            policy: ['policytype', 'policyid'],
            shaper: ['shaper'],
            'interface-srcintf': ['srcintf'],
            'interface-dstintf': ['dstintf'],
            'interface-intfpair': ['srcintf'],
            admin: ['adminuser'],
            vpn: ['vpnuser', 'tunneltype'],
            'vpn-user': ['tunnelid'],
            unauth: ['unauth_src1', 'unauth_src2', 'unauth_type', 'unauth_target'],
            'sandbox-source': ['source'],
            'sandbox-file': ['filename'],
            wificlient: getWificlientPrimaryFacet,
            'web-search-phrase': ['keyword'],
            'web-search-phrase-detail': ['srcip', 'hostname']
        };*/
        var _primaryFacets = {
            threat: ["attack_type"],
            action: ["action"],
            country: ["srccountry"],
            source: ["src"],
            device: ["dev_id"],
            http_method: ["http_method"],
            http_url: ["http_url"],
            tSource: ["src"],
            tCountry: ["srccountry"],
            tDestination: ["dst"],
            tPolicy: ["policy"],
            tHttpHost: ["http_host"],
            tHttpMethod: ["http_method"],
            tHttpRetcode: ["http_retcode"],
            tHttpUrl: ["http_url"],
	    aPolicy: ['policy'],
	    signature_cve_id: ['signature_cve_id'],
	    owasp_top10: ['owasp_top10'],
        };

        var primaryFacets = this.primaryFacets = function(segment) {
            return angular.isFunction(_primaryFacets[segment]) ? _primaryFacets[segment]() :
                _primaryFacets[segment] || (segment ? [segment] : []);
        };

        this.primaryForSegment = function() {
            return primaryFacets(fortiviewRouteMetadata.baseSegment());
        };

        this.forCurrent = function() {
            //var segment = fortiviewRouteMetadata.baseSegment(),
            var segment = fortiviewRouteMetadata.currentSegment(),
                sf = segmentFacets[segment] || [];
            return sf.concat(segmentFacets.__all__);
        };

        this.forSource = function(source) {
            var type = this.getLogType();
            return this.fvFacets.filter(both(forSource, forType));

            function forSource(facet) { return facet.selectors[source] }
            function forType(facet) {
                var facetLogType = facet.meta.logType;

                var is_event_based = ['system_events', 'vpn_events'].indexOf(type) >= 0;
                if (is_event_based) {
                    // prevent filters for forward based logs show up on the event log view
                    return facetLogType === type;
                }

                return !facetLogType || facetLogType === type;
            }
            function both(a, b) { return function(v) { return a(v) && b(v)} }
        };

        this.getLogType = function() {
            /*FWB_CHANGE function getUnauthLogType() {
                var unauth_types = {
                    0: 'system_events',
                    1: 'vpn_events',
                    2: 'user_events',
                    3: 'network_events',
                    4: 'wireless_events',
                    5: 'wad_events',
                    6: 'gtp_events',
                    7: 'endpoint_events',
                    8: 'ha_events',
                    9: 'wireless_events',
                    10: 'compliance'
                };
                var logid = fortiviewSearchState.drilldownContext.logid;
                var subtype = parseInt(logid.substring(2, 4), 10);
                if (subtype in unauth_types) {
                    return unauth_types[subtype];
                } else {
                    return unauth_types[0];
                }
            }

            var types = {
                    'threat': 'threat_history',
                    'web': 'web',
                    'cloud': 'app',
                    'system': 'system_events',
                    'admin': 'system_events',
                    'vpn': 'vpn_events',
                    'unauth': getUnauthLogType
                },*/
            var types = {
                    'threat': LOG_C0_ATTACK,
                    'country': LOG_C0_ATTACK,
		    'aPolicy': LOG_C0_ATTACK,
                    'tSource': LOG_C0_TRAFFIC,
                    'tCountry': LOG_C0_TRAFFIC
                },
                segment = fortiviewRouteMetadata.baseSegment(false),
                route_tab = ($routeParams.tab || '').split('-')[0];

            return angular.isFunction(types[segment]) ? types[segment]() : types[segment] ||
                types[$routeParams.segment] ||
                types[route_tab] || 'fortiview_traffic';
        };

        /**
        * Format a url with the correct search parameters to load json log data.
        * @param {String} tab Tab to get the url for. 'files', 'videos' or 'sessions' are
        *   supported.
        * @param {String[]} [columns] Limit returned columns.
        * @param {ObjectMap(<facetId>:String[])} [filter] Additional filters
        *   to merge with searchState.filter
        * Only 'session' gets the session history or top sessions.
        *   'json' gets the json url for same.
        * All other types will return undefined;
        */
        this.getLogDataUrl = function(tab, columns, filter) {
            var options = this.getLogViewOptions(tab);
            options.columns = columns;
            options.filters = facets.makeQlistFilters(filter, options.extraFilters);
            options.device = 'disk';
            var url = '/p/logs/{{type}}/json/?' +
                'log_device={{device}}&columns={{columns}}&filter={{filters}}';

            return fDom.renderTemplate(url, options);
        };

        /**
         * Get log viewer options based on the tab.
         * @param  {String} tab            Fortiview drilldown tab files|videos|sessions.
         * @param  {Object{prepend:String[], remove:String[]}} [defaultColumnMods] Override
         *                                                     default columns in log view.
         *                                     only be used with the 'session' tab
         * @return {null|Object} {
         *         facetModel: Object,      // key/value[] object where keys are facet ids.
         *         filters: Object[],       // qlist/log filter objects
         *         type: String, - logtype  // log type to use.
         *         defaultColumnMods: Object
         *     }
         */
        this.getLogViewOptions = function(tab, defaultColumnMods) {
            var fullSegment = fortiviewRouteMetadata.baseSegment(true);
            var fCols = {
                prepend: ['rel_time', 'clouduser', 'srcip', 'filename', 'filesize'],
                remove: ['dstip', 'is_archived', 'utmaction', 'appid', 'clouddetails']
            };
            if (fullSegment === 'cloud-app') {
                fCols.remove.push('app');
            } else if (fullSegment === 'cloud-user') {
                fCols.remove.push('clouduser');
            }
            var TAB_CONFIG = {
                    session: null,
                    files: {
                        filters: [
                            {id: 'app', logic: {OR: 1},
                            value: ['*_File.*', '*.Upload', '*.Download']}
                        ],
                        defaultColumns: fCols
                    },
                    videos: {
                        filters: [
                            {id: 'app', logic: {OR: 1},
                            value: ['*_Video.Play']}
                        ],
                        defaultColumns: fCols
                    }
                };
            var filters = [],
                fss = fortiviewSearchState,
                period = fss.last_period,
                validTab = tab in TAB_CONFIG,
                type = this.getLogType(),
                facetModel = angular.extend({}, fss.state.filters, fss.drilldownValues);

            if (period && validTab) {
                if (TAB_CONFIG[tab]) {
                    filters = filters.concat(TAB_CONFIG[tab].filters);
                    defaultColumnMods = TAB_CONFIG[tab].defaultColumns;
                }
                filters.unshift(util_logs.timeSpanFilter(period));

                return {
                    facetModel: facetModel,
                    filters: filters,
                    type: type,
                    defaultColumnMods: defaultColumnMods
                };
            }
            return null;
        };

        // TODO: create a `clean(searchModel)` method that will remove facets
        //       that aren't applicable to the current path

    }
    return function(providers, loader) {
        providers.$provide.service('fortiviewFacets', FortiviewFacets);
        return loader.initModules([facetsRegister/*FWB_CHANGE, sandboxRegister*/]);
    };
});
