/* global define */

define(['module', 'angular', 'jquery'],
function(module, angular, $) {
    'use strict';

    var MIN_GRAPH_PERIOD_SECONDS = 60;

    function Graph(lang, dateFilter, fortiviewSearchState, fortiviewUtil) {
        /*FWB_CHANGE var SETUP = {
            bytes: {
                units: 'KB',
                toFixed: 2,
                data: [
                    {
                        label: lang('Bytes Sent'),
                        key: 'sentbyte',
                        divideBy: 1024,
                        color: 'rgb(230, 166, 165)'
                    },
                    {
                        label: lang('Bytes Received'),
                        key: 'rcvdbyte',
                        divideBy: 1024,
                        color: 'rgb(151, 207, 180)'
                    }
                ]
            },
            sessions: {
                units: lang('Sessions'),
                toFixed: 0,
                data: [
                    {
                        label: lang('Sessions Allowed'),
                        key: 'session_allow',
                        divideBy: 1,
                        color: 'rgb(165, 194, 254)'
                    },
                    {
                        label: lang('Sessions Blocked'),
                        key: 'session_block',
                        divideBy: 1,
                        color: 'rgb(230, 166, 165)'
                    }
                ]
            },
            score: {
                units: lang('Threat Score'),
                toFixed: 0,
                data: [
                    {
                        label: lang('Low'),
                        key: 'score_low',
                        divideBy: 1,
                        hide_if_zero: true,
                        color: 'rgb(212, 251, 255)'
                    },
                    {
                        label: lang('Medium'),
                        key: 'score_medium',
                        divideBy: 1,
                        hide_if_zero: true,
                        color: 'rgb(250, 255, 165)'
                    },
                    {
                        label: lang('High'),
                        key: 'score_high',
                        divideBy: 1,
                        hide_if_zero: true,
                        color: 'rgb(255, 202, 92)'
                    },
                    {
                        label: lang('Critical'),
                        key: 'score_critical',
                        divideBy: 1,
                        hide_if_zero: true,
                        color: 'rgb(243, 46, 43)'
                    }
                ],
                options: {
                    series: {
                        stack: true
                    },
                    lines: {
                        show: true,
                        fill: true,
                        steps: false
                    }
                }

            },
            count: {
                units: lang('events'),
                toFixed: 0,
                data: [
                    {
                        label: lang('events'),
                        key: 'count',
                        divideBy: 1,
                        color: 'rgb(165, 194, 254)'
                    }
                ]
            },
            login_count: {
                units: lang('events'),
                toFixed: 0,
                data: [
                    {
                        label: lang('Logins'),
                        key: 'login_count',
                        divideBy: 1,
                        color: 'rgb(165, 194, 254)'
                    }
                ]
            },
            failure_count: {
                units: lang('events'),
                toFixed: 0,
                data: [
                    {
                        label: lang('Failed Logins'),
                        key: 'failure_count',
                        divideBy: 1,
                        color: 'rgb(230, 166, 165)'
                    }
                ]
            },
            config_changes: {
                units: lang('events'),
                toFixed: 0,
                data: [
                    {
                        label: lang('Configuration Changes'),
                        key: 'config_changes',
                        divideBy: 1,
                        color: 'rgb(165, 194, 254)'
                    }
                ]
            },
            connections: {
                units: lang('Connections'),
                toFixed: 0,
                data: [
                    {
                        label: lang('Connections'),
                        key: 'connections',
                        divideBy: 1,
                        color: 'rgb(165, 194, 254)'
                    }
                ]
            },
            failure_attempt: {
                units: lang('events'),
                toFixed: 0,
                data: [
                    {
                        label: lang('Failed Attempts'),
                        key: 'failure_attempt',
                        divideBy: 1,
                        color: 'rgb(230, 166, 165)'
                    }
                ]
            },
            search_count: {
                units: lang('Counts'),
                toFixed: 0,
                data: [
                    {
                        label: lang('Frequency'),
                        key: 'search_count',
                        divideBy: 1,
                        color: 'rgb(165, 194, 254)'
                    }
                ]
            }
        };*/
        var SETUP = {
            action: {
                units: '',
                toFixed: 0,
                data: [
                    {
                        label: lang('Block'),
                        key: 'Block',
                        divideBy: 1,
                        color: 'rgb(230, 166, 165)'
                    },
                    {
                        label: lang('Alert'),
                        key: 'Alert',
                        divideBy: 1,
                        color: 'rgb(151, 207, 180)'
                    }
                ]
            },
            level: {
                units: '',
                toFixed: 0,
                data: [
                    {
                        label: lang('critical'),
                        key: 'Critical',
                        divideBy: 1,
                        color: 'rgb(217,83,79)'
                    },
                    {
                        label: lang('high'),
                        key: 'High',
                        divideBy: 1,
                        color: 'rgb(226,135,34)'
                    },
                    {
                        label: lang('medium'),
                        key: 'Medium',
                        divideBy: 1,
                        color: 'rgb(243,187,45)'
                    },
                    {
                        label: lang('low'),
                        key: 'Low',
                        divideBy: 1,
                        color: 'rgb(255,228,90)'
                    },
                    // {
                    //     label: lang('Off'),
                    //     key: 'Off',
                    //     divideBy: 1,
                    //     color: 'rgb(192,192,192)'
                    // },
                ]
            },
            HTNumber: {
                units: '',
                toFixed: 0,
                data: [
                    {
                        label: lang('Transaction'),
                        key: 'HTNumber',
                        divideBy: 1,
                        color: 'rgb(230, 166, 165)'
                    }
                ]
            },
        };
        var H_SETUP ={
            h_threat: {
                title: '',
                yAxis: {title: ''}
            },
            h_action: {
                title: '',
                yAxis: {title: ''}
            },
            h_method: {
                title: '',
                yAxis: {title: ''}
            },
            h_retcode: {
                title: '',
                yAxis: {title: ''}
            },
        };

        this.EXEMPT_GRAPH = {
            'last_conn_time': true
        };

        /* FWB_CHANGE */
        this.generate_graph = function(data, graph_key, scope) {
            if(graph_key in H_SETUP)
                return this.generate_highcharts(data, graph_key, scope);
            else
                return this.generate_flot_chart(data, graph_key, scope);
        };

        //FWB_CHANGE this.generate_graph = function(data, graph_type, scope) {
        this.generate_flot_chart = function(data, graph_type, scope) {
            if (!data) {
                return null;
            }
            var timeRange = fortiviewSearchState.get_timeframe_as_range();
            var period = timeRange.end - timeRange.start;
            var count = data.length;
            var jump = (period / count);
            var start = (timeRange.end - (count * jump)) * 1000;
            var end = timeRange.end * 1000;
            //FWB_CHANGE var setup = SETUP[graph_type] || SETUP.bytes;
            var setup = SETUP[graph_type] || SETUP.action;
            var non_zero = {};

            var createData = function() {
                /*FWB_CHANGE var i, j, entry, value;
                var len = data.length;
                var time = start + (jump * 1000) / 2;
                var graphData = setup.data;
                for (j = 0; j < graphData.length; j++) {
                    graphData[j].data = [];
                }
                for (i = 0; i < len; i++) {
                    for (j = 0; j < graphData.length; j++) {
                        entry = graphData[j];
                        value = data[i][entry.key] / entry.divideBy;
                        if (entry.hide_if_zero && value) {
                            non_zero[entry.key] = true;
                        }
                        entry.data.push([time, value]);
                    }
                    time += jump * 1000;

                }*/
                var i, j, entry, value, lineDatas, line;
                var graphData = setup.data;
                for (i = 0; i < graphData.length; i++) {
                    graphData[i].data = [];
                    entry = graphData[i];
                    lineDatas = [];
                    data.forEach(function(e) {
                        if(e.line_name && e.line_name == entry.key)
                            lineDatas = e.numbers || [];
                    });
                    for (j = 0; j < lineDatas.length; j++) {
                        line = lineDatas[j];
                        value = line.line_number / entry.divideBy;
                        if (entry.hide_if_zero && value) {
                            non_zero[entry.key] = true;
                        }
                        entry.data.push([parseInt(line.time)*1000, value]);
                    }
                }

                // If all series are zero, then don't do any filtering (otherwise we will be
                // displaying an empty box)
                if (Object.keys(non_zero).length) {
                    graphData = graphData.filter(function(entry) {
                        return !entry.hide_if_zero || non_zero[entry.key];
                    });
                }
                return graphData;
            };

            var graph = {
                data: createData(),
                options: {
                    xaxis: {
                        //FWB_CHANGE
                        tickFormatter: function(v, axis){
                            return fortiviewUtil.formatLocalTime(v, "HH:mm:ss");
                        },
                        mode: 'time',
                        timezone: 'browser',
                        min: start,
                        max: end
                    },
                    yaxis: {
                        tickFormatter: function(value) {
                            return value + ' ' + setup.units;
                        },
                        min: 0,
                        tickDecimals: 0
                    }
                },
                tooltips: true,
                tooltip_formatter: function(label, x, y) {
                    //FWB_CHANGE var time = dateFilter(x, 'mediumTime');
                    var time = fortiviewUtil.formatLocalTime(x, 'mediumTime');
                    return time + ': ' + y.toFixed(setup.toFixed) + ' ' + setup.units;
                },
                events: {
                    plotselected: function(event, ranges) {
                        var from = (ranges.xaxis.from / 1000).toFixed(0);
                        var to = (ranges.xaxis.to / 1000).toFixed(0);
                        if (to - from < MIN_GRAPH_PERIOD_SECONDS) {
                            $.alert(lang('fv_graph_min_period_warning',
                                        [MIN_GRAPH_PERIOD_SECONDS]));
                        } else {
                            scope.$apply(function() {
                                fortiviewSearchState.customHistory.unshift(
                                    fortiviewSearchState.state.timeframe);
                                fortiviewSearchState.state.timeframe = 'custom:' +
                                    from + ':' + to;
                            }.bind(this));
                        }
                    }.bind(this)
                }
            };
            if (((end - start) / 1000) - 10 > MIN_GRAPH_PERIOD_SECONDS) {
                angular.extend(graph.options, {
                    selection: {
                        mode: 'x'
                    }
                });
            }
            angular.extend(graph.options, setup.options);

            graph.isHighcharts = false;//FWB_CHANGE
            return graph;
        };

        /* FWB_CHANGE */
        this.generate_highcharts = function(data, graph_type, scope) {
            if (!data) {
                return null;
            }
            var setup = H_SETUP[graph_type] || H_SETUP.threat;

            var graph = {
                chart: {
                    type: 'column',
                    height: 200
                },
                colors: ['#BD1F08','#E8A02B','#FFE326','#BDEA2D','#31BD4C','#32A2A6','#2A60A6','#434348','#7429A6','#A63077','#A6602D'],
                title: setup.title,
                xAxis: {categories:[]},
                yAxis: {
                    title: {text: setup.yAxis.title || ''},
                    min: 0
                },
                tooltip: {
                    headerFormat: '<b>{point.x}</b><br/>',
                    pointFormat: '{series.name}: {point.y}<br/>'+$.getInfo('total')+': {point.stackTotal}'
                },
                plotOptions: {
                    column: { stacking: 'normal'},
                    series: { pointWidth: 30 }
                },
                series: [],
                credits: {enabled: false},
            };

            var categories = [];
            var seriesNames = [];
            var i, j;
            for (i = 0; i < data.length; i++) {
                if(categories.indexOf(data[i].time) < 0) {
                    categories.push(fortiviewUtil.formatLocalTime(parseInt(data[i].time)*1000, "HH:mm:ss"));
                }

                var names = Object.getOwnPropertyNames(data[i]).forEach(function (val) {
                    if(val != 'count' && val != 'time' && val != 'time_str' && seriesNames.indexOf(val) < 0)
                        seriesNames.push(val);
                });
            }

            graph.xAxis.categories = categories;

            for (i = 0; i < seriesNames.length; i++) {
                var name = seriesNames[i];
                var s = {name: name, data: []};
                for (j = 0; j < data.length; j++) {
                    s.data[j] = data[j][name] || 0;
                }
                graph.series.push(s);
            }
            
            graph.isHighcharts = true;
            return graph;
        };

        this.getGraphKey = function(segment) {
            var graphKeys = {
                "threat": "level",
                "action": "h_action",
                "country": "action",
                "source": "action",
                "device": "action",
                "http_method": "h_method",
                "http_url": "action",
                "tSource": "HTNumber",
                "tCountry": "HTNumber",
                "tDestination": "HTNumber",
                "tPolicy": "HTNumber",
                "tHttpHost": "HTNumber",
                "tHttpMethod": "h_method",
                "tHttpRetcode": "h_retcode",
                "tHttpUrl": "HTNumber",
		"aPolicy": "action"
            };

            return graphKeys[segment] || 'action';
        }
    }

    return function(providers, loader) {
        providers.$provide.service('fortiviewGraph', Graph);
        return loader.initModules(['searchState'], module);
    };

});
