/*globals define*/
define(['module', 'angular'], function() {
    'use strict';

    function RouteMetadata($routeSegment, $routeParams) {

        // this list should be synced with the list of segments in main.js
        // make a note of the REPORT_BY_ATTR_ convention: create a mapping here
        //if they need to differ

        // also, they currently also have a convention of mapping to a lang_key
        // under `status/status/` (simplified to `status/`)
        /* FWB_CHANGE var availableSegmentBases = [
            'source',
            'destination',
            'application',
            'country',
            'threat',
            'web',
            'cloud',
            'session',
            'unauth',
            'system',
            'admin',
            'vpn',
            'sandbox',
            'wificlient',
            'policy',
            'interface',
            'device',
            'shaper',
            'learningReport'

            // Other possible values of REPORT_BY_ATTR_*
            // 'dlp-rule'
            // 'dlp-sensor'
            // 'protocol'
            // 'profile'
        ];*/
        var availableSegmentBases = [
            "sources",
            "policies",
            "destinations",
            "sessions",
           
            "threat",
            "source",
            "country",
            //"action",
            "device",
            "http_method",
            "http_url",
	    "aPolicy",
	    "signature_cve_id",
	    "owasp_top10",

            "tSource",
            "tCountry",
            "tDestination",
            "tPolicy",
            "tHttpHost",
            "tHttpMethod",
            "tHttpRetcode",
            "tHttpUrl",
        ];

        this.availableSegmentBases = availableSegmentBases;

        this.baseSegment = function(with_type) {
            if (with_type === undefined) { with_type = true }
            var type = $routeParams.type && with_type ?
                '-' + $routeParams.type : '';
            return availableSegmentBases.filter(function(segment) {
                return $routeSegment.startsWith('fortiview.' + segment);
            })[0] + type;
        };

        this.currentSegment = function() {
            var segment = "";
            if($routeSegment.chain && $routeSegment.chain.length)
            {
                var top = $routeSegment.chain[$routeSegment.chain.length-1];
                segment = (top && top.name) ? top.name : "";
            }
            return segment;
        };
    }

    return function(providers) {
        providers.$provide.service('fortiviewRouteMetadata', RouteMetadata);
    };

});
