/*globals define*/
define(['angular', 'fweb.util/datetime', './util', 'ng/services/injector',
    'ng/services/fortigateInfo', 'ng/services/volatile_storage'
], function(angular, fweb_util_d, utilRegister, inject) {
    'use strict';

    function SearchState($rootScope, volatileStorage, fortigateInfo, fortiviewUtil, injector) {
        // this service is used to share all of the data used inside the
        // searchbox that aren't contained in $routeParams. Generally, the data
        // is populated by the fortiview root controller, and read by individual
        // data providers

        injector.injectMarked(this);

        // FWB_CHANGE var capabilities = fortigateInfo.info.capabilities;
        this.state =
            volatileStorage.get('fortiviewSearchState.state') || {};
        // Defaults
        this.state.timeframe = this.state.timeframe || 'realtime';
        this.state.filters = this.state.filters || {};
        // FWB_CHANGE if (!capabilities.disk_logging_supported || this.state.timeframe.indexOf('custom') === 0) {
        if (this.state.timeframe.indexOf('custom') === 0) {
            this.state.timeframe = 'realtime';
        }

        /* FWB_CHANGE this.timeframeOptions = [
            'realtime', '5min', 'hour'
        ];
        if (capabilities.model_level !== 'low') {
            this.timeframeOptions.push('day');
            if (fortigateInfo.logSettings['fortiview-weekly-data'] === 'enable') {
                this.timeframeOptions.push('week');
            }
        }*/
        this.timeframeOptions = [
            'realtime', '5min', 'hour', 'day'
        ];

        if (this.timeframeOptions.indexOf(this.state.timeframe) < 0) {
            this.state.timeframe = 'realtime';
        }

        // Not persisted filters
        this.drilldownValues = {};

        // Combined persisted and not persisted filters
        this.filters = {};

        this.facets = [];
        this.searchOptions = {};
        this.customHistory = [];
        this.drilldownContext = {};
        this.showRightMenu = true;//FWB_CHANGE

        $rootScope.$watch(function() {
            return this.state;
        }.bind(this), function(state, old) {
            if (state !== old) {
                volatileStorage.put('fortiviewSearchState.state', state);
            }
        }, true);

        // Watch persisted and volatile filters to combine into a single filters object for faceted
        // search
        $rootScope.$watch(function() {
            return {
                persisted: this.state.filters,
                volatile: this.drilldownValues
            };
        }.bind(this), function(filters) {
            this.filters = angular.extend({}, filters.persisted, filters.volatile);
        }.bind(this), true);

        // Watch the combined faceted search filters object and update the persisted and volatile
        // filters objects
        $rootScope.$watch(function() {
            return this.filters;
        }.bind(this), function(filters, old) {
            var persisted;
            if (filters !== old) {
                persisted = angular.copy(filters);
                Object.keys(this.drilldownValues || {}).forEach(function(id) {
                    if (!persisted[id]) {
                        delete this.drilldownValues[id];
                    } else {
                        this.drilldownValues[id] = persisted[id];
                        delete persisted[id];
                    }
                }.bind(this));
                this.state.filters = persisted;
            }
        }.bind(this), true);

        this.getQuery = function() {
            var query = {timeframe: this.state.timeframe};

            Object.keys(this.state.filters || {}).forEach(function(id) {
                // return array intead of single value now
                query[id] = this.state.filters[id];
            }.bind(this));
            Object.keys(this.drilldownValues || {}).forEach(function(id) {
                query[id] = this.drilldownValues[id][0];
            }.bind(this));
            return query;
        };

        this.hideFilter = function() {
            this.visible = false;
        };

        this.disableRealtime = function() {

            if (this.state.timeframe === 'realtime') {
                var tfo = this.timeframeOptions
                    .filter(function(o) {
                        return o !== 'realtime';
                    });
                this.state.timeframe = tfo[0];
            }
            this.timeframe_filter = '!realtime';
        };

        this.disableHistorical = function() {
            this.disable_historical = true;
            this.state.timeframe = 'realtime';
        };

        this.setPeriod = function(value) {
            if (this.timeframeOptions.indexOf(value) > -1) {
                this.state.timeframe = value;
            }
        };

        this.clear_timeframe_filter = function() {
            this.disable_historical = false;
            this.visible = true;
            this.timeframe_filter = '!!';
        };

        this.clear_filters = function() {
            this.filters = {};
            this.state.filters = {};
        };

        this.drilldown_values = {};

        this.parse_timeframe_range = function(timeframe) {
            var split, result;
            if (timeframe.indexOf('custom') === 0) {
                split = timeframe.split(':');
                result = {
                    start: split[1],
                    end: split[2]
                };
            } else {
                result = fortiviewUtil.fixTimeRange(fweb_util_d.timeframeRange(timeframe),
                    fortigateInfo.info.timeinfo.offset);
            }
            return result;
        };

        this.get_timeframe_as_range = function() {
            return this.parse_timeframe_range(this.state.timeframe);
        };
    }

    SearchState.prototype = {
        is_realtime: function() {
            return this.state.timeframe === 'realtime';
        },
        init_context_filters: inject.mark(function() {
            return function($scope) {
                $scope.$watchCollection(
                    '[menus.columnPopUp.columnSelector, menus.columnPopUp.columnValue]',
                    function(values) {
                        var columnSelector = values[0];
                        if (columnSelector) {
                            var realtime = this.state.timeframe === 'realtime';
                            var source = realtime ? 'session' : 'history';
                            var facet = this.facets.filter(bySelector(source, columnSelector))[0];
                            var value = values[1];
                            if (typeof value === 'object') {
                                // extract array or object column values to ValueOption objects
                                var row = $scope.menus.columnPopUp.entries[0];
                                value = facet.getKey(row, source);
                            }
                            $scope.columnFilters = facet.contextFilters(value, false);
                            $scope.columnFacet = $scope.columnFilters ? facet : null;
                        } else {
                            $scope.columnFacet = null;
                            $scope.columnFilters = [];
                        }

                        function bySelector(source, selector) {
                            return function(f) { return f.selectors[source] === selector };
                        }
                    }.bind(this));
                $scope.addContextFilter = function(valueOption) {
                    var model = this.filters[$scope.columnFacet.id];
                    if (model === undefined) {
                        model = this.filters[$scope.columnFacet.id] = [];
                    }
                    model.push(valueOption.key);
                }.bind(this);
            };
        }),
        /**
         * Reintegrate filters that are added/updated by the f-log-view component.
         * @param  {Object} facetModel    new facet model.
         * @param  {Object} oldFacetModel Copy of the old facet model.
         */
        logViewFacetModelWatchAction: inject.mark(function() {
            return function logViewFacetModelWatchAction(facetModel, oldFacetModel) {
                var keys = Object.keys(facetModel)
                    .concat(Object.keys(oldFacetModel).filter(notIn(facetModel)));
                keys.forEach(function(key) {
                    if (!angular.equals(facetModel[key], oldFacetModel[key])) {
                        this.state.filters[key] = facetModel[key];
                    }
                }.bind(this));

                function notIn(obj) { return function(key) { return !(key in obj) } }
            };
        })
    };

    return function(providers, loader) {
        providers.$provide.service('fortiviewSearchState', SearchState);
        return loader.initModules([utilRegister]);
    };

});
