/* globals define,convertNumberToUnits */

define(['angular', 'jquery', 'notify', 'widgets', 'fweb.util/dom', 'qed_list',
    './util'
],
function(angular, $, Notify, widgets, dom) {
    'use strict';

    function Sessions($q, $http, lang, fortiviewData, fortiviewUtil, fortigateInfo) {
        var state;

        var resetState = function() {
            state = {
                pageIndex: 0,
                count: 0,
                maxValues: {},
                details: []
            };
        };

        this.loadData = function(pager) {
            if (!pager) {
                resetState();
            }
            var dataPromise = fortiviewData.getRealtimeSessions({
                start: state.pageIndex * fortigateInfo.info.lines_per_page
            });
            //FWB_CHANGE var appsPromise = fortiviewUtil.get_applications().$promise;

            return $q.all([dataPromise/*FWB_CHANGE , appsPromise*/]).then(function(data) {
                var results = data[0].data.results;
                var details = results.details;
                var summary = results.summary;
                fortiviewUtil.calculateMaxima(state.maxValues, details);
                state.count = summary.matched_count;
                details.totalPagedLines = summary.matched_count;
                state.accelerated_count = summary.accelerated_count;
                return (state.details = details);
            });
        };

        this.getEntries = function() {
            return state.details || [];
        };

        this.createQlistConfig = function() {
            var formatFnSeconds = function(td, col, data) {
                var value = data[col.selector];
                return value ? value + 's' : '';
            };

            var fortiasic_format_fn = function(fortiasic) {
                if (fortiasic) {
                    var title = fortiasic + ': ' + state.accelerated_count +
                        ' ' + lang('fortiasic_active');
                    return '<f-icon class="ftnt-np-accelerated" style="float: left" title="' +
                        title + '"></f-icon>';
                }
                return '';
            };

            var config;
            resetState();

            config = {
                // Use the qlist config to pass information to the pop up menu
                remove_session_entries: true,

                prefix: 'fortiview_sessions_realtime',
                columns: [
                    /*FWB_CHANGE {selector: 'saddr', lang_key: 'source'},
                    {selector: 'device', lang_key: 'device'},
                    {selector: 'daddr', lang_key: 'destination'},
                    {selector: 'apps', lang_key: 'application'},
                    {selector: 'data_bytes', lang_key: 'total-bytes'},
                    {selector: 'data_packets', lang_key: 'total-packets'},
                    {selector: 'policyid', lang_key: 'Policy'},
                    {selector: 'srcintf', lang_key: 'Source Interface'},
                    {selector: 'dstintf', lang_key: 'Destination Interface'},
                    {selector: 'sport', lang_key: 's_port'},
                    {selector: 'dport', lang_key: 'd_port'},
                    {selector: 'proto', lang_key: 'proto'},
                    {selector: 'snaddr', lang_key: 'NAT Source'},
                    {selector: 'dnaddr', lang_key: 'NAT Destination'},
                    {selector: 'snport', lang_key: 'NAT Source Port'},
                    {selector: 'dnport', lang_key: 'NAT Destination Port'},
                    {selector: 'duration', lang_key: 'field_duration'},
                    {selector: 'expiry', lang_key: 'Expires'},
                    {selector: 'shaper', lang_key: 'field_traffic-shaper'}*/

                ],
                default_columns: [
                    'saddr', 'device', 'srcintf', 'daddr', 'dstintf', /* FWB_CHANGE'apps',*/ 'data_bytes',
                    'policyid'
                ],
                format_fn: {
                    /*FWB_CHANGE saddr: function(td, col, data) {
                        data = angular.extend({}, data, {
                            report_by: 'source'
                        });
                        return widgets.format_fn.address(td, col, data);
                    },
                    daddr: function(td, col, data) {
                        data =  angular.extend({}, data, {
                            'report_by': 'destination'
                        });
                        return widgets.format_fn.address(td, col, data);
                    },
                    device: function(td, col, data) {
                        data = angular.extend({}, data, {
                            report_by: 'device'
                        });
                        return widgets.format_fn.device(td, col, data);
                    },
                    apps: fortiviewUtil.format_fn.apps,
                    data_bytes: dom.create_compare_bar_qlist_formatter(function() {
                        return state.maxValues.data_bytes;
                    }, function(summed) {
                        return fortiasic_format_fn(this.row.fortiasic) +
                            convertNumberToUnits(summed);
                    }, ['sentbyte', 'rcvdbyte']),
                    data_packets: fortiviewUtil.format_fn.two_compare(function() {
                        return state.maxValues.data_packets;
                    }, ['tx_packets', 'rx_packets']),
                    fortiasic: function(td, col, data) {
                        return fortiasic_format_fn(data.fortiasic);
                    },
                    duration: formatFnSeconds,
                    expiry: formatFnSeconds*/
                },
                paging: {
                    enabled: true,
                    server_side: true,
                    page_lines: fortigateInfo.info.lines_per_page,
                    fetch: function(pageNumber, callback) {
                        state.pageIndex = pageNumber - 1;
                        this.loadData(true).then(function(details) {
                            var data = {
                                total_lines: state.count,
                                source: details
                            };
                            callback(data);
                        });
                    }.bind(this)
                },
                callbacks: {
                    load: function() {
                        widgets.callbacks.load.call(this);
                    },
                    post_paging: function() {
                        widgets.callbacks.load.call(this);
                    }
                }
            };

            /*FWB_CHANGE if (fortigateInfo.info.capabilities.net_npu) {
                config.columns.push({selector: 'fortiasic', lang_key: 'fortiasic'});
            }*/

            return config;
        };
    }

    return function(providers) {
        providers.$provide.service('fortiviewSessions', Sessions);
    };

});
