/*global define*/

define(['module'],  function(module) {
    'use strict';

    var settings = function($q, CMDB, fortiviewVisualization, features) {
        var model = {};
        var guiDisplayModel = new CMDB.Model(null, null, {
            $reset: function() {
                Object.keys(this.$original || {}).forEach(function(key) {
                    if (this.hasOwnProperty(key) && key.indexOf('$') !== 0) {
                        this[key] = this.$original[key];
                    }
                }.bind(this));
            }
        });

        model.features = features;
        model.guiDisplay = new CMDB('log', 'gui-display', {model: guiDisplayModel}).get();
        model.autoUpdate = fortiviewVisualization.getAutoUpdateConfig();

        model.$resolved = false;
        model.$promise = $q.all(features.$get(), model.guiDisplay.$promise).then(function() {
            model.$resolved = true;
        });

        model.reset = function() {
            this.guiDisplay.$reset();
            this.autoUpdate = fortiviewVisualization.getAutoUpdateConfig();
        };

        model.save = function() {
            fortiviewVisualization.setAutoUpdateConfig(this.autoUpdate);
            return this.guiDisplay.$save().$promise;
        };

        return model;
    };

    return function(providers, loader) {
        providers.$provide.factory('fortiviewSettings', settings);
        return loader.initModules(['visualization', '/ng/services/features'], module);
    };
});
