/*global define */
/*jshint maxparams: 13*/
define(['module', 'angular', /* FWB_CHANGE 'ng/app',*/ 'fweb.util/objects', 'fweb.util/dom', 'widgets',
    'fweb.util/templates', 'fweb.util/datetime', 'fweb.util/formatters', //FWB_CHANGE 'ips_common',
    'fgd_common', 'fweb.util/patterns', 'fweb.util/firewallInterfaces'
], function(module, angular, /* FWB_CHANGE app,*/ objects, dom, widgets, templates, datetime, formatters,
            /* FWB_CHANGE ips_common,*/ fgd_common, f_patterns, firewallInterfaces) {
    'use strict';

    function Util($timeout, lang, $interpolate, $filter,
                                       CMDB, $q, fortiviewRouteMetadata, $log,
                                       $resource, $parse, $compile, injector, fortigateInfo) {

        //// General angular helpers

        this.waitForNotNull = function($scope, watchExpression, callback,
                                       unwatcherCallback) {
            var isnull = true, isWaiting = false;
            var waitingContext, waitingArgs;
            var unwatch = $scope.$watch(watchExpression, function() {
                if ($scope.$eval(watchExpression) != null) {
                    isnull = false;
                    unwatch();
                    if (isWaiting) {
                        callback.apply(waitingContext, waitingArgs);
                        waitingContext = null;
                        waitingArgs = null;
                        isWaiting = false;
                    }
                }
            });
            if (unwatcherCallback != null) { unwatcherCallback(unwatch); }
            return function() {
                if (!isnull) {
                    callback.apply(this, arguments);
                } else if ($scope.$eval(watchExpression) != null) {
                    isnull = false;
                    unwatch();
                    callback.apply(this, arguments);
                } else {
                    waitingContext = this;
                    waitingArgs = arguments;
                    isWaiting = true;
                }
            };
        };

        //// Fortiview specific helpers & formatters

        var getDataBytesValue = this.getDataBytesValue = function(row) {
            return +(row.sentbyte || 0) + (+(row.rcvdbyte || 0));
        };
        getDataBytesValue.kind = 'key_row';

        var getDeviceNameValue = this.getDeviceNameValue = function(row) {
            return row.hostname || row.mac;
        };
        getDeviceNameValue.kind = 'key_row';

        this.getQuarantineColumnNameForSegment = function(which, attr) {
            var segmentMap = {
                source: {saddr: 'address'},
                destination: {daddr: 'address'},
                sandbox: {saddr: 'address'}
            }, map = segmentMap[which] || {};
            return map[attr] || attr;
        };

        this.createDefaultSortKeyRow = function(key) {
            var fn = function(row) {
                return row[key];
            };
            fn.kind = 'key_row';
            return fn;
        };

        this.commonBytesFormatter = function(td, col, data) {
            return td == null ? data[col.selector] : formatters.metric_bytes(data[col.selector]);
        };

        this.humanize_seconds = function(value) {
            return datetime.humanize_seconds(value, true);
        };

        function transformMacAddress(s) {
            if (f_patterns.commonRegExp.MAC_ADDRESS.test(s)) {
                return s.replace(/:/g, '-');
            }
            return s;
        }

        function untransformMacAddress(s) {
            var MAC_ADDRESS_TRANSFORMED = /^[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}$/;
            if (MAC_ADDRESS_TRANSFORMED .test(s)) {
                return s.replace(/-/g, ':');
            }
            return s;
        }

        function decodeDrilldownValue(s) {
            return decodeURIComponent(untransformMacAddress(s));
        }

        // the following three methods
        // apply to multiple drilldown values/facets which will be separate by ':'
        this.escapeDrilldownValue = transformMacAddress;

        this.encodeDrilldownValue = function(s) {
            return encodeURIComponent(transformMacAddress(s));
        };

        this.decodeDrilldownValue = decodeDrilldownValue;

        this.splitDrilldownValues = function(values) {
            return values.split(':').map(decodeDrilldownValue);
        };

        this.fixTimeRange = function(range, offset) {
            var fixedRange = {
                start: parseInt(range.start, 10) + parseInt(offset),
                end: parseInt(range.end, 10) + parseInt(offset)
            };
            return angular.extend({}, range, fixedRange);
        };

        function invert(obj) {
            return Object.keys(obj).reduce(do_invert, {});
            function do_invert(result, key) {
                result[obj[key]] = key;
                return result;
            }
        }
        this.invert = invert;

        /*FWB_CHANGE this.client_to_server_sort_map = {
            data_bytes: 'bytes',
            data_packets: 'packets',
            data_bandwidth: 'bandwidth',
            data_shaper_drops: 'shaper_drops',
            score: 'score',
            files: 'files',
            sessions: 'sessions',
            connections: 'connections',
            count: 'count',
            'login_count': 'login_count',
            'failure_count': 'failure_count',
            'config_changes': 'config_changes',
            'last_conn_time': 'last_conn_time',
            'failure_attempt': 'failure_attempt',
            'search_count': 'search_count'
        };*/
        this.client_to_server_sort_map = {
            Level: "Level",
            TNumber: "TNumber",
            TScore: "TScore",
            HTNumber: "HTNumber",
            Bytes: "Bytes",
            requests: "requests",
            sessions: "sessions"
        };

        this.server_to_client_sort_map = invert(this.client_to_server_sort_map);
        this.generateSortFn = function(context, default_sort) {
            var handler = function(info) {
                var old = context.sourceSortBy || default_sort;
                context.sourceSortBy = this.client_to_server_sort_map[
                    info.target_sort.selector];
                if (old !== context.sourceSortBy) {
                    context.reloadQlistData(true);
                }
            }.bind(this);
            handler.kind = 'server';
            /*FWB_CHANGE return {
                data_bytes: handler,
                data_packets: handler,
                data_bandwidth: handler,
                data_shaper_drops: handler,
                count: handler,
                sessions: handler,
                score: handler,
                files: handler,
                connections: handler,
                bandwidth: handler,
                'login_count': handler,
                'failure_count': handler,
                'config_changes': handler,
                'last_conn_time': handler,
                'failure_attempt': handler,
                'search_count': handler
            };*/
            return {
                Level: handler,
                TNumber: handler,
                TScore: handler,
                HTNumber: handler,
                Bytes: handler,
                requests: handler,
                sessions: handler
            };
        };

        /* FWB_CHANGE */
        this.convertCountryNameToCode = function(country) {
            var code = "";
            var country_name = ["Reserved","Asia/Pacific Region","Europe","Andorra","United Arab Emirates","Afghanistan",/*"Antigua and Barbuda"*/"Antigua And Barbuda","Anguilla","Albania","Armenia","Netherlands Antilles",
                "Angola","Antarctica","Argentina","American Samoa","Austria","Australia","Aruba","Azerbaijan",/*"Bosnia and Herzegovina"*/"Bosnia And Herzegovina","Barbados",
                "Bangladesh","Belgium","Burkina Faso","Bulgaria","Bahrain","Burundi","Benin","Bermuda","Brunei Darussalam","Bolivia",
                "Brazil","Bahamas","Bhutan","Bouvet Island","Botswana","Belarus","Belize","Canada","Cocos (Keeling) Islands",/*"Democratic Republic of the Congo"*/"Democratic Republic Of The Congo",
                "Central African Republic","Congo","Switzerland","Cote D'Ivoire","Cook Islands","Chile","Cameroon","China","Colombia","Costa Rica",
                "Cuba","Cape Verde","Christmas Island","Cyprus","Czech Republic","Germany","Djibouti","Denmark","Dominica","Dominican Republic",
                "Algeria","Ecuador","Estonia","Egypt","Western Sahara","Eritrea","Spain","Ethiopia","Finland","Fiji",
                "Falkland Islands (Malvinas)",/*"Federated States of Micronesia"*/"Federated States Of Micronesia","Faroe Islands","France","France, Metropolitan","Gabon","United Kingdom","Grenada","Georgia","French Guiana",
                "Ghana","Gibraltar","Greenland","Gambia","Guinea","Guadeloupe","Equatorial Guinea","Greece",/*"South Georgia and the South Sandwich Islands"*/"South Georgia And The South Sandwich Islands","Guatemala",
                "Guam","Guinea-Bissau","Guyana","Hong Kong","Heard Island and McDonald Islands","Honduras","Croatia","Haiti","Hungary","Indonesia",
                "Ireland","Israel","India","British Indian Ocean Territory","Iraq",/*"Islamic Republic of Iran"*/"Iran","Iceland","Italy","Jamaica","Jordan",
                "Japan","Kenya","Kyrgyzstan","Cambodia","Kiribati","Comoros",/*"Saint Kitts and Nevis"*/"Saint Kitts And Nevis",/*"Democratic People's Republic of Korea"*/"Democratic People'S Republic Of Korea",/*"Republic of Korea"*/"Republic Of Korea","Kuwait",
                "Cayman Islands","Kazakhstan",/*"Lao People's Democratic Republic"*/"Lao People'S Democratic Republic","Lebanon","Saint Lucia","Liechtenstein","Sri Lanka","Liberia","Lesotho","Lithuania",
                "Luxembourg","Latvia",/*"Libyan Arab Jamahiriya"*/"Libya","Morocco","Monaco",/*"Republic of Moldova"*/"Moldova","Madagascar","Marshall Islands","Macedonia","Mali",
                "Myanmar","Mongolia","Macau","Northern Mariana Islands","Martinique","Mauritania","Montserrat","Malta","Mauritius","Maldives",
                "Malawi","Mexico","Malaysia","Mozambique","Namibia","New Caledonia","Niger","Norfolk Island","Nigeria","Nicaragua",
                "Netherlands","Norway","Nepal","Nauru","Niue","New Zealand","Oman","Panama","Peru","French Polynesia",
                "Papua New Guinea","Philippines","Pakistan","Poland",/*"Saint Pierre and Miquelon"*/"Saint Pierre And Miquelon","Pitcairn Islands","Puerto Rico",/*"Palestinian Territory"*/"Palestine","Portugal","Palau",
                "Paraguay","Qatar","Reunion","Romania","Russian Federation","Rwanda","Saudi Arabia","Solomon Islands","Seychelles","Sudan",
                "Sweden","Singapore","Saint Helena","Slovenia","Svalbard and Jan Mayen","Slovakia","Sierra Leone","San Marino","Senegal","Somalia","Suriname",
                /*"Sao Tome and Principe"*/"Sao Tome And Principe","El Salvador",/*"Syrian Arab Republic"*/"Syria","Swaziland",/*"Turks and Caicos Islands"*/"Turks And Caicos Islands","Chad","French Southern Territories","Togo","Thailand",
                "Tajikistan","Tokelau","Turkmenistan","Tunisia","Tonga","Timor-Leste","Turkey",/*"Trinidad and Tobago"*/"Trinidad And Tobago","Tuvalu","Taiwan",
                /*"United Republic of Tanzania"*/"Tanzania","Ukraine","Uganda","United States Minor Outlying Islands","United States","Uruguay","Uzbekistan",/*"Holy See (Vatican City State)"*/"Vatican",/*"Saint Vincent and the Grenadines"*/"Saint Vincent And The Grenadines","Venezuela",
                /*"Virgin Islands, British"*/"British Virgin Islands",/*"Virgin Islands, U.S."*/"U.S. Virgin Islands","Vietnam","Vanuatu",/*"Wallis and Futuna"*/"Wallis And Futuna","Samoa","Yemen","Mayotte","Serbia","South Africa",
                "Zambia","Montenegro","Zimbabwe","Anonymous Proxy","Satellite Provider","Other","Aland Islands","Guernsey",/*"Isle of Man"*/"Isle Of Man","Jersey",
                /*"Saint Barthelemy"*/"Saint Bartelemey","Saint Martin"];

            var country_code = ["RESERVED","AP","EU","AD","AE","AF","AG","AI","AL","AM","AN",
                "AO","AQ","AR","AS","AT","AU","AW","AZ","BA","BB",
                "BD","BE","BF","BG","BH","BI","BJ","BM","BN","BO",
                "BR","BS","BT","BV","BW","BY","BZ","CA","CC","CD",
                "CF","CG","CH","CI","CK","CL","CM","CN","CO","CR",
                "CU","CV","CX","CY","CZ","DE","DJ","DK","DM","DO",
                "DZ","EC","EE","EG","EH","ER","ES","ET","FI","FJ",
                "FK","FM","FO","FR","FX","GA","GB","GD","GE","GF",
                "GH","GI","GL","GM","GN","GP","GQ","GR","GS","GT",
                "GU","GW","GY","HK","HM","HN","HR","HT","HU","ID",
                "IE","IL","IN","IO","IQ","IR","IS","IT","JM","JO",
                "JP","KE","KG","KH","KI","KM","KN","KP","KR","KW",
                "KY","KZ","LA","LB","LC","LI","LK","LR","LS","LT",
                "LU","LV","LY","MA","MC","MD","MG","MH","MK","ML",
                "MM","MN","MO","MP","MQ","MR","MS","MT","MU","MV",
                "MW","MX","MY","MZ","NA","NC","NE","NF","NG","NI",
                "NL","NO","NP","NR","NU","NZ","OM","PA","PE","PF",
                "PG","PH","PK","PL","PM","PN","PR","PS","PT","PW",
                "PY","QA","RE","RO","RU","RW","SA","SB","SC","SD",
                "SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO",
                "SR","ST","SV","SY","SZ","TC","TD","TF","TG","TH",
                "TJ","TK","TM","TN","TO","TL","TR","TT","TV","TW",
                "TZ","UA","UG","UM","US","UY","UZ","VA","VC","VE",
                "VG","VI","VN","VU","WF","WS","YE","YT","RS","ZA",
                "ZM","ME","ZW","A1","A2","O1","AX","GG","IM","JE",
                "BL","MF"];

            if(country_name.indexOf(country)>=0)
                code = country_code[country_name.indexOf(country)];

            return code;
        }

        /* FWB_CHANGE */
        this.formatLocalTime = function(time, format) {
            var fmt = (format ? format : "HH:mm");
            var l_time = time + fortigateInfo.info.timeinfo.timezone_offset*1000;
            return $filter('date')(l_time, fmt, "UTC");
        }

        var _applications = null,
            _wf_cats = null,
            fortiviewUtil = this;
        function extend_apps(apps) {
            var app, details, map;
            for (var i = 0, len = apps.length; app = apps[i], i < len; ++i) {
                if (!app.name) {
                    map = fortiviewUtil.get_applications().$map.id || {};
                    details = map[app.id];
                    if (details) {
                        angular.extend(app, details);
                    }
                }
            }
        }
        function map_attrs(result, obj) {
            for (var attr in result) {
                result[attr][obj[attr]] = obj;
            }
            return result;
        }
        //maybe this belongs in fortiviewData? but then we have a cyclical
        //dependency...
        this.get_applications = function() {
            //~4ms for applications, worth it.
            function add_maps(res) {
                var unknown = {id: 0, name: lang('unknown')};
                res.$map = {
                    id: {'0': unknown},
                    name: {}
                };
                res.$map.name[unknown.name] = unknown;
                res.reduce(map_attrs, res.$map);
                return res;
            }
            if (!_applications) {
                var prefs = {cache: true, ng_cache: true};
                _applications = new CMDB('application', 'name', prefs).fetch();
                _applications.categories = new CMDB('ips', 'attr-map', prefs)
                                                .fetch();
                var applications_done = _applications.$promise.then(add_maps),
                    categories_done = _applications.categories.$promise
                                                   .then(add_maps);
                _applications.$promise = $q.all([applications_done, categories_done])
                .then(function(promises) {
                    return promises[0];
                });
            }
            return _applications;
        };

        /**
        * Resource returned is actually an object with group ids for keys
        * and groups for values. group.members is an array containing the actual
        * categories.
        */
        this.get_wf_categories = function() {
            if (!_wf_cats) {
                var res = $resource('/p/utm/wf/categories/json/');
                _wf_cats = res.get();
                _wf_cats.$promise = _wf_cats.$promise.then(function(cats) {
                    var numeric_keys = Object.keys(cats).filter(Number),
                        cats_length = Math.max.apply(Math, numeric_keys) + 1,
                        cats_arraylike = angular.extend({
                            length: cats_length,
                            reduce: Array.prototype.reduce
                        }, cats);
                    cats.$all = cats_arraylike.reduce(get_cats, []);
                    add_maps(cats.$all);
                    return cats;
                });
            }
            return _wf_cats;

            function get_cats(result, group) {
                result.push.apply(result, group.members);
                return result;
            }
            function add_maps(all_cats) {
                all_cats.$map = {
                    id: {},
                    name: {}
                };
                all_cats.reduce(map_attrs, all_cats.$map);
            }
        };
        this.get_app_icon = injector
            .partial(get_app_icon, null, ['app_id', 'summary']);
        function get_app_icon($routeParams, $sce, app_id, summary) {
            var apps = fortiviewUtil.get_applications();
            var id = Number(summary.application) || Number(app_id);
            return apps.$promise.then(function() {
                var app = isNaN(id) ? {
                    id: 0,
                    name: app_id
                } : apps.$map.id[id];
                var html = fgd_common.gen_app_html(app_id, app.name, summary);
                return $sce.trustAsHtml(html);
            });
        }
        var format_tip_opts = {
            show: {solo: true, effect: false},
            position: {
                at: 'bottom center',
                my: 'top center',
                viewport: 'window'
            }
        };

        this.format_fn = {
            /*FWB_CHANGE address: function(td, col, data) {
                // starting with fv.sandbox, usertype may be an int which denotes the source.
                var userTypeMap = {
                    0: 'auth'
                };
                data = angular.extend({
                    report_by: 'source',
                    username_source: userTypeMap[data.usertype]
                }, data);
                return widgets.format_fn.address(td, col, data);
            },*/
            address: function(el, column, data) {
                var address = data[column.selector] || '';
                var html = '';

                if (data.country_id) {
                    html += widgets.gen_country_flag_icon_by_id(data.country_id, name);
                }
                else if(data.Country){
                    html += widgets.gen_country_flag_icon_by_code(
                        fortiviewUtil.convertCountryNameToCode(data.Country), name);
                }

                return html + address;

            },
            apps: function(el, column, data, $scope) {
                var MAX_APPS = 2;
                extend_apps(data[column.selector]);
                data = angular.copy(data);
                var apps = data[column.selector],
                    tip = '';

                if (apps.length > 1) {
                    apps = apps.filter(function(a) {
                        return a.id > 0 || a.name;
                    });
                    data[column.selector] = apps;
                }
                if (apps.length > MAX_APPS) {
                    data[column.selector] = apps.slice(0, MAX_APPS);
                    var tip_data = angular.copy(data);
                    var tip_apps = apps.slice(MAX_APPS);
                    tip_data[column.selector] = tip_apps;
                    tip = ', <a href="javascript:void 0" ' +
                            'ng-click="show = !show">' +
                        lang('{0} More...', [tip_apps.length]) + '</a>' +
                        '<div f-tip="show" ng-cloak options="options">' +
                        '<div class="extra-apps" f-fgd-tip=".tooltip">' +
                        widgets.format_fn.apps(el, column, tip_data) +
                        '</div></div>';
                    var event_name = 'mouseenter.app_format_fn';
                    el.off(event_name);
                    el.on(event_name, link);
                }
                var content = (widgets.format_fn.apps(el, column, data) ||
                        lang('unknown')) + tip;
                return content;
                function link() {
                    var compiled = $compile(content);
                    var child_scope = $scope.$new();
                    el.off(event_name);
                    var opts = angular.copy(format_tip_opts);
                    opts.position.container = function() {
                        return el.parents('.ql-body-container');
                    };
                    angular.extend(opts, {show: false, hide: false});
                    angular.extend(child_scope, {options: opts, show: false});
                    el.empty().append(compiled(child_scope));
                    widgets.callbacks.load.call(el);
                }
            },
            cloudApps: function(el, column, data, $scope) {
                var apps = fortiviewUtil.get_applications();
                if (apps.$resolved) {
                    return resolve();
                } else {
                    apps.$promise.then(resolve);
                }
                return apps.$resolved ? resolve(false).bind(this) : '';
                function resolve(delayed_result) {
                    /* jshint validthis:true */
                    var appids = data[column.selector] || [{'id': 0}];
                    data[column.selector] = appids.map(lookup_parentid);
                    var result = fortiviewUtil.format_fn.apps(el, column, data, $scope);
                    if (delayed_result !== undefined) {
                        el.html(result);
                    }
                    return result;
                }
                function lookup_parentid(id_obj) {
                    var app = apps.$map.id[id_obj.id];
                    if (app) {
                        var root_name = app.name.split('_');
                        if (root_name.length > 1) {
                            app = apps.$map.name[root_name[0]];
                        }
                    }
                    if (app) {
                        return app;
                    } else {
                        return id_obj;
                    }

                }
            },
            /**
            * generic tooltip verison of cloudFiles formatter
            * @param {String} template angularjs template used for tooltip popup
            * @param {Function(el, column, data, scope)} setupScope Callback. When called the
            *   consumer should modify the scope based on the data
            * @param {Function(el, column, data)} format qlist format function for cell data
            * @returns {Function} qlist formatting function
            */
            ngToolTip: function(template, setupScope, format) {
                /* global $ */
                format = format || $.format_fn['*'];
                return function(el, column, data, $scope) {
                    var eventName = 'mouseover.ngToolTipSetup',
                        result = format(el, column, data);
                    el.off(eventName).on(eventName, mouseEnter);
                    return result;

                    function mouseEnter() {
                        el.off(eventName);
                        var tipStart = '<div f-tip options="options">',
                            compiled =
                                $compile('<div f-tip-target>' + result +
                                    tipStart + template + '</div></div>'),
                            newScope = $scope.$new();
                        newScope.$apply(function() {
                            newScope.options = format_tip_opts;
                            setupScope(el, column, data, newScope);
                            el.empty().append(compiled(newScope));
                        });
                    }

                };
            },
            /*
            * Generate a cloudfiles formatter.
            * @param {string[]|string} [columns] - Column(s) to use for compare-two summary
            * @param {function()} max_fn - Function that retuns the max value
            * @param {string} [tab='files'] - Tab to show (files|videos)
            * @param {boolean} [base_segment=false] - True to only filter on
            *   base segment instead of both cloud-app and cloud-user.
            */
            cloudFiles: function(columns, max_fn, tab, base_segment) {
                var template = '<div f-tip options="options" ' +
                        'promise="files_promise">' +
                    '<ul class="show-files ng-cloak">' +
                    '<li ng-repeat="f in files">' +
                    '<span class="tool_sprite tool_{{ f.$actionClass }}" ' +
                    'title="{{ f.$action | case:\'sentence\' }}"></span>' +
                    '{{ f.filename }}' +
                    '<span class=filecount ng-show="f.count > 1">' +
                        ' {{ f.count }}x</span>' +
                    '<span class=filesize ' +
                        'ng-show="f.$showSize && f.totalsize">' +
                        ' {{ f.totalsize | bytes }} ' +
                        '<span ng-show="f.totalsize != f.filesize" ' +
                            'f-lang=total></span>' +
                    '</span>' +
                    '</li></ul></div>',
                    cols = ['filename', 'app', 'filesize'];
                var format = Array.isArray(columns) ?
                    fortiviewUtil.format_fn.file_compare(max_fn, columns) :
                    fortiviewUtil.format_fn.one_compare(max_fn, columns);

                return function(el, column, data, $scope) {
                    var count = Array.isArray(columns) ?
                        columns.map(values(data)).reduce(sum) :
                        data[column.selector];
                    if (Number(count) === 0) {
                        return '';
                    }
                    var result = format(el, column, data),
                    //add mousedown/touchstart for touch?
                    event_name = 'mouseenter.cloud_files';
                    var filter_segments = base_segment ?
                        [fortiviewRouteMetadata.baseSegment(true)] :
                        ['cloud-user', 'cloud-app'];
                    //if base_segment isn't passed in, use both cloud segments
                    var filter = filter_segments.reduce(filter_add, {}),
                        url = fortiviewUtil.facets
                            .getLogDataUrl(tab || 'files', cols,
                                filter),
                    //contains filters for timespan and current search.
                    //calculate each time
                    //TODO: somehow separate filters and pass as params?
                        filesResource = $resource(url);
                    el.off(event_name);
                    el.on(event_name, mouse_enter);
                    return result;

                    function mouse_enter() {
                        el.off(event_name);
                        var new_scope;
                        $scope.$apply(function() {
                            var compiled = $compile('<div f-tip-target>' + result +
                                template + '</div>');
                            new_scope = $scope.$new();
                            angular.extend(new_scope, {
                                files_res: filesResource.get(),
                                options: format_tip_opts
                            });
                            el.empty().append(compiled(new_scope));

                            new_scope.files_res.$promise.then(function() {
                                new_scope.files_res.source.forEach(augment_file);
                                new_scope.files = new_scope.files_res.source
                                    .reduce(unique, []);
                                var deferred =  $q.defer();
                                new_scope.files_promise = deferred.promise;
                                get_more(deferred, new_scope.files_res);
                            }, fail);
                        });
                        function augment_file(file) {
                            file.$showSize = /_\w+\.(Upload|Download)/
                                .test(file.app);
                            file.totalsize = file.filesize || 0;
                            //File.Download -> download
                            file.$actionClass = (file.app.split('.')[1] ||
                                '').toLowerCase();
                            file.$action = (file.app.split('_')[1] || '')
                                .replace(/\./g, ' ');
                            file.count = 1;
                        }
                        function get_more(deferred, res, fetched, session_id) {
                            fetched = (fetched || 0) + res.source.length;
                            session_id = session_id || res.session_id;
                            if (session_id) {
                                $timeout(do_get_more, 100, false);
                            } else {
                                done();
                            }
                            function do_get_more() {
                                if (res.completed < 100) {
                                    var more = filesResource.get({
                                        session_id: session_id,
                                        fetched: fetched
                                    });
                                    more.$promise.then(function() {
                                        more.source.forEach(augment_file);
                                        more.source.reduce(unique, new_scope.files);
                                        get_more(deferred, more, fetched,
                                            session_id);
                                    }, fail);
                                } else {
                                    done();
                                }
                            }
                            function done() {
                                new_scope.$root.$apply(
                                    deferred.resolve.bind(deferred, new_scope.files)
                                );
                            }
                        }
                        function unique(result, file) {
                            //Array.prototype.find() in es6
                            var found = result.filter(file_match(file))[0];
                            if (found) {
                                ++found.count;
                                found.totalsize += file.filesize;
                            } else {
                                result.push(file);
                            }
                            return result;
                        }
                        function file_match(afile) {
                            return function(bfile) {
                                return bfile.filename === afile.filename &&
                                    (!bfile.$showSize ||
                                     afile.size === bfile.size);
                            };
                        }
                        function fail(error) {
                            $log.error(error);
                        }
                    }
                    function filter_add(filter, id) {
                        var facet = fortiviewUtil.facets.byId(id),
                            value = facet.getKey(data, 'monitor_api');
                        if (value) {
                            filter[id] = [value];
                        }
                        return filter;
                    }
                };
            },
            country: function(el, column, data) {
                var name = data[column.selector] || '';
                var html = '';
                el.addClass('left');
                if (data.country_id) {
                    html += widgets.gen_country_flag_icon_by_id(data.country_id, name);
                }
                /* FWB_CHANGE */
                else if(data.srccountry){
                    html += widgets.gen_country_flag_icon_by_code(
                        fortiviewUtil.convertCountryNameToCode(data.srccountry), name);
                }

                return html + name;
            },
            threat: function(el, column, data) {
                var result;
                if (data.type === 'app') {
                    column = angular.extend({}, column, {selector: 'apps'});
                    result = fortiviewUtil.format_fn.apps(el, column, data);
                    angular.element(el).removeClass('apps');
                } else {
                    result = String(lang(data[column.selector]));
                }
                return result;
            },
            threat_type: function(el, column, data) {
                //el is not present when obtaining filter value to search!
                if (el) {
                    if (data.type === 'app') {
                        return data[column.selector];
                    } else {
                        return String(lang(data[column.selector]));
                    }
                } else {
                    return data[column.selector];
                }
            },
            bytes_compare: function(max_fn, keys) {
                if (angular.isArray(keys) && keys.length === 2) {
                    return dom.create_compare_bar_qlist_formatter(max_fn, null, keys);
                }
                return dom.create_compare_bar_qlist_formatter(max_fn, null,
                                                              ['sentbyte', 'rcvdbyte']);
            },
            /* FWB_CHANGE */
            // Added by Nan Mou
            fwb_bytes_compare: function(max_fn, keys, format) {
                return function($td, column, data) {
                    format = format || function(summed, values) {
			 var vals = values.map(function(bytes) {
				 return formatters.metric_bytes(bytes);
			 });
			 return vals.join('/');
                        //return formatters.metric_bytes(summed) || 0;
                    };
                    keys = keys || [];
                    var values = keys.map(function(key) {
                        return parseInt(data[key]);
                    });

                    var max = max_fn();
                    var summed = values.reduce(function(previous, current) {
                        return previous + current;
                    });
                    var width = (summed / max * 100).toFixed(0);
                    var colors = [
                    dom.COMPARE_BAR.COLORS.RED,
                    dom.COMPARE_BAR.COLORS.GREEN
                    ];
                    var caption;
                    if (format) {
                        caption = format.apply(this, [summed, values]);
                    }

                    var inner_style = 'width: ' + width + '%;';
                    if (!summed) {
                        inner_style += ' display: none;';
                    }
		    // modify for mantis bug 444803
                    var html = '<div class="compare-bar-container ' + '">';
                    if (keys.length > 0) {
                        var i, len = values.length;
                        var tip = '<div f-tip style="display: none;"><table class="table key-value"><tbody>';
                        for (i = 0; i < len; i++)
                            tip += "<tr><td>" + $.getInfo(keys[i]) + "</td><td>{{" + values[i] + " | number }}</td></tr>";
                        tip += "</tbody></table></div>";
                    }

                    html += '<div class="compare-bar-caption" style="width: 10em;">' + caption + '</div>';
                    html += '<div class="compare-bar-outer"' + (tip ? ' f-tip-target' : '') + ' style="min-width: 5em; ">';
                    html += tip ? tip : '';
                    html += '<div class="compare-bar-inner" style="' + inner_style + '">';
                    values.forEach(function(value, index) {
                        var width;
                        var color = colors[index];
                        var valueClass = 'compare-bar-value';
                        var style = 'background-color: ' + color + ';';
                        if (index === values.length - 1) {
                            valueClass += ' grow';
                        } else {
                            width = (value / summed * 100).toFixed(0);
                            style += ' width: ' + width + '%;';
                        }
                        html += '<div class="' + valueClass + '" style="' + style + '"></div>';
                    });
                    html += '</div></div></div>';
                    return html;

                };
            },
            two_compare: function(max_fn, keys, format) {
                format = format || function(summed) {
                    return summed || 0;
                };
                return dom.create_compare_bar_qlist_formatter(max_fn, format, keys, [
                    dom.COMPARE_BAR.COLORS.RED,
                    dom.COMPARE_BAR.COLORS.BLUE
                ]);
            },
            one_compare: function(max_fn, key, format, color) {
                format = format || function(summed) {
                    return summed || 0;
                };
                var color_map = {
                    'red': dom.COMPARE_BAR.COLORS.RED
                };
                return dom.create_compare_bar_qlist_formatter(max_fn, format, [key], [
                    color_map[color] || dom.COMPARE_BAR.COLORS.BLUE
                ]);
            },
            file_compare: function(max_fn, keys) {
                var format = function(total, values) {
                    return values.join('/');
                };
                return dom.create_compare_bar_qlist_formatter(max_fn, format, keys);
            },
            count_compare: function(max_fn) {
                return function($td, column, data) {
                    if (data.session_allow == null) {
                        return dom.compare_bar({
                            max: max_fn(),
                            values: [data.sessions || 0],
                            format_fn: function(summed) {
                                return summed;
                            },
                            colors: [dom.COMPARE_BAR.COLORS.BLUE]
                        });
                    } else {
                        return dom.compare_bar({
                            max: max_fn(),
                            values: [data.session_block, data.session_allow],
                            format_fn: function(summed) {
                                return summed;
                            },
                            colors: [
                                dom.COMPARE_BAR.COLORS.RED,
                                dom.COMPARE_BAR.COLORS.BLUE
                            ]
                        });
                    }
                };
            },
            /* FWB_CHANGE */
            fwb_count_compare: function(max_fn, keys, format) {
                return function($td, column, data) {
                    format = format || function(summed, values) {
                        var vals = values.map(function(value) {
                            return (value && !isNaN(value))? value : 0;
                        });
                        return vals.join('/');
                    };
                    keys = keys || [];
                    var values = keys.map(function(key) {
                        return parseInt(data[key]) || 0;
                    });

                    var max = max_fn();
                    var summed = values.reduce(function(previous, current) {
                        return previous + current;
                    });
                    var width = (summed / max * 100).toFixed(0);
                    var colors = [
                    dom.COMPARE_BAR.COLORS.RED,
                    dom.COMPARE_BAR.COLORS.GREEN
                    ];
                    var caption;
                    if (format) {
                        caption = format.apply(this, [summed, values]);
                    }

                    var inner_style = 'width: ' + width + '%;';
                    if (!summed) {
                        inner_style += ' display: none;';
                    }
                    var html = '<div class="compare-bar-container ' + '">';
                    if (keys.length > 0) {
                        var i, len = values.length;
                        var tip = '<div f-tip style="display: none;"><table class="table key-value"><tbody>';
                        for (i = 0; i < len; i++)
                            tip += "<tr><td>" + $.getInfo(keys[i]) + "</td><td>{{" + values[i] + " | number }}</td></tr>";
                        tip += "</tbody></table></div>"
                    }
		    // modify for mantis bug 444803
		    html += '<div class="compare-bar-caption" ';
		    if(max.toString().length >= 5)
		    {
			    var l = max.toString().length;
			    html += ' style="min-width: ' + l + 'em;"';
		    }
		    html += '>' + caption + '</div>';
                    //html += '<div class="compare-bar-caption">' + caption + '</div>';
                    html += '<div class="compare-bar-outer"' + (tip ? ' f-tip-target' : '') + ' style="min-width: 5em;">';
                    html += tip ? tip : '';
                    html += '<div class="compare-bar-inner" style="' + inner_style + '">';
                    values.forEach(function(value, index) {
                        var width;
                        var color = colors[index];
                        var valueClass = 'compare-bar-value';
                        var style = 'background-color: ' + color + ';';
                        if (index === values.length - 1) {
                            valueClass += ' grow';
                        } else {
                            width = (value / summed * 100).toFixed(0);
                            style += ' width: ' + width + '%;';
                        }
                        html += '<div class="' + valueClass + '" style="' + style + '"></div>';
                    });
                    html += '</div></div></div>';
                    return html;

                };
            },
            duration: function(max_fn) {
                var format = function(value) {
                    return datetime.humanize_seconds(value, true);
                };
                return this.one_compare(max_fn, 'duration', format);
            },
            user_with_icon: function(el, column, data) {
                var config = {
                    username: data[column.selector],
                    username_source: 'auth'
                };
                el.addClass('left');
                return widgets.format_fn.username(el, column, config);
            },
            domain: function(el, column, data) {
                if (el) {
                    el.addClass('left');
                }
                return '<img class="domain" src="http://www.google.com/s2/favicons?domain=' +
                    encodeURIComponent(data.domain) + '"/>' + dom.escapeHTML(data.domain);
            },
            level: function(el, column, data) {
                return widgets.format_fn.threatlevel(el, column, data);
            },
            risk: function(el, column, data) {
                var app, app_risk, apps = data.apps;
                extend_apps(apps);
                if (apps == null || !(app = apps[0]) ||
                        (app_risk = app.risk) == null) {
                    return lang('unknown');
                }
                return templates.risk_format()(app_risk);
            },
            category: function(el, column, data) {
                var app, apps = data.apps,
                    categories = fortiviewUtil.get_applications()
                                              .categories.$map.id;
                function _gen_app(name) {
                    if (!name || name === 'unknown') {
                        return String(lang('unknown'));
                    }
                    return '<div f-fgd-tip=".tooltip">' +
                        fgd_common.gen_app_cat_html(name) + '</div>';
                }
                extend_apps(apps);
                if (apps == null || !(app = apps[0])) {
                    return _gen_app(data.category || 'unknown');
                }

                if (!app.category_name) {
                    var attr_map_id = ips_common
                                        .ips_get_attr_map_id(ips_common
                                                             .IPS_ATTR_APP_CAT,
                                                             app.category),
                        cat = categories[attr_map_id];
                    if (cat) {
                        app.category_name = cat.name;
                    }
                }
                return _gen_app(app.category_name || app.category);
            },
            web_category: function(el, column, data) {
                if (data.category) {
                    return fgd_common.gen_wf_html_no_icon(data.category_id, data.category);
                }
                return '';
            },
            none: function(td, column, config) {
                return config[column.selector];
            },
            connection_time: function(from_key, to_key) {
                return function(el, column, data) {
                    var d = new Date();
                    var time_zone_offset_seconds = d.getTimezoneOffset() * 60;
                    var from_time = parseInt(data[from_key]) - time_zone_offset_seconds;
                    var to_time = parseInt(data[to_key]) - time_zone_offset_seconds;
                    return datetime.localSecondsToDate(from_time).toLocaleString() +
                        ' - ' + datetime.localSecondsToDate(to_time).toLocaleString();
                };
            },
            'last_conn_time': function(el, column, data) {
                if (data && data.last_conn_time) {
                    var d = new Date();
                    var time_zone_offset_seconds = d.getTimezoneOffset() * 60;
                    var last_conn_time = parseInt(data.last_conn_time) - time_zone_offset_seconds;
                    return datetime.localSecondsToDate(last_conn_time).toLocaleString();
                }
                return '';
            },
            'unauth_type_color': function(el, column, data) {
                el.addClass('level');
                var type = data.unauth_type;
                var unauth_type_cls = {
                    'Admin': 'access-red',
                    'IPsec VPN': 'access-green',
                    'SSL-VPN': 'access-yellow',
                    'FGFM': 'access-blue',
                    'SNMP': 'access-orange',
                    'Firewall': 'access-purple',
                    'FortiGuard Web Filter Override': 'access-pink',
                    'Wireless': 'access-aqua'
                };
                return '<span class="legend legend-wide-1 ' + unauth_type_cls[type] + '">' +
                    type + '</span>';
            },
            'unauth_target': function(el, column, data) {
                var unauth_maps = {
                    'Admin': {
                        format: formatAdmin
                    },
                    'IPsec VPN':  {
                        url: '/ng/vpn/ipsec/edit/',
                        mkey_field: 'unauth_target',
                        mkey_label: 'tunnel',
                        format: formatTunnel
                    },
                    'SSL-VPN':  {
                        // backend provides no value for unauth_target field
                        format: formatDefault
                    },
                    'FGFM':  {
                        format: formatDstip
                    },
                    'SNMP':  {
                        format: formatDstip
                    },
                    'Firewall':  {
                        url: '/ng/firewall/policy/policy/standard/edit/',
                        mkey_field: 'unauth_target2',
                        mkey_label: 'policy_id',
                        format: formatFirewall
                    },
                    'FortiGuard Web Filter Override':  {
                        format: formatDstip
                    },
                    'Wireless': {
                        format: formatDefault
                    }
                };

                function formatDefault(data, type) {
                    /*jshint unused: false*/
                    return data.unauth_target;
                }

                function formatAdmin(data, type) {
                    /*jshint unused: false*/
                    if (!data.dst_field2) {
                        return data.unauth_target;
                    }
                    var value = data.unauth_target1.toUpperCase();
                    var ip_intf = _formatIntfName(data, 'unauth_target2');
                    value += '(' + ip_intf + ')';
                    return value;
                }

                function formatTunnel(data, type) {
                    var mkey = data[unauth_maps[type].mkey_field];
                    if (mkey === 'N/A') {
                        return data.unauth_target;
                    }
                    var mkey_label = lang(unauth_maps[type].mkey_label);
                    var text = mkey;
                    var url = unauth_maps[type].url;

                    return _formatLink(url, mkey, mkey_label, text);
                }

                function formatDstip(data, type) {
                    /*jshint unused: false*/
                    return _formatIntfName(data, 'unauth_target');
                }

                function formatFirewall(data, type) {
                    var value = _formatIntfName(data, 'unauth_target1');

                    var url = unauth_maps[type].url;
                    var mkey = data[unauth_maps[type].mkey_field];
                    var mkey_label = lang(unauth_maps[type].mkey_label);
                    var text = ' (' + lang('policy') + ': ' + mkey + ')';

                    if (parseInt(mkey, 10) === 0) {
                        // No policy with policy ID 0 exists.
                        // It means the user-group is set on interface instead of in policy.
                        return value + text;
                    }

                    value += _formatLink(url, mkey, mkey_label, text);
                    return value;
                }

                function _formatIntfName(data, field_name) {
                    var intf_name = data.intf_name || '';
                    return intf_name ? (data[field_name] + ' - '  + intf_name)
                        : data[field_name];
                }

                function _formatLink(base_url, mkey, title, text) {
                    return '<a href="' + base_url + mkey + '" title="' + title + '. ' +
                        lang('Click to see the configuration.') + '">' + text + '</a>';
                }

                var type = data.unauth_type;
                var result = angular.isFunction(unauth_maps[type].format) ?
                    unauth_maps[type].format(data, type) : data.unauth_target;

                return result;
            },
            wifi_source: function(td, col, data) {
                return widgets.format_fn.address(td, { selector: 'srcip'},
                    angular.extend({
                        report_by: 'source',
                        username_source: 'auth',
                        username: data.wifiuser
                    }, data));
            },
            search_phrase_source: function(td, col, data) {
                return widgets.format_fn.address(td, { selector: 'srcip'},
                    angular.extend({
                        report_by: 'source',
                        username_source: data.userfield === 'user' ? 'auth' : '',
                        username: data.user
                    }, data));
            },
            exist_time: function(td, col, data) {
                return  data.exist_time + lang('seconds');
            },
        };

        /**
        * @param {Object} target Object that will be modified to contain maxes
        * @param {Object[]} details Array of details to calculate maxes from
        * @param {Object} sums Map of key->String[] with column [key] to be
        *   created as the sum of the columns in String[]
        */
        this.calculateMaxima = function(target, details, sums) {
            /*FWB_CHANGE sums = angular.extend({
                data_bytes: ['sentbyte', 'rcvdbyte'],
                data_packets: ['tx_packets', 'rx_packets'],
                data_bandwidth: ['tx_bandwidth', 'rx_bandwidth'],
                data_shaper_drops: ['tx_shaper_drops', 'rx_shaper_drops'],
                score: ['score_allow', 'score_block'],
                sessions: ['session_allow', 'session_block'],
                visit_count: ['visit_count'],
                total_count: ['total_count']
            }, sums);*/
            sums = angular.extend({
                actions: ['Block', 'Alert'],
                services: ['HTTP', 'HTTPS'],
                version: ['1.x', '2.0'],
                Bytes: ['Response', 'Request'],
            }, sums);
            //FWB_CHANGE var fields = {score: 0, bytes: 0, duration: 0, count: 0};
            var fields = {actions: 0, services: 0};
            angular.extend(fields, target, sums);
            for (var key in fields) {
                fields[key] = 0;
            }
            if (details != null) {
                details.reduce(calc_max, fields);
                for (var f in fields) {
                    target[f] = Math.max(1, fields[f]);
                }
            }
            function calc_max(fields, row) {
                for (var f in fields) {
                    var value;
                    if (f in sums && sums[f].every(value_exists(row))) {
                        value = sums[f].map(values(row)).reduce(sum);
                    } else {
                        value = parseInt(row[f]) || 0;
                    }
                    fields[f] = Math.max(fields[f], value);
                }
                return fields;
            }
        };
        function sum(result, value) { return result + value }
        function values(row) { return function(col) { return parseInt(row[col]) } }
        function value_exists(row) { return function(col) { return row[col] != null } }

        // TODO: (refactor) move into lang service
        // TODO: (later) test this!! document what targetExpression
        //      is expected to be
        this.onLangUpdatedApply = function(scope, targetExpression, expr) {
            var interpolateFn = $interpolate(expr),
                target = $parse(targetExpression);
            apply();
            return scope.$on('lang_updated', apply);
            function apply() {
                target.assign(scope, interpolateFn(scope));
            }
        };

        this.view_types = {
            web: [
                { type: 'domain', lang: 'Domains' },
                { type: 'category', lang: 'Categories' },
                { type: 'search-phrase', lang: 'Search Phrases' }
            ],
            cloud: [
                { type: 'app', lang: 'Applications' },
                { type: 'user', lang: 'Users' }
            ],
            vpn: [
                { type: 'vpn', lang: 'User' }
            ],
            sandbox: [
                { type: 'file', lang: 'Files' },
                { type: 'source', lang: 'Source' }
            ],
            'interface': [
                { type: 'intfpair', lang: 'Interface Pairs' },
                { type: 'srcintf', lang: 'Source' },
                { type: 'dstintf', lang: 'Destination' }
            ],
            device: [
                { type: 'physical', lang: 'fortiview_topology_physical' },
                { type: 'logical', lang: 'fortiview_topology_logical' }
            ]
        };

        this.get_additional_drilldown_tabs = function() {
            function not(value) {
                return function(other) {
                    return other !== value;
                };
            }
            var ADDITIONAL_TABS = {
                source: ['web-domain', 'web-category', 'web-search-phrase',
                    'interface-srcintf', 'interface-dstintf'],
                destination: ['interface-srcintf', 'interface-dstintf'],
                country: ['interface-srcintf', 'interface-dstintf'],
                web: function(w_type) {
                    var tabMaps = {
                        'web-search-phrase': ['web-search-phrase-detail'],
                        'web-domain': ['web-category'],
                        'web-category': ['web-domain']
                    };
                    return tabMaps[w_type] || [];
                },
                cloud: ['cloud-user', 'cloud-app', 'files', 'videos'],
                vpn: ['vpn-user'],
                sandbox: ['sandbox-file'],
                wificlient: ['web-domain', 'web-category', 'web-search-phrase'],
                'interface': ['interface-srcintf', 'interface-dstintf']
            };
            var segment = fortiviewRouteMetadata.baseSegment(false),
                segment_w_type = fortiviewRouteMetadata.baseSegment(true);
            if (segment in ADDITIONAL_TABS) {
                return angular.isFunction(ADDITIONAL_TABS[segment]) ?
                ADDITIONAL_TABS[segment](segment_w_type) :
                ADDITIONAL_TABS[segment].filter(not(segment_w_type));
            } else {
                return [];
            }
        };
        /**
        * Return a filter function which returns true if no item with the same
        * value of property prop is present in the array arr.
        * Use with [].filter.
        * @param {Object[]} arr Array of items to test against.
        * @param {String} prop Property to compare in each item.
        */
        this.not_present = function not_present(arr, prop) {
            var selectors = arr.map(pluck_prop);
            return function(column) {
                return selectors.indexOf(column.selector) === -1;
            };
            function pluck_prop(item) { return item[prop] }
        };
        // NOTE: this isn't necessary, but may prevent certain kinds of bugs
        objects.lockCurrentProperties(this);
    }

    function Interfaces() {
        var interfacesPromise,
            interfaceMap = {};
        this.init = function() {
            if (interfacesPromise) {
                return interfacesPromise;
            }
            return (interfacesPromise = firewallInterfaces.get().then(function(interfaces) {
                interfaceMap = interfaces.mapping;
            }));
        };

        this.invalidate = function() {
            interfacesPromise = null;
            interfaceMap = {};
        };

        this.get = function() {
            return interfaceMap;
        };
    }

    return function(providers, loader) {
        providers.$provide.service('fortiviewUtil', Util);
        providers.$provide.service('fortiviewInterfaceLookup', Interfaces);
        return loader.initModules(['../directives/fortiguard', 'routeMetadata'], module);
    };

});
