/*global define*/

define(['module', 'angular', './routeMetadata', './searchState', './util',
    'ng/services/persistent_storage', 'ng/filters/ftnt'
], function(module, angular, rmdRegister, searchStateRegister, utilRegister) {
    'use strict';

    /* jshint maxparams: 9 */
    function Visualization($rootScope, $routeParams, $filter, lang, persistentStorage,
            fortiviewUtil, fortiviewRouteMetadata, fortiviewSearchState, fortiviewInterfaceLookup) {
        var valueKeys;

        var AUTO_UPDATE_KEY = 'fortiviewAutoUpdate';
        var BUBBLE_OPTION_KEY = 'fortiviewBubbleOption';
        var ACCESS_DEVICE_KEY = 'fortiviewAccessDevice';

        var TYPES = this.TYPES = {
            TABLE: 'table', // Handled externally by qlist
            BUBBLE: 'bubble',
            BUBBLE_CLUSTER: 'bubble_cluster',
            COUNTRY: 'country',
            TIMELINE: 'timeline',
            CHORD: 'chord'
        };
        this.TYPES_LIST = Object.keys(TYPES).map(function(key) {
            return TYPES[key];
        });

        var SORT_TO_ENTRY_MAP = {
            data_bytes: ['sentbyte', 'rcvdbyte'],
            data_packets: ['tx_packets', 'rx_packets'],
            data_shaper_drops: ['tx_shaper_drops', 'rx_shaper_drops'],
            data_bandwidth: ['tx_bandwidth', 'rx_bandwidth']
        };

        var MAP_FORMAT = {};
        MAP_FORMAT[TYPES.COUNTRY] = true;

        var setValueKeys = function(sortBy) {
            var key = fortiviewUtil.server_to_client_sort_map[sortBy || 'bytes'];
            valueKeys = SORT_TO_ENTRY_MAP[key] || [key];
        };

        var getValue = function(entry) {
            var value = 0;
            valueKeys.forEach(function(key) {
                //FWB_CHANGE value += entry[key];
                value += parseInt(entry[key]);
            });
            return value;
        };

        var simpleKeyFn = function(key) {
            return function(entry) {
                return angular.extend({}, entry, {
                    name: entry[key],
                    value: getValue(entry)
                });
            };
        };

        var applicationFn = function(entry) {
            var app = entry.apps[0] || {id: 0};
            var map  = fortiviewUtil.get_applications().$map.id;
            var mappedName = map[app.id] ? map[app.id].name : app.id;
            return angular.extend({}, entry, {
                name: app.id ? mappedName : app.name,
                value: getValue(entry)
            });
        };

        var policyFn = function(entry) {
            var name = entry.policyname || entry.policyid;
            var type = lang('Firewall::policytype.' + (entry.policytype || 'policy'));
            return angular.extend({}, entry, {
                name: name + ' (' + type + ')',
                value: getValue(entry)
            });
        };

        /*FWB_CHANGE var REPORT_BY_MAP = {
            source: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('address')
                }
            },
            destination: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('address')
                }
            },
            country: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE,
                    TYPES.COUNTRY
                ],
                fn: {
                    default: simpleKeyFn('country')
                }
            },
            policy: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: policyFn
                }
            },
            'interface-srcintf': {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('srcintf')
                }
            },
            'interface-dstintf': {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('dstintf')
                }
            },
            'interface-intfpair': {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE,
                    TYPES.CHORD
                ],
                processFn: {
                    chord: function(details, config) {
                        var intfToIntf = {};

                        // Use default detail processing
                        details = details.map(function(detail) {
                            return config.fn.default(detail);
                        });

                        // Create index-detail mapping, and aggregate pair values.
                        details.forEach(function(detail) {
                            // Make sure objects exist for both source and destination interfaces.
                            intfToIntf[detail.srcintf] = intfToIntf[detail.srcintf] || {};
                            intfToIntf[detail.dstintf] = intfToIntf[detail.dstintf] || {};

                            var srcToDest = intfToIntf[detail.srcintf][detail.dstintf];
                            if (srcToDest) {
                                // More than one detail element for a chord: add this value to it
                                var detailCopy = angular.copy(detail);
                                detailCopy.realValue = detailCopy.value + srcToDest.realValue;
                                detailCopy.value += srcToDest.value;
                                intfToIntf[detail.srcintf][detail.dstintf] = detailCopy;
                            } else {
                                detail.realValue = detail.value;
                                intfToIntf[detail.srcintf][detail.dstintf] = detail;
                            }

                            // Duplicate the detail in the reverse direction so that chords will be
                            // symmetric (begin and end with the same width) for viewing clarity.
                            var destToSrc = intfToIntf[detail.dstintf][detail.srcintf];
                            if (destToSrc) {
                                destToSrc.value += detail.value;
                            } else {
                                // Since this detail is duplicated, it will have no real value.
                                var reversedDetail = {
                                    srcintf: detail.srcintf,
                                    dstintf: detail.dstintf,
                                    value: detail.value,
                                    realValue: 0
                                };
                                intfToIntf[detail.dstintf][detail.srcintf] = reversedDetail;
                            }
                        });

                        // List of unique interfaces in details: this could be improved.
                        var interfaces = details.map(function(detail) {
                            return detail.srcintf;
                        }).concat(details.map(function(detail) {
                            return detail.dstintf;
                        })).sort().filter(function(item, pos, ary) {
                            return !pos || item !== ary[pos - 1];
                        });

                        // Create chord matrix
                        var matrix = [];
                        interfaces.forEach(function(rowEntity) {
                            var row = [];
                            interfaces.forEach(function(columnEntity) {
                                var value = 0;
                                if (intfToIntf[rowEntity] && intfToIntf[rowEntity][columnEntity]) {
                                    value = intfToIntf[rowEntity][columnEntity].value || 0;
                                }
                                row.push(value);
                            });
                            matrix.push(row);
                        });

                        return {
                            matrix: matrix,
                            dataMap: intfToIntf,
                            entities: interfaces,
                            entitiesExtra: fortiviewInterfaceLookup.get()
                        };
                    }
                },
                fn: {
                    default: function(entry) {
                        var src = simpleKeyFn('srcintf')(entry),
                            dst = simpleKeyFn('dstintf')(entry);

                        return angular.extend({}, src, {
                            name: src.name + '-to-' + dst.name
                        });
                    }
                }
            },
            application: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: applicationFn
                }
            },
            threat: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('threat')
                },
                colorFn: function(name, entry) {
                    // Keep in sync with threat level CSS
                    return {
                        0: '#d4fbff',
                        1: '#faffa5',
                        2: '#ffca5c',
                        3: '#f32e2b'
                    }[entry.level];
                },
                strokeFn: function(name, entry) {
                    // Keep in sync with threat level CSS
                    return {
                        0: '#7bcade',
                        1: '#d2ba00',
                        2: '#e2a82e',
                        3: '#d50000'
                    }[entry.level];
                }
            },
            'web-category': {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('category')
                }
            },
            'web-domain': {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('domain')
                }
            },
            'web-search-phrase': {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('keyword')
                }
            },
            'cloud-app': {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: applicationFn
                }
            },
            'cloud-user': {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('clouduser')
                }
            },
            'admin': {
                supported: [
                    TYPES.TABLE,
                    TYPES.TIMELINE
                ],
                processFn: {
                    timeline: function(details, config, sortBy, reqData) {
                        if (reqData.length > 1) {
                            return reqData[1];
                        }
                    }
                },
                fn: {
                    default: simpleKeyFn('admin')
                }
            },
            'wificlient': {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('mac')
                }
            },
            'device-physical': {
                supported: [
                    TYPES.BUBBLE_CLUSTER
                ],
                fn: {
                    default: simpleKeyFn('mac')
                }
            },
            'device-logical': {
                supported: [
                    TYPES.BUBBLE_CLUSTER
                ],
                fn: {
                    default: simpleKeyFn('mac')
                }
            },
            shaper: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('shaper')
                }
            }
        };*/
        var REPORT_BY_MAP = {
            threat: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('attack_type')
                }
            },
            action: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('action')
                }
            },
            country: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE,
                    TYPES.COUNTRY
                ],
                fn: {
                    default: simpleKeyFn('srccountry')
                }
            },
            source: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('src')
                }
            },
            device: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('dev_id')
                }
            },
            http_url: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('http_url')
                }
            },
            http_method: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('http_method')
                }
            },
            tSource: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('src')
                }
            },
            tCountry: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE,
                    TYPES.COUNTRY
                ],
                fn: {
                    default: simpleKeyFn('srccountry')
                }
            },
            tDestination: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('dst')
                }
            },
            tPolicy: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('policy')
                }
            },
            tHttpHost: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('http_host')
                }
            },
            tHttpMethod: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('http_method')
                }
            },
            tHttpRetcode: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('http_retcode')
                }
            },
            tHttpUrl: {
                supported: [
                    TYPES.TABLE,
                    TYPES.BUBBLE
                ],
                fn: {
                    default: simpleKeyFn('http_url')
                }
            },
	    signature_cve_id: {
		supported: [
		    TYPES.TABLE,
		    TYPES.BUBBLE
		],
		fn: {
		    default: simpleKeyFn('signature_cve_id')
		}
	    },
	    owasp_top10: {
		supported: [
		    TYPES.TABLE,
		    TYPES.BUBBLE
		],
		fn: {
		    default: simpleKeyFn('owasp_top10')
		}
	    }
        };

        var desiredType = TYPES.TABLE;
        var type = TYPES.TABLE;
        var current;

        this.getType = function() {
            return type;
        }.bind(this);

        this.setType = function(value) {
            desiredType = value;
            if (this && this.supported) {
                if (this.supported.indexOf(desiredType) >= 0) {
                    type = desiredType;
                } else if (this.supported.indexOf(this.type) <= 0) {
                    type = TYPES.TABLE;
                }
            }
        }.bind(this);

        $rootScope.$watch(function() {
            return {
                baseSegment: fortiviewRouteMetadata.baseSegment(),
                drilldownValue: $routeParams.drilldownValue,
                drilldownTabValue: $routeParams.drilldownTabValue,
                drilldownTab: this.drilldownTab
            };
        }.bind(this), function(state) {
            var key = state.drilldownValue ? state.drilldownTab : state.baseSegment;
            current = REPORT_BY_MAP[key];
            this.supported = (current && !state.drilldownTabValue) ? current.supported : [];
            this.colorFn = current ? current.colorFn : null;
            this.strokeFn = current ? current.strokeFn : null;
            this.setType(desiredType);
        }.bind(this), true);

        var autoUpdateConfig = persistentStorage.get(AUTO_UPDATE_KEY) || {};
        var autoUpdateEnabled = !!autoUpdateConfig.enabled || false;
        var autoUpdateInterval = Number(autoUpdateConfig.interval) || 15;
        this.autoUpdatePaused = false;

        var BUBBLE_OPTION_ENUM = this.BUBBLE_OPTION_ENUM = {
            TRAFFIC: 'traffic',
            CONSTANT: 'constant',
            DEVICE_TYPE: 'device_type',
            NONE: 'none'
        };
        var bubbleOption = persistentStorage.get(BUBBLE_OPTION_KEY) || BUBBLE_OPTION_ENUM.TRAFFIC;
        var ACCESS_DEVICE_ENUM = this.ACCESS_DEVICE_ENUM = {
            SHOW: 'show',
            HIDE: 'hide'
        };
        this.TOPOLOGY_ENUM = {
            PHYSICAL: 'physical',
            LOGICAL: 'logical'
        };
        var accessDevice = persistentStorage.get(ACCESS_DEVICE_KEY) || ACCESS_DEVICE_ENUM.SHOW;

        var updateConfig = function() {
            persistentStorage.put(AUTO_UPDATE_KEY, this.getAutoUpdateConfig());
        }.bind(this);

        this.isAutoUpdateEnabled = function() {
            var realtime = fortiviewSearchState.state.timeframe === 'realtime';
            return realtime && autoUpdateEnabled;
        };
        this.getAutoUpdateInterval = function() {
            var interval = 0;
            if (this.isAutoUpdateEnabled() && type !== TYPES.TABLE && !this.autoUpdatePaused) {
                interval = autoUpdateInterval;
            }
            return interval;
        };
        this.getAutoUpdateConfig = function() {
            return {
                enabled: autoUpdateEnabled,
                interval: autoUpdateInterval
            };
        };
        this.setAutoUpdateConfig = function(config) {
            autoUpdateEnabled = !!config.enabled;
            autoUpdateInterval = Number(config.interval) || 0;
            updateConfig();
        };

        /* getter/setter */
        this.bubbleOption = function(type) {
            if (arguments.length === 1) {
                if (BUBBLE_OPTION_ENUM.hasOwnProperty(type) >= 0) {
                    bubbleOption = type;
                    persistentStorage.put(BUBBLE_OPTION_KEY, type);
                }
            } else {
                return bubbleOption;
            }
        };
        this.BUBBLE_OPTIONS = [
            {
                type: BUBBLE_OPTION_ENUM.TRAFFIC,
                lang: 'Device Traffic'
            }, {
                type: BUBBLE_OPTION_ENUM.CONSTANT,
                lang: 'Device Count'
            }, {
                type: BUBBLE_OPTION_ENUM.DEVICE_TYPE,
                lang: 'Device Type'
            },
            {
                type: BUBBLE_OPTION_ENUM.NONE,
                lang: 'No Devices'
            }
        ];

        /* getter/setter */
        this.accessDevice = function(type) {
            if (arguments.length === 1) {
                if (ACCESS_DEVICE_ENUM.hasOwnProperty(type) >= 0) {
                    accessDevice = type;
                    persistentStorage.put(ACCESS_DEVICE_KEY, type);
                }
            } else {
                return accessDevice;
            }
        };
        this.ACCESS_DEVICE_TYPES = [
            {
                type: ACCESS_DEVICE_ENUM.SHOW,
                lang: 'Access Device'
            },
            {
                type: ACCESS_DEVICE_ENUM.HIDE,
                lang: 'No Access Device'
            }
        ];

        this.processSource = function(details, sortBy, overrideKey, reqData) {
            var config = overrideKey ? REPORT_BY_MAP[overrideKey] : current;
            var supported = (config || {}).supported;
            var result = {};
            if (supported && supported.length) {
                setValueKeys(sortBy);
                supported.forEach(function(supportedType) {
                    var fn, dataMap;
                    var data = [];
                    var meta = {};
                    var detailsLength = details.length;

                    if (config.processFn && config.processFn[supportedType]) {
                        result[supportedType] = config.processFn[supportedType](details, config,
                                    sortBy, reqData);
                        return;
                    }

                    if (supportedType !== TYPES.TABLE) {
                        fn = config.fn[type] ? config.fn[type] : config.fn.default;
                        if (MAP_FORMAT[supportedType]) {
                            dataMap = {};
                        }
                        if (detailsLength) {
                            meta.sum = 0;
                        }
                        details.forEach(function(entry) {
                            entry = fn(entry);
                            data.push(entry);
                            if (dataMap) {
                                dataMap[entry.name] = entry;
                            }

                            meta.sum += entry.value;
                            if (meta.max == null || entry.value > meta.max) {
                                meta.max = entry.value;
                            }
                            if (meta.min == null || entry.value < meta.min) {
                                meta.min = entry.value;
                            }
                            if ((meta.minNonZero == null || entry.value < meta.minNonZero) &&
                                entry.value > 0) {
                                meta.minNonZero = entry.value;
                            }
                        });
                        if (detailsLength) {
                            meta.average = meta.sum / detailsLength;
                        }
                        result[supportedType] = dataMap ? dataMap : data;
                        result[supportedType]._meta = meta;
                    }
                });
            }
            return result;
        };

        this.createTooltipFormatter = function(qlistOptions) {
            var FICON_RIGHT = ' <f-icon class="fa-long-arrow-right"></f-icon> ';
            var FICON_LEFT = ' <f-icon class="fa-long-arrow-left"></f-icon> ';
            var EXEMPT = {
                rcvdbyte: true,
                sentbyte: true,
                rx_packets: true,
                tx_packets: true
            };
            return function(entry) {
                var $table;
                var defaultSelectorsMap = Object.create(null);
                var defaultItems = [];
                var otherItems = [];

                qlistOptions.default_columns.forEach(function(selector) {
                    defaultSelectorsMap[selector] = true;
                });


                EXEMPT.srcintf = EXEMPT.dstintf = !!entry.reversed;

                qlistOptions.columns.forEach(function(column) {
                    var selector = column.selector;
                    if (column && !column.hidden && !EXEMPT[selector]) {
                        (defaultSelectorsMap[selector] ? defaultItems : otherItems).push({
                            selector: selector,
                            lang: column.lang_key || selector,
                            formatter: qlistOptions.format_fn[selector]
                        });
                    }
                });

                // We are building the HTML manually instead of using a template so that we
                // can re-use the qlist formatters.
                var addItem = function(entry, rowClass) {
                    return function(item) {
                        var fmt;
                        var $tr = angular.element('<tr></tr>').addClass(rowClass);
                        var $td = angular.element('<td></td>');
                        $td.text(lang(item.lang).toString() + ':').appendTo($tr);
			$td.css('white-space', 'nowrap');
                        $td = angular.element('<td></td>');
                        if (item.formatter) {
                            fmt = item.formatter($td, {selector: item.selector}, entry);
                            if (!fmt) {
                                return;
                            }
                            $td.html(fmt);
                        } else {
                            fmt = entry[item.selector];
                            if (!fmt) {
                                return;
                            }
			    if(fmt.length >= 50)
			    {
				    $td.css('word-break', 'break-all');
				    $td.css('word-wrap', 'break-word');
			    }
			    $td.text(fmt);
                        }
                        $table.append($tr.append($td));
                    };
                };

                $table = angular.element('<table></table>');
                if (entry.reversed) {
                    var $tr = angular.element('<tr></tr>');
                    var $td = angular.element('<td></td>')
                        .html(entry.srcintf + FICON_RIGHT + entry.dstintf)
                        .css('font-weight', 'bold');
                    $table.append($tr.append($td));
                    defaultItems.concat(otherItems).forEach(addItem(entry, 'child'));
                    // Show details for traffic in the opposite direction
                    $tr = angular.element('<tr></tr>');
                    $td = angular.element('<td></td>')
                        .html(entry.srcintf + FICON_LEFT + entry.dstintf)
                        .css('font-weight', 'bold');
                    $table.append($tr.append($td));
                    defaultItems.concat(otherItems).forEach(addItem(entry.reversed, 'child'));
                } else {
                    defaultItems.concat(otherItems).forEach(addItem(entry));
                }

                return $table;
            };
        };

        this.createLegendValueFormatter = function(sortBy) {
            var MAP = {
                data_bytes: $filter('bytes'),
                data_bandwidth: $filter('bitsPerSecond'),
                // TODO: Remove me when the bandwidth name conflict is resolved
                bandwidth: $filter('bitsPerSecond')
            };
            return function(value) {
                var fn = MAP[fortiviewUtil.server_to_client_sort_map[sortBy]];
                return fn ? fn(value) : $filter('number')(value);
            };
        }.bind(this);
    }

    return function register(providers, loader) {
        providers.$provide.service('fortiviewVisualization', Visualization);
        return loader.initModules([rmdRegister, searchStateRegister, utilRegister]);
    };
});
