define("ng/services/injector", ["angular", "app"], function(angular, module) {
    "use strict";
    function Injector($injector) {
        function invoked() {
            return Array.prototype.slice.call(arguments)
        }
        this.bind = function(fn, context, locals) {
            $injector.annotate(fn), invoked.$inject = fn.$inject;
            var args = $injector.invoke(invoked, context, locals);
            return fn.bind.apply(fn, [context].concat(args))
        }, this.partial = function(fn, context, positional, locals) {
            function remove_positional(arg) {
                return -1 === positional.indexOf(arg)
            }
            $injector.annotate(fn), invoked.$inject = fn.$inject.filter(remove_positional);
            var args = $injector.invoke(invoked, context, locals);
            return fn.bind.apply(fn, [context].concat(args))
        }, this.injectMarked = function(context, locals) {
            var key, property;
            for (key in context)
                if (property = context[key], angular.isFunction(property) && property.$injectMark) {
                    var result = $injector.invoke(property, context, locals);
                    context[key] = "function" == typeof result ? result.bind(context) : result
                }
        }
    }
    return module.service("injector", Injector), {mark: function(fn) {
            return fn.$injectMark = !0, fn
        }}
});
