/*(function(require) {
    'use strict';

    require.config({
        paths: {
            'lang.wizard': '/fgt_lang.js?type=0&paths=waf/signature/lang/:wizard'
        },
        shim: {
            'lang.wizard': {exports: 'fgt_lang'}
        }
    });

    function set_fgt_lang(lang) {

        if (typeof lang != 'object')
            return;

        if (typeof window.fgt_lang == 'object') {
            for (var lang_item in lang) {
                window.fgt_lang[lang_item] = lang[lang_item];
            }
        } else {
            window.fgt_lang = lang; 
        }

    }

    require(['lang.wizard'], set_fgt_lang);

})(require);*/
define(['angular', 'lang.wizard'], function(angular) {
    var module = angular.module('lang', []);

    function lang_factory($rootScope, $q, $sce) {

        function getInfo(id, langs) {
            langs = langs || window.fgt_lang || {};
            for (var sec in langs) {
                var langs_sec = langs;
                if (langs_sec && id in langs_sec) {
                    var lang = langs_sec[id];
                    if (lang != undefined) {
                        return lang;
                    }
                }
            }
            return id;
        }
        function lang(id, interpolate) {
            var result;
            result = 'fgt_lang' in window ? getInfo(id) : '';
            return result;

        }
        return lang;
    }

    module.factory('lang', lang_factory);

    module.filter('lang', function(lang) {
        return function(input) {
            input = input || '';    
            return lang(input);
        };
    });

});
