/* globals define */
/* logging.js *//* globals log_ng, FOSGUI */
define(['angular', 'directives/faceted_search', 'log/facets', 'directives/context_menu',
    'fweb.util/persist',
    'services/facets_log', 'services/persistent_storage'
],
function(angular, faceted_search, log_facets, context_menu, f_persist) {
    'use strict';
    var module = angular.module('ftnt');
    module.config(function(loaderProvider) {
        loaderProvider.initModules([faceted_search, log_facets, context_menu]);
    });
    module.controller('LogViewerSearch', LogViewerSearch);
    function LogViewerSearch($scope, loggingFacets, $q, persistentStorage, facets,
            facetedSearchUtil, $window, SearchFacet, ComplexValue, $http) {
        var PERSIST_KEY = 'LogViewerSearch_' + log_ng.log_type,
            qlistConfig = null;
        $scope.refresh = function() {
            log_ng.showLoading();
            log_ng.onload(facets.makeQlistFilters($scope.facetedSearch.model));
        };
        $scope.ha = {serial_no: log_ng.serial_no};
        ['device', 'ha_members', 'log_type', 'is_rw_admin'].forEach(function(prop) {
            $scope[prop] = log_ng[prop];
        });
	$scope.doFlagOperation = function(type) {
		var id = $scope.context.row['msg_id'];
		var flag = $scope.context.row['flag_val'];
		var file = $scope.context.row['logfile'];
		var val = type || 0;

		var url = "/log/attack_log/set_flag";
		var data = '';
		data +=	"session_id="+ session_id;
		data +=	"&msg_id=" +  id;
		data +=	"&flag=" + flag;
		data +=	"&logfile=" + file;
		data +=	"&value=" + val;

		$scope.context = {};

		var postCfg = {
			headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'},
		};
		$http.post(url, data, postCfg).success(
			function(data, status)
			{
				$scope.context = {};
				if(data.status == 1)
				{
					$scope.refresh();
				}
				else
				{
					switch(data.msg_id)
					{
						case -30:
							top.location.href = "/login";
						break;
						case -37:
							document.location.href = "/noaccess?redir=/waf/signature_group/list";
						break;
						default :
							document.location.href = "/error?msg=" + data.msg_id;
						break;
					}
				}
			}
		).error(
			function(data, status)
			{
				$scope.context = {};
				console.log("bad HTTP response");
			}
		);
	};
        $scope.flag_operations = [
		{"label": "mark_required", type: 1},
		{"label": "mark_taken", type: 2},
		{"label": "mark_dismissed", type: 3}
	];
        $scope.download_raw = function() {
            var raw_path = window.location.pathname + 'raw/?filter=' +
                encodeURIComponent(JSON.stringify(qlistConfig.column_filters.value));
            window.location.href = raw_path;
        };
        $scope.mgmt_raw = function() {
            var raw_path = '/log/disk/list?log=' + log_ng.logfile;
            window.location.href = raw_path;
        };
        $scope.pdf = function() {
            var para = getDetailParam();
            if(para == '') {
                alert($j.getInfo('no_entries'));
                return;
            }
            if (!confirm($j.getInfo('pdf_confirm'))){
                return;
            }
            var raw_path = '/log/genpdf?log=' + log_ng.logfile　+ '&session_id=' + session_id + para;
            window.location.href = raw_path;
        };
        // use $evalAsync because jquery promises can sometimes execute syncronously,
        //and we'd have a double apply
        log_ng.columns.then(function(columns) {
            $scope.$evalAsync(function() {
                var disabled_columns = log_ng
                    .get_filter_disable_columns(log_ng.device_id, columns.columns),
                    model;
                var urlFilter = $window.location.search.replace(/^\?/, '')
                    .split('&').filter(startsWithFilter).map(doReplaceFilter)[0];
                try {
                    model = persistentStorage.get(PERSIST_KEY) || {};

                    //support deault filter
                    if(log_ng.log_type == '3' && !("_severity_level" in model))
                        model["_severity_level"] = [
                            {"default_filter":true,"__ComplexValue":true,"modifiers":["!"],"value":"! Informative","_mpad":2,"splitter":null,"selected":0,"selectedCount":0,"_spad":[],"values":["Informative"]}
                        ];
                } catch (ex) {}

                columns = columns.columns.filter(columnFilterNotDisabled);

                $scope.facetedSearch = {
                    facets: loggingFacets.forLogType(log_ng.log_type, columns, highlight),
                    model: model || {},
                    options: {
                        entries: entriesGetter,
                        source: 'history',
                        complex: true,
                        filterMerge: {max: 1}
                    }
                };
                //loggingFacets.forLogType must be called before fromQListFilters as it
                //registers _extraFacets!
                if (urlFilter) {
                    urlFilter = JSON.parse(decodeURIComponent(urlFilter));
                    var urlModel = facets.fromQlistFilters(urlFilter, 'history');
                    angular.extend(model, urlModel);
                }
                $scope.facetsBySource = $scope.facetedSearch.facets.reduce(bySourceHistory, {});
                //ugly!
                $scope.facetedSearch.model = facetedSearchUtil
                    .jsonForModel($scope.facetedSearch.model);

                function columnFilterNotDisabled(column) {
                    return disabled_columns.indexOf(column.selector) === -1;
                }
                function bySourceHistory(index, facet) {
                    index[facet.selectors.history] = facet;
                    return index;
                }

                function startsWithFilter(str) { return /^filter=/.test(str) }
                function doReplaceFilter(str) { return str.replace(/^filter=/, '') }
            });

        });
        $scope.addContextFilter = function(valueOption) {
            // function makeCV(v) {
            //     var value = v;
            //     if(value instanceof SearchFacet.ValueOption)
            //         value = value.key;

            //     var cv = new ComplexValue(value);

            //     if (cv.values === value.values) {
            //         throw new Error('shared array fail!');
            //     }

            //     return cv;
            // }
            // var newModel = angular.copy($scope.facetedSearch.model);
            // var value = newModel[$scope.context.facet.id];
            // if (value === undefined) {
            //     value = newModel[$scope.context.facet.id] = [];
            // }

            // var joinedModifiers = '';
            // if(value.length > 0 && value[0].modifiers) {
            //     joinedModifiers = value[0].modifiers.join('\u001E');
            // }

            // var newCv = makeCV(valueOption.key);

            // if(value.length > 0  && joinedModifiers === newCv.modifiers.join('\u001E')) {
            //     var cv = makeCV(value[0]);
            //     cv.merge(newCv, ',');
            //     value[0] = cv;

            //     //newModel = facetedSearchUtil.jsonForModel(newModel);
            //     value.push(newCv);
            // } else {
            //     value.push(newCv);
            // } 

            // $scope.facetedSearch.model = newModel;
            
            // $scope.context = {};
            var model = $scope.facetedSearch.model[$scope.context.facet.id];
            if (model === undefined) {
                model = $scope.facetedSearch.model[$scope.context.facet.id] = [];
            }
            model.push(valueOption.key);
            $scope.context = {};
        };

        function refreshQlist(model) {
            log_ng.showLoading();
            log_ng.ready.then(function() {
                log_ng.onload(facets.makeQlistFilters(model || $scope.facetedSearch.model));
            });
        }
        $scope.$watch('facetedSearch.model', function(value, oldValue) {
            //columns may not be loaded yet
            if (value === undefined) {
                return;
            }
            if (oldValue && oldValue !== value) {
                //persistentStorage.put(PERSIST_KEY, value);
                //support deault filter
                var model = {};
                Object.keys(value).forEach(function(key) {
                    var f = value[key].filter(function(flter) {
                        return !flter.default_filter;
                    });

                    if(f.length)
                        model[key] = f;
                });
                persistentStorage.put(PERSIST_KEY, model);
                refreshQlist(value);
            } else {
                log_ng.search_ready.resolve(facets.makeQlistFilters(value));
            }
            //search_ready resolve should create log_ng.ready promise
            if (log_ng.ready) {
                log_ng.ready.then(function(entries, $qlist) {
                    $scope.facetedSearch.facets.forEach(function(facet) {
                        facet.getValues(entries, 'history');
                    });
                    //rebind everything because logging nukes the qlist data.
                    var filterEvt = 'filter_applied.LogViewerSearch remove_filters.LogViewerSearch';
                    var contextEvt = 'contextmenu.LogViewerSearch';
                    qlistConfig = $qlist.qlist('config');
                    $qlist.off(filterEvt).on(filterEvt, function(evt, filters) {
                        $scope.$apply(function() {
                            //if the remove_filters event is triggered
                            //the filters argument is undefined;
                            $scope.facetedSearch.model =
                                facets.fromQlistFilters(filters || [], 'history');
                        });
                    });
                    $qlist.off(contextEvt).on(contextEvt, function(evt) {
                        var $elem = angular.element(evt.target).closest('td');
                        var mkey = $elem.closest('[mkey]').attr('mkey');
                        var selector = $elem.length && $elem[0].className;
			// added by lk, for fix bug 384866
			var selector_real = selector;
			if(log_ng.log_type == '3' && selector_real === 'msg')
			    selector_real = 'msg_src';
                        $scope.$apply(log_ng.ready.then.bind(log_ng.ready, function(source) {
                            $scope.context = {
                                origin: {x: evt.pageX, y: evt.pageY},
                                row: source.filter(findRow)[0],
                                selector: selector_real,
                                facet: $scope.facetsBySource[selector]
                            };
                            var value = $scope.context.row && $scope.context.row[selector_real];
			    // added by lk, for fix bug 385437
			    if(selector_real == 'http_url')
			    {
				    var pos = value.indexOf('?');
				    if(pos != -1)
					value = value.substring(0, pos);
			    }
                            $scope.context.filters = $scope.context.facet &&
                                $scope.context.facet.contextFilters(value);

                        }));
                        evt.preventDefault();
                        function findRow(row) {
                            return row['#'] === Number(mkey);
                        }
                    });
                });
            }

        }, true);

        $scope.$watch('ha.serial_no', function(value, oldValue) {
            if (value !== oldValue) {
                //TODO: refactor log viewer so that it doesn't rely on cookies?
                f_persist.setCookie('serial_no', value);
                refreshQlist();
            }
        });
        function entriesGetter() {
            return $q.when(log_ng.ready);
        }

        function highlight() {
            /* jshint validthis: true *//* this is a SearchFacet */
            var chosen = false,
                scm = FOSGUI.LogFormatter.smartColumnMap,
                selector = this.selectors.history;
            if (qlistConfig && qlistConfig.chosen_columns) {
                chosen = qlistConfig.chosen_columns.indexOf(selector) > -1;
                if (!chosen && scm && (selector in scm)) {
                    selector = scm[selector];
                    chosen = qlistConfig.chosen_columns.indexOf(selector) > -1;
                }
            }
            return chosen;
        }
	function getDetailParam()
	{
		var res = '';
		var items = 0;
		var fpos = null,file = null,length = null;
		var tr = $j('.qlist_row');
		for(var i = 0; i < tr.length; i++)
		{
			fpos = $j(tr[i]).attr('fpos');
			if(fpos)
				res += '&fpos' + i + '=' + fpos;
			file = $j(tr[i]).attr('logfile');
			if(file)
				res += '&file' + i + '=' + file;
            length = $j(tr[i]).attr('length');
            if(length)
                res += '&length' + i + '=' + length;            
		}
		if(fpos && file && length) res += '&items=' + tr.length;
		return res;
	}
    }
});
