/* globals define */
/* jshint maxparams: 8 */
define(['angular', 'services/facets_log', 'qlist.sort', 'services/loader', 'services/injector'],
function(angular, facets) {
    'use strict';
    function LoggingFacets(injector) {
        var partialBind = {
            'forLogType': ['logType', 'columns', 'highlight']
        };
        for (var fn in partialBind) {
            this[fn] = injector.partial(this[fn], this, partialBind[fn]);
        }
    }

    LoggingFacets.prototype = {
        facets: null,
        forLogType: function(SearchFacet, facets, $sce, $sanitize, $q, logType, columns,
                highlight) {
            var result = facets.facetDefs.filter(forLogType).map(makeFacet),
                selectors = result.map(pluckSelector);
            columns = (columns || []).filter(selectorNotIn(selectors))
                .map(addColumnExtras);
            var extraFacets = facets.genericFacets(columns, highlight);
            facets.extraFacets(extraFacets);
            return result.concat(extraFacets);

            //meta.logTypes = true to apply to all log types.
            function forLogType(facetDef) {
                return facetDef.meta.logTypes === true ||
                    (facetDef.meta.logTypes || []).indexOf(logType) > -1;
            }
            function makeFacet(facetDef) {
                return new SearchFacet(angular.extend({highlight: highlight}, facetDef));
            }
            function pluckSelector(facet) { return facet.selectors.history }
            function selectorNotIn(selectors) {
                return function(column) { return selectors.indexOf(column.selector) === -1 };
            }
            function addColumnExtras(column) {
                var extras = ({
                    logid: {
                        facetDef: {
                            tweakFilter: {
                                history: function(filter) {
                                    filter.value = filter.value.map(function(v) {
                                        // EG: 13 -> *000013 see #263679
                                        return '*' + ('000000' + v).substr(-6);
                                    });
                                }
                            }
                        }
                    },
                    srcip: {
                        facetDef: {
                            name: 'Source IP'
                        }
                    },
                    dstip: {
                        facetDef: {
                            name: 'Destination IP'
                        }
                    },
                    pri: {
                        addDescription: addLevelDescription,
                        facetDef: {
                            modifiers: ['!', ',', 'OR']
                        }
                    },
                    action: {
                        langPrefix: 'Log::Action::',
                        sortValues: function(a, b) { return a.localeCompare(b) }
                    },
                    // Fix bug 0531808
                    /* proto: {
                        //not ideal, if the protocol doesn't show on the first page it won't be
                        //shown and the user will have to type in the protocol # instead.
                        facetDef: {
                            getValues: function(entries) {
                                var inherited = SearchFacet.prototype
                                    .getValues.apply(this, arguments);
                                this._entriesMap = $q.when(entries).then(makeMap);
                                return $q.all(inherited, this._entriesMap);

                                function makeMap(entries) {
                                    //true if reverse, otherwise false.
                                    var em = entries.reduce(r, {'true': {}, 'false': {}});

                                    return em;

                                    function r(em, entry) {
                                        em[true][entry.protocol] = entry.proto;
                                        em[false][entry.proto] =
                                            String(entry.protocol).toUpperCase();
                                        return em;
                                    }
                                }
                            },
                            lookup: function(key, reverse) {
                                if (this._entriesMap) {
                                    return this._entriesMap.then(function(em) {
                                        return em[!!reverse][key];
                                    });
                                }
                            }
                        }
                    }, */
                    app: {
                        facetDef: {
                            hint: 'See Also: Service'
                        }
                    }
                })[column.selector];
                if (extras) {
                    column = angular.extend({}, extras, column);
                }
                return column;
            }

            function addLevelDescription(value) {
                value.description = $sce.trustAsHtml(
                    '<span class="log_severity_level log_severity_' +
                    $sanitize(value.key) + '" title="' + $sanitize(value.value) + '">' +
                    '</span>');
                return value;
            }
        }
    };
    return function(providers) {
        //todo: prevent double registration?
        facets(providers);
        providers.$provide.service('loggingFacets', LoggingFacets);
    };
});
