/* globals define */
/* jshint maxparams: 10 */
define(['angular', 'fweb'], function(angular, fweb) {
    'use strict';

    var URLS = {
        //FWB_CHANGE COLUMN: '/:CONFIG_GUI_NO/p/logs/:logType/column/',
        COLUMN: '/log/display/column',//FWB_CHANGE
        AV_ARCHIVE: '/p/logs/av_archive/:checksum/:filename/',
        IPS_ARCHIVE: '/p/logs/pkt_list/:roll/:_pcap_id/:_pcap_category/',
        DLP_ARCHIVE_DOWNLOAD: '/log/display_content',
        DLP_ARCHIVE_EMAIL: '/log/display_email',
        AV_ARCHIVE_DOWNLOAD: '/api/v2/monitor/utm/av-archive/download/',
        IPS_ARCHIVE_DOWNLOAD: '/api/v2/monitor/log/ips-archive/download/',
        POLICY_ARCHIVE_DOWNLOAD: '/api/v2/monitor/log/policy-archive/download/',
        //FWB_CHANGE DATA: '/p/logs/:logType/json/',
        DATA: '/ng/fortiview/logs_json',
        RAW: '/p/logs/:logType/raw/?filter=',
        LOG_VIEW: '/log/view/:logType'
    };

    /**
     * Create a log viewer resource from a given url.
     * @param  {String} url Url that should be queried for this resource.
     * @param  {String} [property] Property to pluck from the result data on get() requests.
     *                           Use #getWithMeta() to get the whole resource instead.
     * @param  {Function(DI):Object} [extras] Dependency Injectable function which returns
     *                                        an object who's properties will be added to the
     *                                        returned resource 'class'
     * @param  {Function(Object):Object} [paramSerializer] Function which performs extra param
     *                                                     serialization.
     * @return {Object} Resource 'class' object (created by `$resource`) with additional `extras`
     *                  methods and an optional `getWithMeta()` resource action
     *                  (if property !== null)
     */
    function logViewResource(url, property, extras, paramFilter) {
        return function factory($injector, $resource, $routeParams, logParamSerializer) {
            var params = {
                logType: function() { return $routeParams.logType }
            },
            commands = {
                get: {
                    isArray: !!property,
                    method: 'GET',
                    params: params,
                    paramSerializer: logParamSerializer.bind(null, null)
                }
            };
            if (!!property) {
                commands.getWithMeta = {
                    method: 'GET',
                    params: params,
                    /* FWB_CHANGE */
                    paramSerializer: function(params) {
                        function serializeValue(v) {
                            if (angular.isObject(v)) {
                                return angular.isDate(v) ? v.toISOString() : angular.toJson(v);
                            }
                            return v;
                        }
                        
                        var parts = [];
                        angular.forEach(params, function(value, key) {
                            if (value === null || angular.isUndefined(value)) return;
                            if (angular.isArray(value)) {
                                angular.forEach(value, function(v) {
                                    parts.push(encodeURIComponent(key)  + '=' + encodeURIComponent(serializeValue(v)));
                                });
                            } else {
                                parts.push(encodeURIComponent(key) + '=' + encodeURIComponent(serializeValue(value)));
                            }
                        });

                        return parts.join('&');
                    },
                    interceptor: {
                        response: function (response) {
                            if (response.data.status == 0) {
                                switch(response.data.msg_id) {
                                    case -30:
                                        top.location.href = "/login";
                                        break;
                                    case -37:
                                        document.location.href = "/noaccess";
                                        break;
                                    default :
                                        document.location.href = "/error?msg=" + response.data.msg_id;
                                        break;
                                }
                            }
                            return response.data;
                        }
                    },
                };
                commands.get.transformResponse = function(response) {
                    var data = angular.fromJson(response);
                    return data[property];
                };
            }
            if (extras && typeof extras === 'function') {
                extras = $injector.invoke(extras);
            }
            var result = $resource(url, {}, commands);
            if (paramFilter) {
                var resultGet = result.get;
                result.get = function(params) {
                    params = paramFilter(params);
                    return resultGet.call(this, params);
                };
            }
            return extras ? angular.extend(result, extras) : result;
        };

    }

    function logViewExtras($routeParams, $route, $location, ftntRoute, structure) {
        return {
            navigate: function(filter, logType) {
                var rp = angular.extend({}, $routeParams, {logType: logType}),
                    url = ftntRoute.interpolate(URLS.LOG_VIEW, rp);
                return structure
                    .ngRouteURI(url + '?filter=' + encodeURIComponent(JSON.stringify(filter)));
            },
            download: function(filter, logType) {
                var rp = angular.extend({}, $routeParams, {logType: logType}),
                    rawPath = ftntRoute.interpolate(URLS.RAW, rp) +
                    encodeURIComponent(JSON.stringify(filter));
                return rawPath;
            }
        };
    }


    /**
     * Generate archive data resources for each type of archive data.
     * @return {Object} Object containing archive data resource 'classes' for each type.
     * Each resource 'class' contains:
     *  * get: Function(params):Resource - A resource getter. Pass in the log row as 'params' and
     *      the correct log columns will be used to get the data (or passed back as 'fake' data)
     *  * download
     */
    function archiveDataFactory($q, $injector, ftntRoute, logParamSerializer) {

        /**
         * Maps of log entry object keys to get query parameters. See paramMapSerializer
         * If a key is a function, it will be called instead of the result of paramMapSerializer()
         * @type {Object|Function}
         */
        var paramMaps = {
                av: ftntRoute.extractVarMap(URLS.AV_ARCHIVE),
                ips: ftntRoute.extractVarMap(URLS.IPS_ARCHIVE),
                dlp: {
                    logid: 'archive_name:max_archive_sn',
                    device: 'device_id',
                    type: 'service_type',
                    roll: 'roll',
                    filename: 'filename'
                },
                traffic: {
                    dstip: 'dstip',
                    srcip: 'srcip'
                }
            },
            defaults = {
                ips: {_pcap_category: 0}
            },
            // resource definitions
            res = {
                av: {
                    download: function(data) {
                        // 8 digit padded hexadecimal
                        var hexCheckSum = ('00000000' + data.checksum.toString(16)).substr(-8);
                        var url = URLS.AV_ARCHIVE_DOWNLOAD + hexCheckSum + '/';
                        return url;
                    }
                },
                ips: {
                    download: function(data, params) {
                        params = {
                            pcap_no: data.roll,
                            pcap_category: data._pcap_category
                        };
                        var url = URLS.IPS_ARCHIVE_DOWNLOAD + data._pcap_id + '/?' +
                            logParamSerializer(null, params);
                        return url;
                    }
                },
                dlp: {
                    _fakeResourceColumns:
                        ['timestamp', 'srcip', 'dstip', 'sentbyte', 'rcvdbyte', 'service'],
                    get: fakeResourceGetter,
                    download: function(downloadData, params) {
                        var filename;
                        if (!params.filename) {
                            var timestamp = String(params.timestamp).replace(/[\s|:]+/g, '_'),
                                sn = params.max_archive_sn,
                                suffix =  sn > 0 ? ('-' + sn) : '';
                            filename = 'dlp_archive-' + timestamp + suffix;
                            params = angular.extend({filename: filename}, params);
                        }
                        return URLS.DLP_ARCHIVE_DOWNLOAD + '?' +
                            logParamSerializer(paramMapFilter(paramMaps.dlp), params);
                    }
                },
                traffic: {
                    _fakeResourceColumns: ['timestamp', 'srcip', 'dstip', 'sentbyte', 'rcvdbyte'],
                    get: fakeResourceGetter,
                    downloadPacketCapture: function(downloadData, params) {
                        var sessionid = params.sessionid;
                        params = paramMapFilter(paramMaps.traffic)(params);
                        // don't show the button if the src/dst/sid are missing.
                        // Happens if the file does not exist.
                        if (!params.srcip || !params.dstip || !sessionid) {
                            return null;
                        }
                        var url = URLS.POLICY_ARCHIVE_DOWNLOAD + sessionid + '/?' +
                            logParamSerializer(null, params);
                        return url;
                    }
                }
            },
            // used by lvrFactory. Take paramMaps and generate a paramFilter function for each.
            paramFilters = Object.keys(paramMaps).reduce(function(result, key) {
                result[key] = paramMapFilter(paramMaps[key], defaults[key]);
                return result;
            }, {}),

            result = {
                av: lvrFactory(URLS.AV_ARCHIVE, 'av'),
                ips: lvrFactory(URLS.IPS_ARCHIVE, 'ips'),
                dlp: res.dlp,
                traffic: res.traffic
            };
        result.app = result.ips;
        return result;

        /**
         * Generate a real logViewResource with the correct extra methods and paramFilter
         * @param  {String} url  Url to backend resource
         * @param  {String} type Key from res/paramFilter objects.
         * @return {Resource} ngResource object with methods from res[type] grafted on.
         */
        function lvrFactory(url, type) {
            return $injector.invoke(logViewResource(url, null, res[type], paramFilters[type]));
        }

        /**
         * Expand some parameters and remove other extraneous parameters.
         * @param  {Object} [paramMap] key/value map where keys are *output* query parameter keys
         *                             and values are *input* query parameter keys.
         *                             If the value contains the ':' character the values contained
         *                             in the two columns it separates will be joined with a ':'
         * @returns {Function(Object):Object} Manipulated parameters.
         */
        function paramMapFilter(paramMap, defaults) {
            return function(params) {
                var i, result = {};
                if (paramMap) {
                    for (i in paramMap) {
                        var cols = paramMap[i].split(':').filter(inParams);
                        if (cols.length) {
                            result[i] = cols.map(colValue).join(':');
                        } else if (i in defaults) {
                            result[i] = defaults[i];
                        }
                    }
                }
                return result;

                function colValue(col) { return params[col] }
                function inParams(col) { return col in params }

            };
        }

        // sometimes the backend doesn't provide any data, in that case we use log data (params)
        function fakeResourceGetter(params) {
            /* jshint validthis: true *//* this is an archiveData 'resource'*/
            var cols = this._fakeResourceColumns.reduce(toObject, {});
            var res = {data: paramMapFilter(cols)(params)};
            return angular.extend({$promise: $q.when(res)}, res);

            function toObject(result, key) {
                result[key] = key;
                return result;
            }
        }

    }

    function logParamSerializerFactory($httpParamSerializer) {
        /**
         * Slightly different paramSerializer that doesn't expand arrays to multiple params
         * $httpParamSerializer changes value:[1,2] => value=1&value=2
         * @param  {[type]} [filter=null] Optional extra filter
         * @return {Object} Output params.
         */
        return function logParamSerializer(filter, params) {
            params = angular.copy(params);
            var result = filter ? filter(params) : params;
            for (var i in result) {
                if (Array.isArray(result[i])) {
                    result[i] = [result[i]];
                }
            }
            return $httpParamSerializer(result);
        };
    }

    return function(providers) {
        var fwebParams = {CONFIG_GUI_NO: fweb.CONFIG_GUI_NO};
        providers.$provide.factory({
            logViewData: logViewResource(URLS.DATA, 'source', logViewExtras),
            logViewColumns: logViewResource(URLS.COLUMN, 'columns', null, null, fwebParams),
            logViewDefaultColumns:
                logViewResource(URLS.COLUMN, 'default_columns', null, null, fwebParams),
            logArchiveData: archiveDataFactory,
            logParamSerializer: logParamSerializerFactory
        });
    };

});
