/* globals define */
define(['angular', 'module'], function(angular, module) {
    'use strict';

    function fLogDetailSection(loader, $timeout) {
        return {
            retrict: 'E',
            scope: {
                /**
                 * Buttons that should be shown next to the section title.
                 * @type {Object{icon:String, title: String, action: Function($event)}}
                 */
                titleButtons: '=',
                /**
                 * False if the section title should not be shown.
                 * @type {Boolean|String}
                 */
                showTitle: '&',
                /**
                 * @type {Section[]}
                 */
                section: '=',
                /**
                 * Array of lang prefixes to use in priority order to find the language key for each
                 * datum name.
                 * @type {String[]}
                 */
                datumNamePrefixes: '='
            },
            templateUrl: loader.base_path('detail-section.html', module),
            link: function(scope, elem) {
                var scrollEventName = 'scroll.detail-section-' + scope.$id;
                // debounce this because some $digests are slow.
                var timeout;
                elem.scrollParent().on(scrollEventName, function() {
                    $timeout.cancel(timeout);
                    timeout = $timeout(function() {
                        scope.scrollTop = this.scrollTop;
                    }.bind(this));
                });
                scope.$on('$destroy', function() { elem.off(scrollEventName) });
                var shortExpr = /^([a-z\d]+)\s+(?:[A-Z0-9]{2} )+ +/gmi;
                scope.shortenDump = function(dump) {
                    return dump.replace(shortExpr,'$1 ');
                };
            }
        };
    }

    return function(providers, loader) {
        providers.$compile.directive({
            fLogDetailSection: fLogDetailSection
        });
        return loader.initModules(['f-log-detail-datum'], module);
    };
});
