/* globals define */
define([
    'module', 'angular', 'fweb', 'ng/services/injector', 'fweb.util/policy'
], function(module, angular, fweb, inject, fPolicy) {
    'use strict';
    function fLogViewMenu(loader) {
        return {
            restrict: 'E',
            scope: {
                menu: '=',
                logView: '='
            },
            bindToController: true,
            controllerAs: 'logViewMenu',
            controller: LogViewMenu,
            templateUrl: loader.base_path('menu.html', module)
        };
    }

    function LogViewMenu($scope, $routeParams, injector) {
        injector.injectMarked(this, {$scope: $scope});

        // publish some things on the scope for convenience.
        $scope.$watchCollection(
            '{ logView: logViewMenu.logView, menu: logViewMenu.menu }',
            function(scopeVars) {
                angular.extend($scope, scopeVars);
            }
        );
        this.watchPopUp();
        // sets up state info for quarantine and policy menus.
        this.watchEntries();
        this.PERSIST_KEY = 'LogView.' + this.logView.logType();
    }

    LogViewMenu.urls = {
        deviceDetails: '/p/user/device_details/json/:srcMac'
    };

    LogViewMenu.prototype = {
        /**
         * Contains policy state info to show/hide menu items
         * @type {Object}
         * @see  #watchEntries
         */
        policy: null,
        /**
         * Contains quarantine state info to show/hide menu items
         * @type {Object}
         * @see  #watchEntries
         */
        quarantine: null,
        /**
         * Facet used to generate the pop-up menu items.
         * @type {SearchFacet}
         */
        popUpColumnFacet: null,
        /**
         * Filters which can be added using the pop-up menu
         * @type {Object[][]}
         */
        popUpColumnFilters: [],
        watchPopUp: inject.mark(function($scope) {
            return function watchPopUp() {
                if (this.menu.popUpMenu) {
                    $scope.$watchCollection(
                        '{selector: menu.columnSelector, value: menu.columnValue}',
                        function(column) {
                            var facet = null,
                                found = false,
                                complex = !this.logView.embeddedType;
                            if (column.selector && (column.value || complex)) {
                                facet = this.logView.facetBySelector('history', column.selector);
                                found = !this.logView.embeddedSearchFacets ||
                                    this.logView.embeddedSearchFacets.indexOf(facet) > -1;
                            }
                            if (facet && found) {
                                this.popUpColumnFilters = facet
                                    .contextFilters(column.value, complex);
                                this.popUpColumnFacet = facet;
                            } else {
                                this.popUpColumnFacet = null;
                                this.popUpColumnFilters = [];
                            }
                        }.bind(this)
                    );
                }
            };
        }),
        watchEntries: inject.mark(function($scope, $routeParams, state, $resource) {
            return function watchEntries() {
                var isForwardTrafficPage = this.logView.logType() === 'forward_traffic' ||
                        this.logView.logType() === 'fortiview_traffic',
                    perm = {
                        readFirewall:
                            state.adminHasReadPermission(state.ACCESS_GROUP.FIREWALL_POLICY),
                        writeFirewall:
                            state.adminHasWritePermission(state.ACCESS_GROUP.FIREWALL_POLICY),
                        writeDevice: state.adminHasWritePermission(state.ACCESS_GROUP.USER_DEVICE)
                    };

                // watch object identity for these two objects
                $scope.$watchCollection('menu.entries', watchAction.bind(this));
                // also deep watch state
                $scope.$watch('logView.state', watchAction.bind(this), true);

                function watchAction(lvState) {
                    /* jshint validthis: true */
                    var entries = $scope.menu && $scope.menu.entries;
                    if (!entries || !lvState) {
                        return;
                    }

                    this.policy = lvState.policy || {
                        show: isForwardTrafficPage && perm.readFirewall,
                        readOnly: !perm.writeFirewall,
                        viewEdit: false
                    };
                    this.quarantine = lvState.quarantine || {
                        show: isForwardTrafficPage && perm.writeDevice,
                        device: false,
                        sourceIp: false,
                        sourceIpColumnName: 'srcip'
                    };
                    var len = (entries || []).length,
                        one = len === 1,
                        data = one && entries[0];

                    this.policy.viewEdit =
                        this.policy.show && one && !fPolicy.disablePolicyAction(data);
                    if (this.policy.viewEdit) {
                        fPolicy.policyMetaLookup(data.policyid, data.policytype,
                            data.subtype, storePolicyMeta.bind(this));
                    }
                    this.quarantine.sourceIp = this.quarantine.show && one &&
                        !!data[this.quarantine.sourceIpColumnName];
                    $scope.canQuarantineSourceIp = one && !!data.srcip;
                    if (one) {
                        getDeviceDetails(data.srcmac).then(function(res) {
                            if (res && res.device) {
                                this.quarantine.device = res.device.state === 'registered';
                            }
                        }.bind(this));
                    } else {
                        this.quarantine.device = false;
                    }
                    function storePolicyMeta(policyMeta) {
                        /* jshint validthis: true */
                        policyMeta.policytype = data.policytype;
                        this.policy.matching = policyMeta;
                    }

                    function getDeviceDetails(srcmac) {
                        var url = LogViewMenu.urls.deviceDetails;
                        var deviceDetails = $resource(url).get({srcMac: srcmac});
                        return deviceDetails.$promise;
                    }
                }
            };
        }),
        editPolicy: inject.mark(function($location, structure) {
            return function editPolicy() {
                var entry = this.menu.lastSelectedEntry;
                fPolicy.getMatchingPolicyEditUrl('policyid', entry).then(function(url) {
                    var search = url.search,
                        urlPath = structure.ngURI(url.path);
                    search.redir = structure.getAbsolutePath();
                    $location.path(urlPath);
                    $location.search(url.search);
                });
            };
        }),
        showInPolicyList: inject.mark(function($location, structure) {
            return function() {
                var entry = this.menu.lastSelectedEntry;
                fPolicy.getMatchingPolicyListUrl('policyid', entry).then(function(url) {
                    var urlPath = structure.ngURI(url.path);
                    $location.path(urlPath);
                    $location.search(url.search);
                });
            };
        }),
        addContextFilter: function(valueOption) {
            this.logView.addToFacetModel(this.popUpColumnFacet, valueOption);
        }
    };

    return function(providers, loader) {
        providers.$compile.directive({
            fLogViewMenu: fLogViewMenu
        });
        return loader.initModules([
            'facets'/*FWB_CHANGE, '/ng/directives/menu/quarantine-options'*/
        ], module);
    };
});
