/* globals define */
/* jshint maxparams: 10 */
define([
    'module', 'angular', 'fweb', 'fweb.util/dom', 'fweb.util/objects',
    'ng/services/injector', 'byod_common', 'fgd_common', 'ftnt_shared'
],
function(module, angular, fweb, fDom, fObj, inject, byod_common, fgd_common, ftntShared) {
    'use strict';
    //FWB_CHANGE var SYMBOLS = fweb.BUILD.SYMBOLS;
    var SYMBOLS = fweb.BUILD && fweb.BUILD.SYMBOLS || {};//FWB_CHANGE
    var FDS_OR_FAZ = [SYMBOLS.LOG_PRESENT_DEVICE_FDS, SYMBOLS.LOG_PRESENT_DEVICE_FAZ];
    var ftExpr = /^FIELD_TYPE_/;
    // pull the field types from build symbols
    //FWB_CHANGE var FIELD_TYPE = Object.keys(fweb.BUILD.SYMBOLS).reduce(function(ft, key) {
    var FIELD_TYPE = Object.keys(fweb.BUILD && fweb.BUILD.SYMBOLS || {}).reduce(function(ft, key) {//FWB_CHANGE
        if (ftExpr.test(key)) {
            ft[key.replace(ftExpr, '')] = SYMBOLS[key];
        }
        return ft;
    }, {});
    var FIELD_TYPE_STRINGS = Object.keys(FIELD_TYPE).reduce(function(result, ft) {
        result[FIELD_TYPE[ft]] = ft.toLowerCase();
        return result;
    }, []);

    function fLogView(loader) {
        return {
            restrict: 'E',
            controllerAs: 'logView',
            controller: LogView,
            // These bindings are set by embedders to control the log viewer
            bindToController: true,
            scope: {
                /**
                 * Set the log type. If this parameter is set the f-log-view
                 * will require most other embedded parameters to be set.
                 * When an embeddedType is set, the facetModel and persist values will not be
                 * peristed by this directive.
                 * @optional
                 * @type {String}
                 */
                embeddedType: '<?logType',
                /**
                 * If specified this log view is part of a fortiview. Hides menus.
                 * @optional
                 * @type {String}
                 */
                fortiview: '<?',
                /**
                 * Facets that exist in the embedded context.
                 * @optional
                 * @type {Facets}
                 */
                embeddedFacets: '<?facets',
                /**
                 * List of facets that can be added to the search bar
                 * @optional
                 * @type {SearchFacet[]}
                 */
                embeddedSearchFacets: '<?searchFacets',
                /**
                 * Pass in any filters controlled by an outside source.
                 * @optional
                 * @type {Object|Objet[]} Keys are facet names and values are arrays of values.
                 * @see services/facets.js:Facets.makeQlistFilters()
                 */
                embeddedFacetModel: '<?facetModel',
                /**
                 * Extra log filters that can't be expressed as key:values[] facet model.
                 * @optional
                 * @type {Object[]}
                 */
                embeddedFilters: '<?filters',
                /**
                 * Override the currently selected device when present
                 * @optional
                 * @type {String}
                 */
                embeddedDevice: '@device',
                /**
                * Each column in the prepend array will be added at
                * the front of the default_columns list.
                * Columns in the remove array are removed from the default_columns list.
                * @optional
                * @type {Object{prepend:String[],remove:String[]}}
                */
                defaultColumnMods: '<?',
                /**
                 * Update this binding to show/hide the details view in the log viewer.
                 * @type {Boolean}
                 */
                embeddedShowDetails: '=?showDetails',
                /**
                 * Name of an event which will cause a reload when broadcast
                 * on the scope.
                 * @optional
                 * @type {String}
                 */
                refreshEvent: '@',
                /**
                 * When data has been loaded, this expression will be evaluated
                 * @param {Object[]} $entries Rows from the current page of the log view.
                 * @type {ngExpression}
                 */
                updateEntries: '&'
            },
            templateUrl: loader.base_path('main.html', module)
        };
    }

    function LogView($scope, injector) {
        injector.injectMarked(this, {$scope: $scope});
        // when embedding, we have to wait for the log-type binding to resolve.
        $scope.$watch('::logView.logType()', function(value) {
            if (value) {
                this._init();
            }
        }.bind(this));
    }



    LogView.url = {
        // TODO: (later) replace all of these with c api endpoints
        //FWB_CHANGE abort: '/p/logs/search/abort/:id/',
        abort: '/ng/fortiview/logs_json',
        //FWB_CHANGE config: '/p/logs/:logType/config/'
        config: '/ng/fortiview/log_config' //FWB_CHANGE
    };

    LogView.prototype = {
        /**
         * The current state of the log viewer search.
         * @type {Object}
         * @see #initState
         * @see #updateContentState
         * @see #updateColumnState
         */
        state: null,
        /**
         * Persistent state that causes a reload
         * @see #setupPersistence
         * @type {Object}
         */
        persist: null,

        /**
         * Persistent state that only updates view options, but doesn't reload data.
         * @see #setupPersistence
         * @type {Object}
         */
        viewPersist: null,
        /**
         * Log viewer configuration. Loaded from the device
         * @type {Object}
         */
        config: null,
        /**
         * Qlist options, filters, source
         * @type {Object}
         */
        qlist: null,
        /**
         * FacetedSearch model for search bar.
         * @type {Object{key:value[]}}
         */
        facetModel: null,
        /**
         * List of facets for faceted search
         * @type {SearchFacet[]}
         */
        facets: null,
        /**
         * Faceted Search options
         * @type {Object}
         */
        fsOptions: null,


        logType: inject.mark(function($routeParams) {
            return function() {
                return this.embeddedType || $routeParams.logType;
            };
        }),

        _init: inject.mark(function($scope, $resource, $http, $q, $route, ftntRoute, loggingFacets,
                Facets, LogFormatters, state) {
            return function _init() {
                // ensure all embedded info that's required has been set if we are embedded
                this.logFormatters = new LogFormatters(this.logType());
                if (this.embeddedType) {
                    var required = [
                        'embeddedFacets', 'embeddedFacetModel', 'embeddedFilters',
                        'embeddedDevice', 'embeddedType'
                    ].filter(function(k) { return this[k] === undefined }.bind(this));
                    if (required.length) {
                        throw new Error('f-log-view Missing embedded parameters: ' +
                            required.join(', '));
                    }
                    if (!(this.embeddedFacets instanceof Facets)) {
                        throw new Error('f-log-view facets paremeter must be' +
                            ' an instance of Facets from services/facets.js');
                    }
                }
                this.initState();
                var params = {logType: this.logType()};
                if (this.embeddedDevice) {
                    params.log_device = this.embeddedDevice;
                }
                //FWB_CHANGE this.config = $resource(LogView.url.config).get(params);
                this.qlist = {
                    click: function(event) {
                        var target = event.target;
                        if (target.tagName.toLowerCase() === 'a' &&
                                target.className === 'threat_details') {
                            this.detailTab = 'threats';
                            this.viewPersist.showDetails = true;
                        }
                    }.bind(this)
                };

                this.loading = {
                    content: null,
                    columns: this.getColumns().then(this._setColumns),
                    //FWB_CHANGE meta: this.config.$promise
                };
                // relies on this.loading.columns effectively.
                this.loading.content = this.getContent(null);
                this.setupPersistence();
                this.watchFacetModels();
                this._listenForReload();

                this.fsOptions = {
                    entries: function() { return this.qlist.source }.bind(this),
                    source: 'history',
                    complex: true,
                    filterMerge: {max: 1}
                };

                $q.all(this.loading).then(resolveResponses.bind(this), rejectResponses);

                var vdom = state.current_vdom;
                $scope.$on('$routeUpdate', function(event, data) {
                    var params = data.params;
                    if ('vdom' in params && params.vdom !== vdom) {
                        $route.reload();
                    }
                    if (JSON.stringify(this.qlist.filters) !== params.filter && params.filter) {
                        var filters = JSON.parse(params.filter || '[]');
                        this.facetModel = loggingFacets.facets.fromQlistFilters(filters, 'history');
                    }
                }.bind(this));
                $scope.$on('$destroy', function() {
                    if (this.state.session_id == null) {
                        // abort aborting, since there is nothing to abort.
                        return;
                    }
                    /*FWB_CHANGE var params = {
                        id: this.state.session_id,
                        logType: this.logType()
                    };*/
                    var params = {
                        session_id: this.state.session_id,
                        flag: 1
                    };
                    this.updateEntries({$entries: null});
                    //FWB_CHANGE $http.post(ftntRoute.interpolate(LogView.url.abort, params));
                    $http({
                        method: 'GET',
                        url: LogView.url.abort,
                        params: params
                    });
                }.bind(this));

                function resolveResponses(responses) {
                    /* jshint validthis: true *//* this = LogView instance */
                    // relies on the fact that updateColumnState and
                    // updateContentState have already been called
                    this.qlist.source = responses.content.source;
                    this._updateQlistOptions();
                }
                function rejectResponses() {
                    // TODO: notify?
                    console.error('ERROR OCCURRED:', arguments);
                }
            };
        }),
        /*FWB_CHANGE contentQuery: function(extra) {
            var result = {
                filter: this.qlist.filters,
                logType: this.logType()
            };
            if (this.persist.serial_no) {
                result.serial_no = this.persist.serial_no;
            }
            if (this.embeddedDevice) {
                result.log_device = this.embeddedDevice;
            }

            return angular.extend(result, extra);
        },*/
        contentQuery: inject.mark(
                function(fortigateInfo) {
            return function contentQuery(extra) {
                var result = {
                    filter: this.qlist.filters,
                    count: fortigateInfo.info.lines_per_page,
                    page: 1,
                    log_type: this.logType(),
                    session_id: 0
                };

                return angular.extend(result, extra);
            };
        }),
        /**
         * Populate the search facets with suggestions from new source data
         */
        populateFacets: function() {
            if (this.facets && this.qlist.source) {
                this.facets.forEach(function(facet) {
                    facet.populate(this.qlist.source, 'history');
                }.bind(this));
            }
        },
        setupPersistence: inject.mark(
                function($location, $scope, persistentStorage, state, facetedSearchUtil) {
            return function setupPersistence() {
                function unwatch(unwatchFn) { unwatchFn() }
                var watches = [];
                vdomChange = vdomChange.bind(this);
                $scope.$watch(function() { return state.current_vdom }, vdomChange);
                // need this to execute synchronously!
                vdomChange(state.current_vdom);
                function vdomChange(vdom, oldVdom) {
                    //FWB_CHANGE if (vdom === oldVdom) {
                    if (vdom && vdom === oldVdom) {//FWB_CHANGE
                        return;
                    }
                    /* jshint validthis: true *//* this is the log view controller */
                    watches.forEach(unwatch);
                    watches = [];

                    var vdomSegment = vdom ? 'vdom:' + vdom + '.' : '',
                        PERSIST_KEY_ALL = 'LogView.all',
                        PERSIST_KEY = 'LogView.' + vdomSegment + this.logType(),
                        MODEL_KEY = PERSIST_KEY + '.facetModel',
                        VIEW_PERSIST_KEY = PERSIST_KEY_ALL + '.view';

                    this.persist = persistentStorage.get(PERSIST_KEY_ALL);
                    if (!this.persist || this.embeddedType) {
                        this.persist = { serial_no: state.serial };
                    }
                    /*FWB_CHANGE this.config.$promise.then(function(config) {
                        var notFound = !config.ha_members ||
                            config.ha_members.indexOf(this.persist.serial_no) === -1;
                        if (notFound) {
                            this.persist.serial_no = state.serial;
                        }
                    }.bind(this));*/
                    this.viewPersist = persistentStorage.get(VIEW_PERSIST_KEY) || {};
                    try {
                        this.facetModel = persistentStorage.get(MODEL_KEY);
                        if (!this.facetModel || this.embeddedType) {
                            this.facetModel = {};
                        }
                    } catch (ex) {
                        this.facetModel = {};
                    }
                    if (oldVdom !== undefined) {
                        this.facetModel = facetedSearchUtil.jsonForModel(this.facetModel);
                    }
                    watches.push($scope.$watch('logView.persist', function(value, oldValue) {
                        if (value !== oldValue) {
                            if (!this.embeddedType) {
                                persistentStorage.put(PERSIST_KEY_ALL, value);
                            }
                            this.qlistFilterReload();
                        }
                    }.bind(this), true));
                    // same as persist, but don't reload.
                    watches.push($scope.$watch('logView.viewPersist', function(value, oldValue) {
                        if (value !== oldValue) {
                            persistentStorage.put(VIEW_PERSIST_KEY, value);
                        }
                    }, true));

                    if (!this.embeddedType) {
                        watches.push($scope.$watch('logView.facetModel', function(value) {
                            persistentStorage.put(MODEL_KEY, value);
                        }, true));
                    }
                    this.loading.columns.then(function() {
                        watches.push($scope
                            .$watchCollection('logView.qlist.filters', function(value) {
                                var search = $location.search();
                                if (search.filter) {
                                    search.filter = JSON.stringify(value);
                                    $location.search(search).replace();
                                }
                            }.bind(this)));
                    }.bind(this));
                }
            };
        }),
        _updateQlistFilters: inject.mark(function(loggingFacets) {
            return function _updateQlistFilters() {
                var embedded = translate(this.embeddedFacetModel, this.embeddedFacets),
                    facetModel = angular.extend({}, this.facetModel, embedded);
                // f-qlist watches filters and applys filter changes for us
                this.qlist.filters = loggingFacets.facets
                    .makeQlistFilters(facetModel, this.embeddedFilters);
                /**
                 * Translate the facet id's from embedded facet ids to logging facet ids
                 * @param  {Object} embedded        Facetmodel from embedder.
                 * @param  {SearchFacet[]} facets   Facets object from embedder.
                 * @return {Object} facetModel with keys from loggingFacets (not embeddedFacets)
                 */
                function translate(embedded, facets) {
                    var historyFacets = loggingFacets.facets.bySource('history');
                    return embedded && Object.keys(embedded).reduce(function(model, id) {
                        var embedFacet = facets.byId(id),
                            h = embedFacet.selectors.history,
                            facet = historyFacets[h];
                        if (!facet) {
                            facet = loggingFacets.addFacet(h);
                        }
                        if (embedFacet.tweakFilter) {
                            facet.tweakFilter = embedFacet.tweakFilter;
                        }
                        model[facet.id] = embedded[id];
                        return model;
                    }, {});
                }
            };
        }),
        allModels: function() { return {
            facetModel: this.facetModel,
            embeddedFacetModel: this.embeddedFacetModel,
            embeddedFilters: this.embeddedFilters
        }},
        watchFacetModels: inject.mark(function($scope) {
            return function watchFacetModels() {
                this.loading.columns.then(function() {
                    $scope.$watch('logView.allModels()', function(value, oldValue) {
                        if (value !== oldValue) {
                            this._updateQlistFilters();
                        }
                    }.bind(this), true);
                    $scope.$watch('logView._useServerSidePaging()', function(value, oldValue) {
                        if (value !== oldValue) {
                            this._updateQlistOptions();
                        }
                    }.bind(this));
                }.bind(this));

            };
        }),
        addToFacetModel: function(facet, valueOption) {
            var facetModel = this.embeddedFacetModel || this.facetModel;
            if (this.embeddedFacets) {
                facet = this.embeddedFacets.bySelector('history', facet.selectors.history);
            }
            if (facet) {
                var values = facetModel[facet.id];
                if (values === undefined) {
                    values = facetModel[facet.id] = [];
                }
                values.push(valueOption.key);
            }
        },
        // get the django endpoint for log viewer. (includes source and query metadata)
        getContent: inject.mark(function($scope, $q, $http, ftntRoute, logViewData) {
            return function getContent(query) {
                // wait for logViewMenu directive to populate the filters before getting content.

                return $q.when(this.loading.columns).then(function() {
                    query = angular.copy(query) || this.contentQuery();
                    query.filter = query.filter && JSON.stringify(query.filter);
                    this.populateFacets();
                    return logViewData.getWithMeta(query).$promise
                        .then(this.updateContentState.bind(this));
                }.bind(this));
            };
        }),
        reloadContent: inject.mark(function($scope) {
            return function reloadContent() {
                this.state.session_id = null;
                this._lastSessionId = null;
                this.qlist.source.length = 0;
                // TODO: stop touching qlistElement
                //FWB_CHANGE $scope.qlistElement.element.qlist('reload_page');
            };
        }),
        _disabledColumns: null,
        /**
         * @param  {Object} col Column definition from log_filter.pyx
         * @returns {Boolean} true if column should be disabled.
         */
        columnDisabled: function(col) {
            /* jshint bitwise: false */
            //FWB_CHANGE var device_id = this.config.device_id;
            if (!this._disabledColumns) {
                this._disabledColumns = [
                        '#',
                        '_is_archived',
                        'app_details',
                        'threat',
                        'sent_rcvd',
                        'clouddetails',
                        'action_outcome'
                    ];

                /*FWB_CHANGE if (this.config.log_type === 'av' && device_id !== SYMBOLS.LOG_PRESENT_DEVICE_FDS) {
                    this._disabledColumns.push('av_details');
                }*/
            }
            /*FWB_CHANGE if (device_id === SYMBOLS.LOG_PRESENT_DEVICE_FDS) {
                return this._disabledColumns.indexOf(col.selector) > -1 ||
                    (col.gui_disp & SYMBOLS.LOG_FIELD_FCLD_FILTER) === 0;
            } else */{
                return this._disabledColumns.indexOf(col.selector) > -1;
            }
        },
        _setColumns: inject.mark(function() {
            return function _setColumns(columns) {
                this.columns = columns.columns;
                return columns;
            };
        }),
        getColumns: inject.mark(function(logViewColumns) {
            return function getColumns() {
                //FWB_CHANGE return logViewColumns.getWithMeta({logType: this.logType()})
                return logViewColumns.getWithMeta({log_type: this.logType()})
                    .$promise.then(function(response) {
                        var columns = response.columns;
                        columns.forEach(function(col) {
                            var returntrue = function() { return true; };
                            // manually override the field type of some columns
                            if (col.novalidate) {
                                if (col.filter == null) { col.filter = {}; }
                                col.filter.validate = returntrue;
                            }

                            // TODO: some of these overrides should be done in log_filter.pyx
                            if (col.selector === 'itime') {
                                col.fld_type = FIELD_TYPE.TIME;
                            } else if (col.selector === 'idate') {
                                col.fld_type = FIELD_TYPE.DATE;
                            } else if (col.selector === 'timestamp') {
                                col.fld_type = FIELD_TYPE.DATE_TIME;
                            } else if (col.selector === 'rel_time') {
                                col.fld_type = FIELD_TYPE.DATE_TIME;
                            }
                            if ('fld_type' in col) {
                                col.type = FIELD_TYPE_STRINGS[col.fld_type];
                            }
                            col.disabled = this.columnDisabled(col);
                        }.bind(this));

                        // Allow column aliases, because no two columns can have the same selector.
                        // Otherwise the fields can't be individually shown or hidden.
                        return {
                            columns: columns.concat(columns.reduce(columnAliases, [])),
                            default_columns: response.default_columns
                        };

                        /**
                        * Generate list of column aliases.
                        **/
                        function columnAliases(columns, col) {
                            if ('alias' in col) {
                                columns.push(angular.extend({}, col, {
                                    'selector': col.alias,
                                    'alias': null,
                                    'alias_of': col.selector,
                                    'lang_key': col.alias_lang_key || col.alias
                                }));
                            }
                            return columns;
                        }
                    }.bind(this))
                    .then(this.updateColumnState.bind(this));
            };
        }),
        // not really injecting here, but should be a bound method.
        qlistSearchCompleted: inject.mark(function() {
            return function qlistSearchCompleted() {
                /* jshint validthis: true */
                return this.state.completed >= 100;
            };
        }),
        _qlistFetch: function(page_num, cb) {

            var query = this.contentQuery({
                session_id: this.state.session_id,
                page: page_num
            });
            if (page_num !== this.state.page_num) {
                this.state.page_num = page_num;
                this.qlist.source.length = 0;
            } else {
                query.fetched = this.qlist.source.length;
            }
            return this.getContent(query).then(function(data) {
                // cb() updates DOM so must happen first.
                this._lastSessionId = this.state.session_id;
                if (cb) {
                    cb(data);
                }
                var args = [this.qlist.source.length, 0].concat(data.source);
                this.qlist.source.splice.apply(this.qlist.source, args);
                this.qlist.source.totalPagedLines = data.total_lines;
                this.state.total_lines = data.total_lines;
                return data;
            }.bind(this));
        },
        /**
        * Fetch new data because a filter has been changed
        */
        qlistFilterReload: inject.mark(function($scope) {
            return function() {
                this._lastSessionId = null;
                $scope.qlistElement.element.find('tbody')
                    .append('<div class="loading-container flex-centered"><f-icon class="fa-loading icon-xxxl" ng-show="loading"></f-icon></div>');
                this.loading.content = this.getContent(null)
                    .then(function(data) {
                        $scope.qlistElement.element.find('tbody').find('.loading-container').remove();
                        data.source.totalPagedLines = data.total_lines;
                        this.state.total_lines = data.total_lines;
                        this.qlist.source = data.source;
                    }.bind(this));
            };
        }),
        /**
         * Fetch a new page for the qlist, and update the state to match.
         * @param {Number} page_num page to fetch.
         * @param {Function} cb calls this when finished.
         */
        qlistPageFetch: inject.mark(function($scope) {
            return function qlistPageFetch(page_num, cb) {
                if (this.state.session_id !== this._lastSessionId && this._lastSessionId !== null) {
                    // short circuit if another fetch happened in the mean time.
                    return;
                }
                // this is a qlist callback and outside the $digest cycle.
                $scope.$apply(function() {
                    this._qlistFetch(page_num, cb);
                }.bind(this));
            };
        }),
        // Keep track of the sessionid last used for paging.fetch
        _lastSessionId: null,
        _updateQlistOptions: function() {
            this.qlist.options = this.getQlistOptions(this.qlist.source, this.columns);
        },
        //FWB_CHANGE getQlistOptions: inject.mark(function($scope, lang) {
        getQlistOptions: inject.mark(function($scope, lang, fortigateInfo) {
            return function getQlistOptions(content, columns) {
                var defaultColumns = this.state.default_columns;
                // Prefix any column names that have language keys with the above prefix
                // seems like there are still valid use cases.
                columns.forEach(function(c) {
                    var key = c.lang_key || c.selector;
                    // Translated.trusted === true if the language key exists
                    if (c.lang_key !== null) {
                        c.lang_key = lang.getPrefixedKey('Log::Column.', key);
                    }
                });

                var sortCols = [],
                    defColMods = null;
                if (this.defaultColumnMods) {
                    defColMods = angular.extend({prepend: [], remove: []}, this.defaultColumnMods);
                    defaultColumns = fObj
                        .makeSet(defColMods.prepend.concat(defaultColumns), true)
                        .difference(defColMods.remove);
                    sortCols = defColMods.prepend;
                }
                function colOrder(cols, prop) {
                    return function sort(a, b) {
                        //sort by position in cols array, if a column isn't in the array
                        //then it goes at the end in the original order.
                        return index(prop ? a[prop] : a) - index(prop ? b[prop] : b);
                    };
                    function index(value) {
                        //if it's not found, shuffle it toward the back;
                        //(+columns will automatically go to the back because they won't match
                        //  because + has been stripped)
                        value = cols.indexOf(value);
                        return value > -1 ? value : Number.MAX_VALUE;
                    }
                }
                //sort by language translated order.
                function langOrder(a, b) {
                    return ftntShared.util.fastLocaleCompare(
                        lang(a.lang_key).toString(),
                        lang(b.lang_key).toString()
                    );
                }
                var prefix = 'qlist-log.' + this.logType();
                if (defColMods) {
                    prefix += '.wdc-' +
                        defColMods.prepend.join('_') + '-' +
                        defColMods.remove.join('_');

                }
                this._lastSessionId = this.state.session_id;
                var qlistSettings = {
                    columns: columns
                        .sort(langOrder)
                        .sort(colOrder(sortCols, 'selector')),
                    default_columns: defaultColumns,
                    checkboxes: {
                        enabled: false,
                        hide_disabled: false
                    },
                    options: {
                        hide_default_buttons: true,
                        fixed_footer: true,
                        hide_menu: true,
                        disable_context_menu: !this.fortiview,
                        force_context_menu: !!this.fortiview,
                        resize_to_parent: false,
                        css_layout: true,
                        focusable_rows: true
                    },
                    column_filters: {
                        enabled: false,
                        highlight: { enabled: !this.fortiview },
                        //FWB_CHANGE log_type: this.config.log_type,
                        log_type: null,
                        // disable default filtering
                        filter_fn: null,
                        server_side_reload: this.qlistFilterReload
                    },
                    row_attr: [
                        {selector: '#', name: 'mkey'}
                    ],
                    format_fn: {
                        // set default to escape all outputs prevent XSS Injection
                        '*': function(td, col, entry) {
                            return fDom.escapeHTML(entry[col.selector]);
                        }
                    },
                    paging: {
                        enabled: !this._useServerSidePaging(),
                        server_side: true,
                        total_lines: this.state.total_lines,
                        completed: this.qlistSearchCompleted,
                        //FWB_CHANGE last_page_button: FDS_OR_FAZ.indexOf(this.config.device_id) === -1,
                        page_lines: fortigateInfo.info.lines_per_page,//FWB_CHANGE
                        last_page_button: true,
                        fetch: this.qlistPageFetch,
                        timeout: 500
                    },
                    prefix: prefix
                };
                // delegate the format function to the appropriate formatter function
                this.logFormatters.autoAll(qlistSettings.format_fn);
                /*FWB_CHANGE qlistSettings.after_format_fn = this.logFormatters
                    .hoverFns(this.config.resolve_apps === 'enable');*/
                return qlistSettings;
            };
        }),
        _useServerSidePaging: function() {
            // Backend does not support server paging on logs filtered by utmref
            return this.qlist.filters.some(isUtmRefFilter);

            function isUtmRefFilter(f) { return f.id === 'utmref' }
        },
        initState: function() {
            this.state = this.state || {};
        },
        _listenForReload: inject.mark(function($scope) {
            return function() {
                var unSubscribe;
                $scope.$watch('logView.refreshEvent', function(eventName) {
                    if (unSubscribe) {
                        unSubscribe();
                    }
                    if (eventName) {
                        unSubscribe = $scope.$on(eventName, function() {
                            this.refresh();
                        }.bind(this));
                    }
                }.bind(this));
            };
        }),
        /**
         * Update state properties from new content details.
         * @param  {Object} content contains details about the result and 'source'
         *                          (which is ignored).
         * @return {Object} content passed in for promise chaining.
         */
        updateContentState: function(content) {
            if(content.source && content.source.length) //FWB_CHANGE
                this.updateEntries({$entries: content.source});
            for (var prop in content) {
                if (prop !== 'source' && prop[0] !== '$' && typeof content[prop] !== 'function') {
                    this.state[prop] = content[prop];
                }
            }
            this.state.now = new Date(Date.parse(this.state.now));
            return content;
        },
        /**
         * Update this.state with new log column details (default_columns).
         * @param  {Object{default_columns:String[],columns:Object[]}} columns Data
         * @returns {Object} columns for promise chaining
         */
        updateColumnState: inject
            .mark(function($routeParams, loggingFacets, facetedSearchUtil, LogFormatters) {
            return function updateColumnState(columns) {
                var getQlistConfig = function() {
                    return this.qlist.options;
                }.bind(this);
                this.state.default_columns = columns.default_columns;

                // add filtered columns to default columns
                var facetColumns = columns.columns.filter(filterableColumn),
                    filters;
                //NOTE: loggingFacets.initFacets() must be called before fromQListFilters as it
                //adds the logging facets to the Facets instance.
                this.facets = loggingFacets.initFacets(this.logType(), facetColumns, highlight);

                //ugly!
                facetedSearchUtil.facets = loggingFacets.facets.byId();
                this.facetModel = facetedSearchUtil.jsonForModel(this.facetModel);
                this.populateFacets();

                /* jshint validthis: true */

                if ($routeParams.filter) {
                    filters = JSON.parse($routeParams.filter);
                    this.facetModel = loggingFacets.facets.fromQlistFilters(filters, 'history');
                    $routeParams.filter = null;
                }
                this._updateQlistFilters();
                var fm = this.embeddedFacetModel;
                if (fm) {
                    filters = this.embeddedFacets.makeQlistFilters(fm);
                    for (var i = 0, len = filters.length; i < len; ++i) {
                        var col = filters[i].id;
                        if (this.state.default_columns.indexOf(col) === -1 &&
                                columns.columns.some(isCol(col))) {
                            this.state.default_columns.push(col);
                        }
                    }
                }
                return columns;
                function isCol(col_name) {
                    return function(col) {
                        return col.selector === col_name;
                    };
                }

                function filterableColumn(column) {
                    return !column.disabled && !column.alias_of;
                }

                function highlight() {
                    /* jshint validthis: true *//* this is a SearchFacet */
                    var qlistConfig = getQlistConfig();
                    var chosen = false,
                        scm = LogFormatters.smartColumnMap,
                        selector = this.selectors.history;
                    if (qlistConfig && qlistConfig.chosen_columns) {
                        chosen = qlistConfig.chosen_columns.indexOf(selector) > -1;
                        if (!chosen && scm && (selector in scm)) {
                            selector = scm[selector];
                            chosen = qlistConfig.chosen_columns.indexOf(selector) > -1;
                        }
                    }
                    return chosen;
                }
            };
        }),
        facetBySelector: inject.mark(function facetBySelector(loggingFacets) {
            return function(source, key) {
                if (this.embeddedFacets) {
                    return this.embeddedFacets.bySelector(source)[key];
                } else {
                    return loggingFacets.bySelector(this.facets, source)[key];
                }
            };
        }),
        refresh: inject.mark(function() {
            return function refresh() {
                this.reloadContent();
            };
        }),
        downloadRaw: inject.mark(function(logViewData) {
            return function() {
                window.location.href = logViewData.download(this.qlist.filters, this.logType());
            };
        }),
        showDetails: function(update) {
            if (this.embeddedType) {
                if (update !== undefined) {
                    this.embeddedShowDetails = update;
                }
                return this.embeddedShowDetails;
            } else if (this.viewPersist) {
                if (update !== undefined) {
                    this.viewPersist.showDetails = update;
                }
                return this.viewPersist.showDetails;
            }
        }

    };

    return function(providers, loader) {
        providers.$compile.directive({
            fLogView: fLogView
        });

        return loader.initModules([
            'data',
            'formatters',
            'f-log-view-menu',
            'f-log-details',
            '/ng/directives/menu/templates'
        ], module);
    };
});
