/* globals define */
/* jshint maxparams: 9 */
define(['module', 'angular', 'ng/services/injector', 'ng/services/loader'
], function(module, angular, inject) {
    'use strict';
    function LoggingFacets(injector) {
        injector.injectMarked(this);
    }

    LoggingFacets.prototype = {
        /**
         * Unique facets collection for loggingFacets.
         * @type {Facets}
         */
        facets: null,
        /**
         * Add a facet on the fly. To be called /after/ #initFacets()
         * @param {String} selector Facet's history selector. (should be a logging column name)
         */
        addFacet: function(selector) {
            var columns = [{
                        selector: selector,
                        lang_key: selector
                    }].map(this._addColumnExtras),
                result = this.facets.genericFacets(columns, this.highlight);
            this.facets.addFacets(result);
            return result[0];
        },
        bySelector: function(facets, source) {
            facets = facets || this.facets;
            source = source || 'history';
            facets._bySource = facets._bySource || {};
            facets._bySource[source] = facets._bySource[source] || facets.reduce(bySelector, {});
            return facets._bySource[source];

            function bySelector(index, facet) {
                var value = facet.selectors[source];
                if (value) {
                    index[value] = facet;
                }
                if (facet.alias) {
                    index[facet.alias] = facet;
                }
                return index;
            }
        },
        initFacets: inject.mark(function(SearchFacet, Facets) {
            return function forLogType(logType, columns, highlight) {
                var facets = new Facets(),
                    result = facets.facetDefs.filter(hasLogType).map(makeFacet),
                    selectors = result.map(pluckSelector);
                this._bySource = null;
                this.facets = facets;
                this.highlight = highlight;
                columns = (columns || []).filter(selectorNotIn(selectors))
                    .map(this._addColumnExtras);
                var extraFacets = facets.genericFacets(columns, this.highlight);
                facets.addFacets(extraFacets);
                return result.concat(extraFacets);

                //meta.logTypes = true to apply to all log types.
                function hasLogType(facetDef) {
                    return facetDef.meta.logTypes === true ||
                        (facetDef.meta.logTypes || []).indexOf(logType) > -1;
                }
                function makeFacet(facetDef) {
                    return new SearchFacet(angular.extend({highlight: highlight}, facetDef));
                }
                function pluckSelector(facet) { return facet.selectors.history }
                function selectorNotIn(selectors) {
                    return function(column) { return selectors.indexOf(column.selector) === -1 };
                }
            };
        }),
        _addColumnExtras: inject.mark(
                function($q, $sce, $sanitize, Facets, ComplexValue, SearchFacet) {
            return function _addColumnExtras(column) {
                var noRangeSplitter = {
                    facetDef: {
                        modifiers: ['!', ','],
                        complexValue: function(value, convert) {
                            var isComplex = value instanceof ComplexValue;
                            if (!isComplex && convert) {
                                value = new ComplexValue(value);
                            }
                            if (isComplex || convert) {
                                value = value.withModifiers(this.modifiers);
                            }
                            return value;
                        }
                    }
                };
                var extras = ({
                    logid: {
                        facetDef: {
                            tweakFilter: {
                                history: function(filter) {
                                    filter.value = filter.value.map(function(v) {
                                        // EG: 13 -> *000013 see #263679
                                        return '*' + ('000000' + v).substr(-6);
                                    });
                                }
                            }
                        }
                    },
                    policyid: {
                        facetDef: {
                            modifiers: [',', 'OR'],
                            getValues: this.facets.policyIdGetter,
                            contextFilters: function(key) {
                                if (!key) {
                                    return null;
                                } else {
                                    return [[
                                        new SearchFacet.ValueOption(key, key)
                                    ]];
                                }
                            }
                        }
                    },
                    level: {
                        addDescription: addLevelDescription,
                        facetDef: {
                            modifiers: ['!', ',', 'OR']
                        }
                    },
                    action: {
                        langPrefix: 'Log::Action::',
                        sortValues: function(a, b) { return a.localeCompare(b) }
                    },
                    proto: {
                        //not ideal, if the protocol doesn't show on the first page it won't be
                        //shown and the user will have to type in the protocol # instead.
                        facetDef: {
                            populate: function(entries) {
                                var inherited = SearchFacet.prototype
                                    .populate.apply(this, arguments);
                                this._entriesMap = $q.when(entries).then(makeMap);
                                return $q.all([inherited, this._entriesMap]).then(returnFirst);

                                function returnFirst(promises) {
                                    return promises[0];
                                }
                                function makeMap(entries) {
                                    //true if reverse, otherwise false.
                                    var em = entries.reduce(r, {'true': {}, 'false': {}});

                                    return em;

                                    function r(em, entry) {
                                        em[true][entry.protocol] = entry.proto;
                                        em[false][entry.proto] =
                                            String(entry.protocol).toUpperCase();
                                        return em;
                                    }
                                }
                            },
                            lookup: function(key, reverse) {
                                if (this._entriesMap) {
                                    return this._entriesMap.then(function(em) {
                                        return em[!!reverse][key];
                                    });
                                }
                            }
                        }
                    },
                    app: {
                        facetDef: {
                            hint: 'See Also: Service'
                        }
                    },
                    utmref: noRangeSplitter,
                    url: noRangeSplitter
                })[column.selector];
                if (extras) {
                    column = angular.extend({}, extras, column);
                }
                return column;

                function addLevelDescription(value) {
                    value.description = $sce.trustAsHtml(
                        '<span class="log_severity_level log_severity_' +
                        $sanitize(value.key) + '" title="' + $sanitize(value.value) + '">' +
                        '</span>');
                    return value;
                }
            };
        })
    };
    return function(providers, loader) {
        var result = loader.initModules([
            '/ng/services/facets',
            '/ng/directives/faceted_search/faceted_search'
        ], module);
        providers.$provide.service('loggingFacets', LoggingFacets);
        return result;
    };
});
