define(['angular', 'app', 'jquery', 'lang.wizard', 'notify'], function(ng, app, $) {

	function CreateList($scope, $rootScope, $timeout, $route, lang, $http, Notify) {

		$scope.$on('wizard_saving', function() {
			save_data();
		});

		function save_data() {
			var url = "/waf/ml_bot_detection_policy/create",
				parseFields = ['automatic_refresh_model', 'anomaly_detection_method', 'action_protential', 'action_definitely', 'attack_validation', 'action_page_method', 'app_change_sensitivity'];
				formData = $scope.form_data;

			angular.forEach(parseFields, function(field) {
				formData[field] = parseInt(formData[field]);
			});

			angular.forEach($scope.wz_model.domains_collection, function(domain) {
				if (domain)
					formData.allow_domain.push(domain);
			});
			angular.forEach($scope.wz_model.ips_collection, function(ip) {
				if (ip)
					formData.allow_ip.push(ip);
			});

			var config = {
				headers: {
					'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
				},
				transformRequest: function(data) {
					return $.param({
						'ng_post': JSON.stringify(data)
					})
				}
			};

			$http.post(url, formData, config)
				.success(function(data, status) {
					if (data.status == 1) {
						$scope.go($scope.wz_model.return_url);
					} else {
						switch (data.msg_id) {
							case -30:
								top.location.href = "/login";
								break;
							case -37:
								document.location.href = "/noaccess?redir=/prot/policy/list";
                            	break;
                            default:
                            	document.location.href = "/error_redir?msg=" + data.msg_id + "&redir=" + $scope.wz_model.return_url;
						}
					}
				})
				.error(function(data, status) {
					var error_msg = "Bad HTTP Response : " + status;
					Notify.post(error_msg, 'error');
				});
		}
	}

	app.controller('CreateList', CreateList);
});
