define(['angular', 
	'jquery', 
	'angular-ui-tree', 
	'angular-route', 
	'fweb', 
	'ftnt_shared', 
	'ng/ftnt', 
	'ng/services/lang', 
	'ml_module',
	'nav',
	'f-ml-highchart',
	'f-ml-chart',
	'f-ml-dlg',
	'ml_compare_bar',
	'detail_controller',
	'tabs',
	'ng/directives/qlist',
	'ng/directives/ftnt',
	'ng/directives/menu/menu',
	'data',
	'highcharts/highcharts',
	'ml_treeview_arg',
	'sidebar-resizer',
	'jquery.form',
	'ml_log_arg',
	'ml_progress_bar',
	'search_controller',
	'injector',
	'facets',
	'active_facet',
	'faceted_search',
	'facet_input',
	'facet_modifier',
	'search_facet'
], function(angular){
	"use strict";
	var app = angular.module("mlApp", ["ui.tree", "ngRoute", "ngResource", "ngSanitize", "route-segment", 
				"view-segment", "ftnt", "ftnt-gui", "mlTemplate"]);
	    
	// stub for compatibility with ng_app default menu template
    app.controller('QlistCustomMenuItems', function() {});

	angular.module("mlApp")
	       .config(appConfig);
	appConfig.$inject = ["$routeSegmentProvider", "$rootScopeProvider"];
	function appConfig($routeSegmentProvider, $rootScopeProvider){
		$routeSegmentProvider.when('/detail/:leaf', 's1').
			when('/detail/:leaf/:arg_id/:arg_name/:learn_stat/:arg_ratio/:max_arg_ratio/:cur_time/:max_time/:sample_collecting_mode/:arg_sample_cnt', 's2').
			when('/log/:leaf/:arg_id/:learn_stat', 's3').
			when('/no_record/:leaf', 's4').
			segment('s1', {
				templateUrl: '/ng/ml/treeview/views/ml_detail.html?q=' + CONFIG_GUI_NO,
				controller: 'DetailController',
				controllerAs: '$ctrl',
				dependencies: ['leaf']
			}).
			segment('s2', {
				templateUrl: '/ng/ml/treeview/views/ml_url_arg.html?q=' + CONFIG_GUI_NO,
				controller: 'UrlArgController',
				controllerAs: '$ctrl',
				dependencies: ['leaf', 'arg_id']
			}).
			segment('s3', {
				templateUrl: '/ng/ml/treeview/views/ml_log_arg.html?q=' + CONFIG_GUI_NO,
				controller: 'LogArgController',
				controllerAs: '$ctrl',
				dependencies: ['leaf', 'arg_id']
			}).
			segment('s4', {
				templateUrl: '/ng/ml/treeview/views/ml_no_record.html?q=' + CONFIG_GUI_NO,
				controller: 'DetailController',
				controllerAs: '$ctrl',
				dependencies: ['leaf']
			});
		 $rootScopeProvider.digestTtl(20);
	}
	return app;
});
