define(['ml_module'], function(module){
	"use strict";
	module.controller("DetailController", DetailController);
	DetailController.$inject = ["$rootScope", "$scope", "dataService", "$routeParams", "$location", "$compile", "$window", "$http", "$timeout"];
	function DetailController($rootScope, $scope, dataService, $routeParams, $location, $compile, $window, $http, $timeout){
		var $ctrl = this;
		
		$ctrl.drilldownTo = drilldownTo;
		$ctrl.toggleOperations = toggleOperations;
		$ctrl.importArg = importArg
		$ctrl.showDialog = false;
		$ctrl.is_rw_admin = is_rw_admin;
		$ctrl.loading = false;

		$ctrl.flot_graph = {};
		$ctrl.high_graph = {};
		$ctrl.drilldownData = {};
		$ctrl.allow_method = {};
		$ctrl.changeTab = changeTab;
		$ctrl.refreshData = refreshData;
		
		$ctrl.drilldownTabs = {
			all: ["parameters", "allow_method"],
			current: "parameters"
		};
		$ctrl.tabTitles = {
			"parameters": $.getInfo("parameters"),
			"allow_method": $.getInfo("allow_method")
		};
		refreshData();
		$rootScope.$on("ml.pathChanged", function(events, params){
			initDetail();
		});
		$ctrl.reloadData = function(action){
			var url_id = $routeParams.leaf;
			var alert_info = $.getInfo("confirm_refresh_url");
			if(action == 0)
			{
				alert_info = $.getInfo("confirm_refresh_dir");
			}else if(action == 1)
			{
				alert_info = $.getInfo("confirm_refresh_url");
			}else if(action == 10)
			{
				alert_info = $.getInfo("confirm_relearn_dir");
			}else if(action == 11)
			{
				alert_info = $.getInfo("confirm_relearn_url");
			}
			if(confirm(alert_info))
			{
				if(typeof($routeParams.path) === 'undefined') 
					dataService.refreshUrl(url_id,action);
				else{
					var path = $routeParams.path;
					dataService.refreshUrl(domain_id,action, path);
				}
				if(action == 10)
				{
					initDetail();
					$ctrl.loading = true;
					$timeout(function(){
						$ctrl.loading = false;
					}, 200);
				}
				else if(action == 11)
				{
					refreshData();
				}
				else
				{
					$window.location.reload();
				}
			}
		};
		function getAllData(){
			$ctrl.summary = dataService.getInfoData();
			$ctrl.flotData = dataService.getFlotData();
			$ctrl.highData = dataService.getHighData();
			$ctrl.paramsData = dataService.getParamsData();
			$ctrl.amData = dataService.getAllowMethodData(true);
		};
		function initDetail(){
			getAllData();
			$ctrl.summary_lines = [{
				label: "access_heat",
				templateUrl: "/ng/ml/treeview/views/ml_summary_accheat.html?q=" + CONFIG_GUI_NO,
			},{
				label: "train_start_time",
				value: $ctrl.summary.train_start_time?$ctrl.summary.train_start_time:" "
			},{
				label: "action",
				templateUrl: "/ng/ml/treeview/views/ml_summary_action.html?q=" + CONFIG_GUI_NO,
			},{
				label: "anomaly",
				value: $ctrl.summary.anomaly? $ctrl.summary.anomaly: "0"
			}];
			$ctrl.flot_graph ={ 
				data: [ { 
					"key": "Alert",
					"data": $ctrl.flotData.type_alert, 
					"label": "Alert",
					"color": "rgb(214, 165, 165)"
				}, {
					"key": "Block", 
					"data": $ctrl.flotData.type_block, 
					"label": "Block", 
					"color": "rgb(157, 208, 179)"
				}],
				options: {
					xaxis: {
						mode: 'time',
						timezone: 'browser',
						timeFormat: "%y-%m-%d %H:%M:%S"
					},
					yaxis: {
						min: 0,
						tickDecimals: 0
					}
				},
				tooltips: true,
				tooltip_formatter: function(label, x, y) {
					var newDate = new Date();
					newDate.setTime(x);
					return label + ': ' + $.datepicker.formatDate("yy-mm-dd ", newDate) + 
						('0'+newDate.getHours().toString()).slice(-2) + ':' + 
						('0'+newDate.getMinutes().toString()).slice(-2) + ':' + 
						('0'+newDate.getSeconds().toString()).slice(-2) + ', ' + y;
				},
			};
			$ctrl.high_graph = {
				chart: {
					type: 'pie'
				},
				title: {
					text: ''
				},
				credits: {
					enabled: false
				},
				tooltip: {
					formatter: function(){
						return "<b>"+$.getInfo(this.key)+": </b>" + "<b>" + ((this.y<1)?'0':this.y) + "</b>";
					}
				},
				plotOptions: {
					pie: {
						dataLabels: {
							enabled: false,
						},
						startAngle: -180,
						endAngle: 180,
						center: ['70%', '40%'],
						showInLegend: true,
					}
				},
				series: [{
					type: 'pie',
					name: '',
					innerSize: '80%',
					data: $ctrl.highData
				}],
				legend: {
					enabled: true,
					itemStyle: {
						color: "#262626",
						width: "100px"
					},
					align: 'right',
					verticalAlign: 'top',
					layout: 'vertical',
					padding: 5,
					margin: 5,
					labelFormatter: function() {
						return $.getInfo(this.name);	
					},
					x: 15,
				},
				colors: ["#eab5b1", "#e9595f"]
			};
			$ctrl.drilldownData = {
				"parameters": {
					qlistSource: $ctrl.paramsData,
					qlistOptions: {
						'prefix': 'ml_param',
						'columns': [
							{'selector': 'arg_name', 'lang_key': $.getInfo("name")},
							{'selector': 'arg_learn_stat', 'lang_key': $.getInfo("learning_stage")},
							{'selector': 'details', 'lang_key': $.getInfo("details")}
						],
						'default_columns':['arg_name', 'arg_learn_stat', 'details'],
						'format_fn': {
							'arg_learn_stat': learning_stage_format_fn,
							'details': details_format_fn
						}
					}
				},
				"allow_method": {
					source: $ctrl.amData
				}
			};
			$ctrl.allow_method = $ctrl.amData;
		}
		function changeTab(tab){
			var previous = $ctrl.drilldownTabs.current;
			$ctrl.drilldownTabs.current = tab;
		}
		function learning_stage_format_fn(td, col, row_data){
			var html;
			var icon = "";
			var text = "";
			var data = row_data[col.selector];
			var arg_ratio = row_data["arg_ratio"];
			var max_arg_ratio = row_data["max_arg_ratio"];
			var cur_time = row_data["cur_time"];
			var max_time = row_data["max_time"];
			var sample_collecting_mode = row_data["sample_collecting_mode"];

			var link;
			var scope;
			switch(data) {
				case 1:
					icon="ftnt-collecting";
					text=$.getInfo("collecting");
					break;
				case 2:
					icon="fa-puzzle-piece";
					text=$.getInfo("building");
					break;
				case 3: 
					icon="ftnt-testing";
					text=$.getInfo("testing");
					break;
				case 4:
					icon="fa-rocket";
					text=$.getInfo("running");
					break;
				case 5: 
					icon="fa-ban";
					text=$.getInfo("discarded");
					break;
				default:
					break;
			}
			var ratio_complete='',time_complete='';
			if(arg_ratio == max_arg_ratio)
			{
				ratio_complete = '<f-icon class="ftnt-yes" style="color:green"></f-icon>';
			}
			if(cur_time == max_time)
			{
				time_complete = '<f-icon class="ftnt-yes" style="color:green"></f-icon>';
			}
			var left_time_text = '';
			var left_time = max_time - cur_time;
			if(left_time > 24*60)
			{
				left_time_text = parseInt( left_time/(24*60) )+" "+$.getInfo("days")+" " + parseInt( (left_time%(24*60))/60) +" "+$.getInfo("hours")+" "+ (left_time%(24*60))%60 +" "+$.getInfo("minutes")+" ";
			}else if(left_time > 60)
			{
				left_time_text = parseInt( left_time/60 ) +" "+$.getInfo("hours")+" "+ (left_time%60) +" "+$.getInfo("minutes")+" ";
			}else
			{
				left_time_text = left_time +" "+$.getInfo("minutes")+" ";
			}		
			if(data == 1 && sample_collecting_mode == 0) {
				link = $compile('<f-icon class="'+icon+'"></f-icon><span>'+text+'</span>'
					+'<span f-tip-target>'+time_complete
					+'<div ml-progress-bar caption="'+(cur_time/max_time*100).toFixed(1)+'" values="['+cur_time/max_time+', '+ (1-cur_time/max_time)+']"></div><div f-tip>'+$.getInfo("left_times")+': '+left_time_text+'</div></span>');
			}else if(data == 1 || data == 3){
				link = $compile('<f-icon class="'+icon+'"></f-icon><span>'+text+'</span>'
					+'<span f-tip-target>'+ratio_complete
					+'<div ml-progress-bar caption="'+(arg_ratio/max_arg_ratio*100).toFixed(1)+'" values="['+arg_ratio/max_arg_ratio+', '+ (1-arg_ratio/max_arg_ratio)+']"></div><div f-tip>'+$.getInfo("left_samples")+':'+parseInt(max_arg_ratio-arg_ratio)+'</div></span>');
			}
			else {
				link = $compile('<f-icon class="'+icon+'"></f-icon><span>'+text+'</span></span>');
			}
			scope = $scope.$new(true);
			html = link(scope);
			//html = '<f-icon class="'+icon+'"></f-icon><span>'+text+'</span>';
			return html;
		}
		function details_format_fn(td, col, row_data){
			var url = "/";
			var arg_id = row_data["id"];
			var html;
			var link;
			var scope;
			var arg_name = row_data["arg_name"].replace(/\//g, "%2F");

			var d_url = '#/detail/'+$routeParams.leaf+'/'+arg_id+'/'+encodeURIComponent(row_data["arg_name"])+'/'+row_data["arg_learn_stat"];
			link = $compile('<a ng-href="#/detail/'+$routeParams.leaf+'/'+arg_id+'/'+encodeURIComponent(arg_name)+'/'+row_data["arg_learn_stat"]+'/'+row_data["arg_ratio"]+'/'+row_data["max_arg_ratio"]+'/'+row_data["cur_time"]+'/'+row_data["max_time"]+'/'+row_data["sample_collecting_mode"]+'/'+row_data["arg_sample_cnt"]+')"><f-icon class="fa-th-list" onclick = "$(\'#side_nav\').hide(); $(\'#nav_resizer\').hide(); window.parent.document.getElementById(\'right_button\').hidden=true;" title="'+$.getInfo("view_hmm_detail")+'"></f-icon></a>');

			//link = $compile('<a ng-href="#/detail/'+$routeParams.leaf+'/'+arg_id+'/'+row_data["arg_name"]+'/'+row_data["arg_learn_stat"]+'"><f-icon class="fa-th-list"></f-icon></a>');

			scope = $scope.$new(true);
			html = link(scope);
			return html;
		}
		function drilldownTo(entry, tab){
			$('#side_nav').hide();
			$('#nav_resizer').hide();
			window.parent.document.getElementById('right_button').hidden=true;
			$location.path("/detail/"+$routeParams.leaf+"/"+entry.id+"/"+encodeURIComponent(entry.arg_name)+"/"+entry.arg_learn_stat+"/"+entry.arg_ratio+"/"+entry.max_arg_ratio+"/"+entry.cur_time+"/"+entry.max_time+"/"+entry.sample_collecting_mode+"/"+entry.arg_sample_cnt);
		}
		function toggleOperations() {
			$('.arg-operations-dropdown').toggle();
		}
		function importArg() {
			var dialog_buttons = [{
				text: $.getInfo("import"),
				click: clickImport
			},{
				text: $.getInfo("cancel"),
				click: clickCancel
			}];
			var dbNameHtml = ['<input type="hidden" name="db_name" value="', db_name, '">'].join("");
			var urlIdHtml = ['<input type="hidden" name="url_id" value="', $routeParams.leaf, '">'].join("");
			var domainIdHtml = ['<input type="hidden" name="domain_id" value="', domain_id, '">'].join("");
			$("#import_form")[0].reset();
			$("#import_hidden_field").empty().append(dbNameHtml)
					.append(urlIdHtml)
					.append(domainIdHtml);
			$("#import_dialog").dialog({
				title: $.getInfo("import_dialog"),
				modal: true,
				width: 600,
				draggable: false,
				autoOpen: false,
				buttons: dialog_buttons
			});
			$("#import_dialog").dialog('open');
			$("#import_dialog").show();
		}
		function clickImport() {
			var options = {
				url: '/waf/ml_policy/import_arg',
				type: 'post',
				dataType: 'json',
				beforeSubmit: function(formData, jqForm, options){
					if(formData[0].value == "") {
						alert($.getInfo("err_import_file"));
						return false;
					}
					else if(formData[1].value == "") {
						alert($.getInfo("err_import_password"))
						return false;
					}
					else{
						return true;
					}
				},
				success: function(responseText, statusText, xhr, $form){
					if(responseText.status == 1)
					{
						refreshData();
					}
					else if(responseText.status == 0)
						error_handler(responseText.msg_id);

					$("#import_dialog").dialog('close');
					$("#import_hidden_field").empty();
					$("#import_dialog").hide();
				},
				error: function(responseText, error){
					alert($.getInfo("err_import"));
					$("#import_dialog").dialog('close');
					$("#import_hidden_field").empty();
					$("#import_dialog").hide();
				}
			};
			$("#import_form").ajaxSubmit(options);
		}
		function clickCancel() {
			$("#import_dialog").dialog('close');
			$("#import_hidden_field").empty();
			$("#import_dialog").hide();
		}
		function error_handler(msg_id){
			switch (msg_id){
				case -30:
					top.location.href = "/login";
					break;
				default:
					alert($.getInfo(msg_id));
					break;
			}
		}
		function refreshData(){
			var url = "/waf/ml_policy/url_statistics";
			var currentPath = $location.path();
			if(currentPath.substring(0, 10) == "/no_record")
				return;
			if(typeof($routeParams.path) === 'undefined' && $routeParams.leaf !== 'undefined'
				&& $routeParams.leaf.indexOf('path') == -1 && $routeParams.leaf != 0){
				$http.get(url+"?mkey="+mkey+"&domain="+domain_name+"&db_name="+db_name+"&url_id="+$routeParams.leaf+"&domain_id="+domain_id+"&hmm_sample_level="+hmm_sample_level, {cache: false})
					.then(function(result){
						dataService.put(result.data);
						initDetail();
					});
			}			
		}
	}
});
