define(["ml_module", "highcharts/highcharts"], function(module){
	"use strict";
	module.controller("LogArgController", LogArgController);
	LogArgController.$inject = ["$scope", "$routeParams", "$location", "dataService", "$http"];
	function LogArgController($scope, $routeParams, $location, dataService, $http) {
		var $ctrl = this;
		$ctrl.learning_stage = convertLearningStage(parseInt($routeParams.learn_stat));
		$ctrl.learning_stage_number = parseInt($routeParams.learn_stat);
		$ctrl.showCharts = ($ctrl.learning_stage_number === 3) || ($ctrl.learning_stage_number === 4);

		$('#side_nav').hide();
		$('#nav_resizer').hide();

		// Use inherite global settings and automatic detection by default
		$ctrl.detectionSetting = 'inherite_settings';
		$ctrl.detection_mode = 0;
		
		$ctrl.abnormalListData = [];
		$ctrl.abnormalListOptions = {
			prefix: 'ml_arg',
			columns: [
				{'selector': 'id', 'lang_key': $.getInfo('id')},
				{'selector': 'values', 'lang_key': $.getInfo('value')},
			//	{'selector': 'type', 'lang_key': $.getInfo('type')},
			],
			default_columns: ['id', 'values'/*, 'type'*/],
			//categories: ['type'],
		};

		$ctrl.applySettings = applySettings;
		$ctrl.goBack = goBack;
		$ctrl.sampleDialog = sampleDialog;
		$ctrl.clickTest = clickTest;

		$(window).resize(drawCharts);
		reloadArg();

		function applySettings() {
			var options = {
				url_id: $routeParams.leaf,
				arg_id: $routeParams.arg_id,
				settings_type: $ctrl.detectionSetting == 'specific_settings' ? 1 : 0
			};

			if (options.settings_type == 1) {
				// validation


					if (isNaN($ctrl.definitely_t) || $ctrl.definitely_t < 0 || $ctrl.definitely_t > 10) {
						alert($.getInfo('err_tolerance_definitely'));
						return;
					}
		

				options.definitely_val = $ctrl.definitely_t;
			}

			dataService.setArg(options).then(function(result) {
				if (result.data && result.data.status === 1) {
					reloadArg();
				} else {
					console.warn('Set arg error: ', result);
				}
			});
		}

		function reloadArg() {
			chartDefaultConfig();
			dataService.getArgData($routeParams.leaf, $routeParams.arg_id).then(function(result) {
				if (result.data && result.data.status === 1) {
					var sd = 3;
					// Settings data
					if (result.data.inherite_settings) {
						$ctrl.inherite_definitely_t = result.data.inherite_settings.definitely;
					}

					if (result.data.specific_settings) {
						$ctrl.detectionSetting = 'specific_settings';
						$ctrl.definitely_t = parseInt(result.data.specific_settings.definitely);
						sd = $ctrl.definitely_t;
					} else {
						$ctrl.detectionSetting = 'inherite_settings';
						$ctrl.definitely_t = 3;
						sd = parseInt(result.data.inherite_settings.definitely);
					}
					if($ctrl.showCharts)
					{
						var d = new Date();
						$ctrl.ml_sd_src='/cgi-bin/ml-sd.py?db_name='+result.data.sql_db_name+'&arg_id='+$routeParams.arg_id+'&domain_id='+result.data.domain_id+'&sd='+sd+'&nocache='+d.getTime();
					}else{
						$ctrl.ml_sd_src='';
					}

					// Scatter data
					angular.forEach(result.data.sample_data, function(item) {
						var dot = [];
						dot.push(item.sample_len);
						dot.push(item.arg_probability);
						if(item.detect_result == 1)	return;
						// current remove pontential anomaly, so only has two series
						var index = 0;
						if(item.detect_result == 2)
							index = 1;
						$ctrl.scatterConfig.series[/*item.detect_result*/index].data.push(dot);
					});

					// Sublist data
					reloadSublist(result.data.sample_data);

					drawCharts();
				} else {
					console.warn('Get arg data error: ', result);
					$(".arg-chart-container").hide();
				}
			});
		}

		function reloadSublist(data) {
			var abnormalValuesData = [],
				sublistId = 1;
			angular.forEach(data, function(item) {
				/*
				if (item.detect_result == 1) {
					abnormalValuesData.push({
						id: sublistId,
						values: item.sample_str,
						type: $.getInfo("potential")
					});
					sublistId += 1;
				}
				*/
			});
			angular.forEach(data, function(item) {
				if (item.detect_result == 2) {
					abnormalValuesData.push({
						id: sublistId,
						values: item.sample_str,
				//		type: $.getInfo("definitely")
					});
					sublistId += 1;
				}
			});

			// If status is Discarded, hide the abnormal values
			if ($ctrl.learning_stage_number === 5) {
				$ctrl.abnormalListData = [];
			} else {
				$ctrl.abnormalListData = abnormalValuesData;
			}
		}

		function resizeChartContainers() {
			var width = document.body.clientWidth - 70;
			var scatterHeight = width / 3;

			$("div.arg-chart-detection").width(width/2);
			$("div.arg-chart-detection").height(scatterHeight);

			$("#img_ml_sd").width(width/2);		
			$("#img_ml_sd").height(scatterHeight);	
			$("#img_ml_sd>img").width(width/2);
			$("#img_ml_sd>img").height(scatterHeight);
		}

		function drawCharts() {
			$(".arg-chart-container").show();
			resizeChartContainers();
			Highcharts.chart($('#detection_chart')[0], $ctrl.scatterConfig);
		}

		function chartDefaultConfig() {
			$ctrl.scatterConfig = {
				chart: {
					type: 'scatter',
					zoomType: 'xy'
				},
				credits: {
					enabled: false
				},
				title: {
					text: null
				},
				xAxis: {
					labels: {
						enabled: false
					},
					title: {
						text: $.getInfo('sample_length'),
						align: 'high'
					}
				},
				yAxis: {
					labels: {
						enabled: false
					},
					title: {
						text: $.getInfo('sample_probability'),
						align: 'high'
					}
				},
				legend: {
					verticalAlign: 'bottom',
					backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF',
					borderWidth: 1
				},
				plotOptions: {
					scatter: {}
				},
				tooltip: {
					formatter: function() {
						return '<b>' + this.series.name + '</b><br>Sample Length: ' + this.x + '<br>Probability: ' + this.y;
					}
				},
				series: [{
					name: $.getInfo("normal"),
					color: 'rgba(119, 152, 191, .5)',
					data: []
				}, 
				/*{
					name: $.getInfo("potential"),
					color: 'rgba(246, 143, 24, .5)',
					data: []
				}, */
				{
					name: $.getInfo("definitely"),
					color: 'rgba(223, 83, 83, .5)',
					data: []
				}]
			};
		}

		function convertLearningStage(stat) {
			var stage = {};
			switch(stat) {
				case 1:
					stage.icon = "ftnt-collecting";
					stage.text = $.getInfo("collecting");
					break;
				case 2:
					stage.icon = "fa-puzzle-piece";
					stage.text = $.getInfo("building");
					break;
				case 3: 
					stage.icon = "ftnt-testing";
					stage.text = $.getInfo("testing");
					break;
				case 4:
					stage.icon = "fa-rocket";
					stage.text = $.getInfo("running");
					break;
				case 5: 
					stage.icon = "fa-ban";
					stage.text = $.getInfo("discarded");
			}
			return stage;
		}

		function factorFloor(factor) {
			return (factor - (factor % 0.1)).toFixed(1);
		}

		function factorCeil(factor) {
			return (factor - (factor % 0.1) + 0.1).toFixed(1);
		}

		function goBack() {
			parent.window.wij_end_modal_dialog();
		}
		
		function sampleDialog() {
			
			var dbIdHtml = ['<input type="hidden" name="db_id" value="', domain_id, '">'].join("");
			var argIdHtml = ['<input type="hidden" name="arg_id" value="', $routeParams.arg_id, '">'].join("");
			var mkeyHtml = ['<input type="hidden" name="mkey" value="', mkey, '">'].join("");
			var ssidHtml = ['<input type="hidden" name="session_id" value="', session_id, '">'].join("");

			$("#test_sample_form")[0].reset();
			$("div #hidden_field").empty()
					.append(dbIdHtml)
					.append(argIdHtml)
					.append(mkeyHtml)
					.append(ssidHtml);
			$("#test_sample_dialog").dialog({
				title: $.getInfo("test_sample_dialog"),
				modal: true,
				width: 530,
				height: 150,
				autoOpen: false,
				close: function(){
					$(this).dialog( "destroy" );
					$("button.dlg-test").off("click", clickTest);
				}
			});
			$("#test_sample_dialog").dialog('open');
			$("#test_sample_dialog").show();
			
			$("#div_probability")[0].style.display = 'none';
			$("#div_detection_result")[0].style.display = 'none';
			$("#div_sample_length")[0].style.display = 'none';

			$("button.dlg-test").on("click", clickTest);
		}

		function clickTest() {
			var form_check = function(){
				if($("input[name='sample_name']")[0].value == "")
				{
					alert($.getInfo("err_empty_sample"));
					return false;
				}
				else
					return true;
			};
			var options = {
				url: '/waf/ml_policy/sample_test',
				type: 'post',
				dataType: 'json',
				beforeSubmit: function(formData, jqForm, options){
					if(!form_check())
						return false;
					else
						return true;
				},
				success: function(responseText, statusText, xhr, $form){
					if(responseText.status == 1)
					{
						//show test result
						$("#test_sample_dialog" ).dialog( "option", "height", 215);
						$("#div_probability")[0].style.display = '';
						$("#div_detection_result")[0].style.display = '';
						$("#div_sample_length")[0].style.display = '';
						$("#probability")[0].innerHTML = Number.parseFloat(responseText.probability).toFixed(2);
						$("#detection_result")[0].innerHTML = $.getInfo(responseText.detection_result);
						$("#sample_length")[0].innerHTML = parseInt(responseText.sample_length);
					}
					else if(responseText.status == 0)
					{
						error_handler(responseText.msg_id);
					}
				},
				error: function(responseText, error){
					alert($.getInfo("err_test_sample"));
				}
			};
			$("#test_sample_form").ajaxSubmit(options);
			
			
		}
	}
});
