define(["ml_module", "highcharts/highcharts"], function(module){
	"use strict";
	module.controller("UrlArgController", UrlArgController);
	UrlArgController.$inject = ["$scope", "$routeParams", "$location", "dataService", "$http", "$compile"];
	function UrlArgController($scope, $routeParams, $location, dataService, $http, $compile) {
		var $ctrl = this;
		$ctrl.is_rw_admin = is_rw_admin || 0;
		$ctrl.name = $routeParams.arg_name;
		$ctrl.learning_stage = convertLearningStage(parseInt($routeParams.learn_stat));
		$ctrl.learning_stage_number = parseInt($routeParams.learn_stat);
		$ctrl.showCharts = ($ctrl.learning_stage_number === 3) || ($ctrl.learning_stage_number === 4);
		$ctrl.fullUrl = '';
		$ctrl.arg_ratio = $routeParams.arg_ratio;
		$ctrl.max_arg_ratio = $routeParams.max_arg_ratio;
		$ctrl.cur_time = $routeParams.cur_time;
		$ctrl.max_time = $routeParams.max_time;
		$ctrl.sample_collecting_mode = $routeParams.sample_collecting_mode;
		$ctrl.arg_ratio_caption = ($routeParams.arg_ratio=="0") ? 0 : (($routeParams.arg_ratio/$routeParams.max_arg_ratio*100).toFixed(1));
		$ctrl.time_caption = ($routeParams.cur_time=="0") ? 0 : (($routeParams.cur_time/$routeParams.max_time*100).toFixed(1));
		$ctrl.arg_sample_cnt = $routeParams.arg_sample_cnt;

		$ctrl.left_time = '';
		var left_time = $ctrl.max_time - $ctrl.cur_time;
		if(left_time > 24*60)
		{
			$ctrl.left_time = parseInt( left_time/(24*60) )+" "+$.getInfo("days")+" " + parseInt( (left_time%(24*60))/60) +" "+$.getInfo("hours")+" "+ (left_time%(24*60))%60 +" "+$.getInfo("minutes")+" ";
		}else if(left_time > 60)
		{
			$ctrl.left_time = parseInt( left_time/60 ) +" "+$.getInfo("hours")+" "+ (left_time%60) +" "+$.getInfo("minutes")+" ";
		}else
		{
			$ctrl.left_time = left_time +" "+$.getInfo("minutes")+" ";
		}
		$ctrl.type = view_type;

		// Use inherite global settings and automatic detection by default
		$ctrl.detectionSetting = 'inherite_settings';
		$ctrl.detection_mode = 0;
		
		$ctrl.abnormalListData = [];
		$ctrl.abnormalListOptions = {
			prefix: 'ml_arg',
			columns: [
				{'selector': 'id', 'lang_key': $.getInfo('id')},
				{'selector': 'values', 'lang_key': $.getInfo('value')},
		//		{'selector': 'type', 'lang_key': $.getInfo('type')},
			],
			default_columns: ['id', 'values', /*'type'*/],
			//categories: ['type'],
		};

		$ctrl.argsEventsData = [];
		$ctrl.argsEventsOptions = {
			prefix: 'ml_arg_event',
			columns: [
				{'selector': 'time', 'lang_key': $.getInfo('time')},
				{'selector': 'detail', 'lang_key': $.getInfo('detail')},
			],
			default_columns: ['time', 'detail'],
		};
		
		$ctrl.sampleSourceTop10Data = [];
		$ctrl.sampleSourceOptions = {
			prefix: 'ml_sample_top10',
			columns: [
				{'selector': 'ip', 'lang_key': $.getInfo('ip_addr')},
				{'selector': 'percent', 'lang_key': $.getInfo('percent')}
			],
			default_columns: ['ip', 'percent'],
			'format_fn': {
				'percent': percent_format_fn,
				'ip': ip_format_fn
			}
		};

		$ctrl.additionalListDatadeleteEntriesFn = [];
		$ctrl.additionalListOptions = {
			prefix: 'ml_arg_additional',
			columns: [
				{'selector': 'id', 'lang_key': $.getInfo('id')},
				{'selector': 'value', 'lang_key': $.getInfo('value')},
				{'selector': 'arg_id', 'lang_key': $.getInfo('arg_id')}
			],
			default_columns: ['id', 'value'],
			'row_attr': [
                                {name: 'id', selector: 'id'},
                                {name: 'arg_id', selector: 'arg_id'},
                        ],
		};

		$ctrl.noisyListData = [];
		$ctrl.noisyListOptions = {
			prefix: 'ml_arg_additional',
			columns: [
				{'selector': 'id', 'lang_key': $.getInfo('id')},
				{'selector': 'value', 'lang_key': $.getInfo('value')},
				{'selector': 'arg_id', 'lang_key': $.getInfo('arg_id')}
			],
			default_columns: ['id', 'value'],
			'row_attr': [
                                {name: 'id', selector: 'id'},
                                {name: 'arg_id', selector: 'arg_id'},
                        ],
		};
				

		$ctrl.menuItemsTemplate = '/ng/ml/treeview/views/menu_items.html';
		$scope.hideEdit = true;
		$scope.hideDelete = (is_rw_admin === 0) ? true:false;


        $scope.deleteEntriesFn = function(entries) {            

            var del_url = "/waf/ml_policy/delmlexcept";
            var domain_id = 0;
            var arg_id = 0;
            var url_id = 0;
            var sample_id = new Array();

            entries.forEach(function(data){
            	domain_id = data.domain_id;
            	arg_id = data.arg_id;
            	url_id = data.url_id;
            	sample_id.push(data.value);
            	$j('#'+data.id).remove();
            });
            
        	var del_data = {domain_id:domain_id, url_id:url_id, arg_id:arg_id, sample_id:sample_id};
        	//$j.post(del_url,del_data,function(data){},"json");	
        	var options = {
				url: del_url,
				type: 'post',
				dataType: 'json',
				data: del_data,
				beforeSubmit: function(formData, jqForm, options){					
						return true;
				},
				success: function(responseText, statusText, xhr, $form){
					reloadArg();
					//window.location.reload();
					//reloadArg();
				},
				error: function(responseText, error){
				}
			};
			$("#report_detail").ajaxSubmit(options);

        	//window.location.reload();            
        };

		$ctrl.drilldownTabs = {
			//all: ["anomaly_samples", "additional_samples",  "sample_source_top10", "historical_learning_events"],
			all: ["anomaly_samples", "noisy_samples", "additional_samples",  "historical_learning_events"],
			current: "anomaly_samples"
		};
		$ctrl.tabTitles = {
			"anomaly_samples": $.getInfo("anomaly_samples"),
			"noisy_samples": $.getInfo("noisy_samples"),
			"additional_samples": $.getInfo("additional_samples"),
			//"sample_source_top10": $.getInfo("sample_source_top10"),
			"historical_learning_events": $.getInfo("historical_learning_events")
		};


		$ctrl.toggleOperations = toggleOperations;
		$ctrl.refreshArg = refreshArg;
		$ctrl.relearnArg = relearnArg;
		$ctrl.discardArg = discardArg;
		$ctrl.applySettings = applySettings;
		$ctrl.goBack = goBack;
		$ctrl.exportArg = exportArg;
		$ctrl.changeTab = changeTab;
		$ctrl.sampleDialog = sampleDialog;
		$ctrl.clickTest = clickTest;

		function debounce(fn, delay){
			var timer = null;
			return function() {
				var context = this;
				var args = arguments;
				clearTimeout(timer);
				timer = setTimeout(function () {
					fn.apply(context, args);
				}, delay);
			};
		}

		$(window).resize(debounce(drawCharts, 200));

		reloadArg();

		function toggleOperations() {
			$('.arg-operations-dropdown').toggle();
		}

		function refreshArg() {
			if (confirm($.getInfo('confirm_refresh_arg'))) {
				dataService.refreshArg($routeParams.leaf, $routeParams.arg_id).then(function(result) {
					if (result.data && result.data.status === 1) {
						$ctrl.goBack();
					} else {
						console.warn('Refresh arg error: ', result);
					}
				});
			}
		}

		function relearnArg() {
			if (confirm($.getInfo('confirm_relearn_arg'))) {
				dataService.relearnArg($routeParams.leaf, $routeParams.arg_id).then(function(result) {
					if (result.data && result.data.status === 1) {
						$ctrl.goBack();
					} else {
						console.warn('Relearn arg error: ', result);
					}
				});
			}
		}
		function discardArg() {
			if (confirm($.getInfo('confirm_discard_arg'))) {
				dataService.discardArg($routeParams.leaf, $routeParams.arg_id).then(function(result) {
					if (result.data && result.data.status === 1) {
						$ctrl.goBack();
					} else {
						console.warn('Discard arg error: ', result);
					}
				});
			}
		}

		function applySettings() {
			var options = {
				url_id: $routeParams.leaf,
				arg_id: $routeParams.arg_id,
				settings_type: $ctrl.detectionSetting == 'specific_settings' ? 1 : 0
			};

			if (options.settings_type == 1) {
				// validation

					if (isNaN($ctrl.definitely_t) || $ctrl.definitely_t < 0 || $ctrl.definitely_t > 10) {
						alert($.getInfo('err_tolerance_definitely'));
						return;
					}
			

				options.definitely_val = $ctrl.definitely_t;
			}

			dataService.setArg(options).then(function(result) {
				if (result.data && result.data.status === 1) {
					reloadArg();
				} else {
					console.warn('Set arg error: ', result);
				}
			});
		}

		function goBack() {
			if($('#side_nav')[0].style.display !== 'none')
			{
				/* for bug 0570148*/
				window.location.reload();
			}else{				
				$('#side_nav').show();
				$('#nav_resizer').show();
				window.parent.document.getElementById('right_button').hidden=false;
				$location.path("/detail/"+$routeParams.leaf);
			}
		}

		function reloadArg() {
			chartDefaultConfig();

			dataService.getArgData($routeParams.leaf, $routeParams.arg_id).then(function(result) {
				if (result.data && result.data.status === 1) {
					// HMM set add by lxj
					if(result.data.args_hmm_data){
						$ctrl.hmm_data = result.data.args_hmm_data;
						$ctrl.learning_stage = convertLearningStage(parseInt($ctrl.hmm_data.arg_learn_stat));
						$ctrl.learning_stage_number = parseInt($ctrl.hmm_data.arg_learn_stat);
						$ctrl.showCharts = ($ctrl.learning_stage_number === 3) || ($ctrl.learning_stage_number === 4);
						$ctrl.arg_sample_cnt = $ctrl.hmm_data.arg_sample_cnt;
						$ctrl.arg_ratio = $ctrl.hmm_data.arg_ratio;
						$ctrl.max_arg_ratio = $ctrl.hmm_data.max_arg_ratio;
						$ctrl.cur_time = $ctrl.hmm_data.cur_time;
						$ctrl.max_time = $ctrl.hmm_data.max_time;
						$ctrl.sample_collecting_mode = $ctrl.hmm_data.sample_collecting_mode;
						$ctrl.arg_ratio_caption = ($ctrl.hmm_data.arg_ratio=="0") ? 0 : (($ctrl.hmm_data.arg_ratio/$ctrl.hmm_data.max_arg_ratio*100).toFixed(1));
						$ctrl.time_caption = ($ctrl.hmm_data.cur_time=="0") ? 0 : (($ctrl.hmm_data.cur_time/$ctrl.hmm_data.max_time*100).toFixed(1));
						// $location.path("/detail/"+$routeParams.leaf+"/"+$routeParams.arg_id+"/"+encodeURIComponent($routeParams.arg_name)+"/"+$ctrl.hmm_data.arg_learn_stat+"/"+$ctrl.hmm_data.arg_ratio+"/"+$ctrl.hmm_data.max_arg_ratio+"/"+$ctrl.hmm_data.cur_time+"/"+$ctrl.hmm_data.max_time+"/"+$ctrl.hmm_data.sample_collecting_mode+"/"+$ctrl.hmm_data.arg_sample_cnt);
					}


					// Full url
					$ctrl.fullUrl = result.data.full_url;

					var sd = 3;
					// Settings data
					if (result.data.inherite_settings) {
						$ctrl.inherite_definitely_t = result.data.inherite_settings.definitely;
					}

					if (result.data.specific_settings) {
						$ctrl.detectionSetting = 'specific_settings';
						$ctrl.definitely_t = parseInt(result.data.specific_settings.definitely);
						sd = $ctrl.definitely_t;
					} else {
						$ctrl.detectionSetting = 'inherite_settings';
						$ctrl.definitely_t = 3;
						sd = parseInt(result.data.inherite_settings.definitely);
					}

					// Boxplot data
					$ctrl.boxConfig.data = result.data.boxplot_data;
					angular.forEach($ctrl.boxConfig.data, function(box) {
						if (box.values && box.values.is_sample)
						{
							if(box.values.is_sample === 1)	box.name = 'sample1_' + box.name;
							if(box.values.is_sample === 2)	box.name = 'sample2_' + box.name;
						}
					});
					if($ctrl.showCharts)
					{
						var d = new Date();
						$ctrl.ml_sd_src='/cgi-bin/ml-sd.py?db_name='+result.data.sql_db_name+'&arg_id='+$routeParams.arg_id+'&domain_id='+result.data.domain_id+'&sd='+sd+'&nocache='+d.getTime();
					}else{
						$ctrl.ml_sd_src='';
					}
					
					// Scatter data
					angular.forEach(result.data.sample_data, function(item) {
						var dot = [];
						dot.push(item.sample_len);
						dot.push(item.arg_probability);
						if(item.detect_result == 1)	return;
						// modified by lk
						// current remove pontential anomaly, so only has two series
						var index = 0;
						if(item.detect_result == 2)
							index = 1;
						$ctrl.scatterConfig.series[/*item.detect_result*/index].data.push(dot);
					});

					// Anomaly Samples data
					reloadSublist(result.data.sample_data);

					// Historical Learning Events data
					readHistoricalLearningEvents(result.data.args_event_data);

					
					readHistoricalLearningNoisy(result.data.noisy_data);

					if(parseInt($routeParams.learn_stat) == 5){
						//$ctrl.sampleSourceTop10Data = [];
						$ctrl.additionalListData = [];
					}
					else{
						//$ctrl.sampleSourceTop10Data = result.data.access_ip_data;
						// additional samples data
						readHistoricalLearningAdditional(result.data.args_additional_data);
					}

					drawCharts();
				} else {
					console.warn('Get arg data error: ', result);
					$(".arg-chart-container").hide();
				}
			});
		}

		function reloadSublist(data) {
			var abnormalValuesData = [],
				sublistId = 1;
			angular.forEach(data, function(item) {
				/*
				if (item.detect_result == 1) {
					abnormalValuesData.push({
						id: sublistId,
						values: item.sample_str,
						type: $.getInfo("potential")
					});
					sublistId += 1;
				}
				*/
			});
			angular.forEach(data, function(item) {
				if (item.detect_result == 2) {
					abnormalValuesData.push({
						id: sublistId,
						values: item.sample_str,
				//		type: $.getInfo("definitely")
					});
					sublistId += 1;
				}
			});

			// If status is Discarded, hide the abnormal values
			if ($ctrl.learning_stage_number === 5) {
				$ctrl.abnormalListData = [];
			} else {
				$ctrl.abnormalListData = abnormalValuesData;
			}
		}

		function readHistoricalLearningEvents(data) {
			var detail;
			$ctrl.argsEventsData = [];
			angular.forEach(data, function(item) {
				detail = [
					'Parameter changed from ',
					getLearningStageName(item.from_state),
					' to ',
					getLearningStageName(item.to_state),
					' by ',
					item.action_source,
					'. ',
					item.reason,
					'.'
				].join('');
				$ctrl.argsEventsData.push({
					time: item.time_stamp,
					detail: detail
				});
			});
		}
		function readHistoricalLearningAdditional(data) {
			$ctrl.additionalListData = [];
			angular.forEach(data, function(item) {
				$ctrl.additionalListData.push({
					id: item.id,
					value: item.value,
					arg_id: item.arg_id,
					url_id: item.url_id,
					domain_id: item.domain_id
				});
			});
		}

		function readHistoricalLearningNoisy(data) {
			$ctrl.noisyListData = [];
			angular.forEach(data, function(item) {
				$ctrl.noisyListData.push({
					id: item.id,
					value: item.value,
					arg_id: item.arg_id,
					url_id: item.url_id,
					domain_id: item.domain_id
				});
			});
		}
		function resizeChartContainers() {
			var width  = view_type == 0 ? (document.body.clientWidth - 70) : (document.body.clientWidth - $("nav#side_nav").width() - 70);
			var boxHeight = width / 5,
				scatterHeight = width / 4;

			$("div.arg-chart-detection").width(width/2);
			$("div.arg-chart-detection").height(scatterHeight);

			$("#img_ml_sd").width(width/2);		
			$("#img_ml_sd").height(scatterHeight);	
			$("#img_ml_sd>img").width(width/2);
			$("#img_ml_sd>img").height(scatterHeight);

			$("div.arg-chart-box").width(width);
			$("div.arg-chart-box").height(boxHeight);

			$ctrl.boxConfig.chartSize = {
				width: width,
				height: boxHeight
			};

			$ctrl.boxConfig.leftNavWidth = view_type == 0 ? 0 : $("nav#side_nav").width();
		}

		function drawCharts() {
			if($('#detection_chart')[0] == undefined)
				return;
			$(".arg-chart-container").show();
			resizeChartContainers();
			Highcharts.chart($('#detection_chart')[0], $ctrl.scatterConfig);

			//if ($ctrl.boxChart) {
				$('#boxplot').empty();
			//}
			if ($ctrl.boxConfig.data) {
				$ctrl.boxChart = makeDistroChart($ctrl.boxConfig);
				$ctrl.boxChart.renderNotchBoxes({
					colors: function(name) {
						if (name.indexOf('sample1_') == 0)
							return '#ceb7b2';
						if (name.indexOf('sample2_') == 0)
							return '#e9595f';
						return '#1f77b4';
					}
				});
				$ctrl.boxChart.renderBoxPlot({
					colors: function(name) {
						return '#000000';
					}
				});
			} else {
				console.warn('Draw chart error: No box plot data.');
				$(".arg-chart-container").hide();
			}
		}

		function chartDefaultConfig() {
			$ctrl.scatterConfig = {
				chart: {
					type: 'scatter',
					zoomType: 'xy'
				},
				credits: {
					enabled: false
				},
				title: {
					text: null
				},
				xAxis: {
					labels: {
						enabled: false
					},
					title: {
						text: $.getInfo('sample_length'),
						align: 'high'
					}
				},
				yAxis: {
					labels: {
						enabled: false
					},
					title: {
						text: $.getInfo('sample_probability'),
						align: 'high'
					}
				},
				legend: {
					verticalAlign: 'bottom',
					backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF',
					borderWidth: 1
				},
				plotOptions: {
					scatter: {}
				},
				tooltip: {
					formatter: function() {
						return '<b>' + this.series.name + '</b><br>Sample Length: ' + this.x + '<br>Probability: ' + this.y;
					}
				},
				series: [{
					name: $.getInfo("normal"),
					color: 'rgba(119, 152, 191, .5)',
					data: []
				},
				/*
				{
					name: $.getInfo("potential"),
					color: 'rgba(246, 143, 24, .5)',
					data: []
				},
				*/
				{
					name: $.getInfo("anomaly"),
					color: 'rgba(223, 83, 83, .5)',
					data: []
				}]
			};

			$ctrl.boxConfig = {
				xName: 'name',
				yName: 'values',
				yTicks: 0.5,
				axisLabels: {xAxis: ' ', yAxis: ' '},
				chartSize: {width: 400, height: 80},
				margin: {top: 15, right: 0, bottom: 5, left: 45},
				selector: '#boxplot',
				constrainExtremes: true
			};
		}

		function convertLearningStage(stat) {
			var stage = {};
			switch(stat) {
				case 1:
					stage.icon = "ftnt-collecting";
					stage.text = $.getInfo("collecting");
					break;
				case 2:
					stage.icon = "fa-puzzle-piece";
					stage.text = $.getInfo("building");
					break;
				case 3: 
					stage.icon = "ftnt-testing";
					stage.text = $.getInfo("testing");
					break;
				case 4:
					stage.icon = "fa-rocket";
					stage.text = $.getInfo("running");
					break;
				case 5: 
					stage.icon = "fa-ban";
					stage.text = $.getInfo("discarded");
			}
			return stage;
		}

		function getLearningStageName(stat) {
			switch(stat) {
				case 0:
					return 'None';
				case 1:
					return 'Collecting';
				case 2:
					return 'Building';
				case 3: 
					return 'Testing';
				case 4:
					return 'Running';
				case 5: 
					return 'Discarded';
			}
			return 'Unknown';
		}

		function factorFloor(factor) {
			return (factor - (factor % 0.1)).toFixed(1);
		}

		function factorCeil(factor) {
			return (factor - (factor % 0.1) + 0.1).toFixed(1);
		}

		function exportArg() {
			var dialog_buttons = [{
				text: $.getInfo("export"),
				click: clickExport
			},{
				text: $.getInfo("cancel"),
				click: clickCancel
			}];
			var dbNameHtml = ['<input type="hidden" name="db_name" value="', db_name, '">'].join("");
			var argIdHtml = ['<input type="hidden" name="arg_id" value="', $routeParams.arg_id, '">'].join("");
			var mkeyHtml = ['<input type="hidden" name="mkey" value="', mkey, '">'].join("");
			var ssidHtml = ['<input type="hidden" name="session_id" value="', session_id, '">'].join("");

			$("#export_form")[0].reset();
			$("#export_form").append(dbNameHtml)
					.append(argIdHtml)
					.append(mkeyHtml)
					.append(ssidHtml);
			$("#export_dialog").dialog({
				title: $.getInfo("export_dialog"),
				modal: true,
				width: 600,
				draggable: false,
				autoOpen: false,
				buttons: dialog_buttons
			});
			$("#export_dialog").dialog('open');
			$("#export_dialog").show();
			$('.arg-operations-dropdown').hide();
		}
		function clickExport() {
			var form_check = function(){
				if($("input[name='passwd']")[0].value == "")
				{
					alert($.getInfo("err_empty_password"));
					return false;
				}
				else if($("input[name='passwd']")[0].value !== $("input[name='confirm_passwd']")[0].value) {
					alert($.getInfo("err_export_password"));
					return false;
				}
				else
					return true;
			};
			var options = {
				url: '/waf/ml_policy/export_arg',
				type: 'post',
				dataType: 'json',
				beforeSubmit: function(formData, jqForm, options){
					if(!form_check())
						return false;
					else
						return true;
				},
				success: function(responseText, statusText, xhr, $form){
					if(responseText.status == 1)
					{
						var file = responseText.name;
						document.location.href = "/waf/ml_policy/export_download?msg=60&session_id=" + 
							session_id + "&name=" + file;
					}
					else if(responseText.status == 0)
					{
						error_handler(responseText.msg_id);
					}
					$("#export_dialog").dialog('close');
					$("#export_dialog").hide();
				},
				error: function(responseText, error){
					alert($.getInfo("err_export"));
					$("#export_dialog").dialog('close');
					$("#export_dialog").hide();
				}
			};
			$("#export_form").ajaxSubmit(options);
		}
		function clickCancel() {
			$("#export_dialog").dialog('close');
			$("#export_dialog").hide();
		}
		
		function sampleDialog() {
			
			var dbIdHtml = ['<input type="hidden" name="db_id" value="', domain_id, '">'].join("");
			var argIdHtml = ['<input type="hidden" name="arg_id" value="', $routeParams.arg_id, '">'].join("");
			var mkeyHtml = ['<input type="hidden" name="mkey" value="', mkey, '">'].join("");
			var ssidHtml = ['<input type="hidden" name="session_id" value="', session_id, '">'].join("");

			$("#test_sample_form")[0].reset();
			$("div #hidden_field").empty()
					.append(dbIdHtml)
					.append(argIdHtml)
					.append(mkeyHtml)
					.append(ssidHtml);
			$("#test_sample_dialog").dialog({
				title: $.getInfo("test_sample_dialog"),
				modal: true,
				width: 530,
				height: 150,
				autoOpen: false,
				close: function(){
					$(this).dialog( "destroy" );
					$("button.dlg-test").off("click", clickTest);
				}
			});
			$("#test_sample_dialog").dialog('open');
			$("#test_sample_dialog").show();
			
			$("#div_probability")[0].style.display = 'none';
			$("#div_detection_result")[0].style.display = 'none';
			$("#div_sample_length")[0].style.display = 'none';

			$("button.dlg-test").on("click", clickTest);
		}

		function clickTest() {
			var form_check = function(){
				if($("input[name='sample_name']")[0].value == "")
				{
					alert($.getInfo("err_empty_sample"));
					return false;
				}
				else
					return true;
			};
			var options = {
				url: '/waf/ml_policy/sample_test',
				type: 'post',
				dataType: 'json',
				beforeSubmit: function(formData, jqForm, options){
					if(!form_check())
						return false;
					else
						return true;
				},
				success: function(responseText, statusText, xhr, $form){
					if(responseText.status == 1)
					{
						//show test result
						$("#test_sample_dialog" ).dialog( "option", "height", 215);
						$("#div_probability")[0].style.display = '';
						$("#div_detection_result")[0].style.display = '';
						$("#div_sample_length")[0].style.display = '';
						$("#probability")[0].innerHTML = Number.parseFloat(responseText.probability).toFixed(2);
						$("#detection_result")[0].innerHTML = $.getInfo(responseText.detection_result);
						$("#sample_length")[0].innerHTML = parseInt(responseText.sample_length);
					}
					else if(responseText.status == 0)
					{
						error_handler(responseText.msg_id);
					}
				},
				error: function(responseText, error){
					alert($.getInfo("err_test_sample"));
				}
			};
			$("#test_sample_form").ajaxSubmit(options);
			
			
		}
		function error_handler(msg_id){
			switch (msg_id){
				case -30:
					top.location.href = "/login";
					break;
				default:
					alert($.getInfo(msg_id));
					break;
			}
		}

		function changeTab(tab){
			var previous = $ctrl.drilldownTabs.current;
			$ctrl.drilldownTabs.current = tab;
		}

		function percent_format_fn(td, col, row_data) {
			var data = row_data[col.selector];
			var link;
			var scope;
			var html = "";
			link = $compile('<div ml-progress-bar caption="'+(data*100).toFixed(2)+'" values="['+data+', '+ (1-data)+']"></div>');
			scope = $scope.$new(true);
			html = link(scope);
			return html;
		}
		function ip_format_fn(td, col, row_data) {
			var data = row_data[col.selector];
			return (data === "") ? $j.getInfo("manual"): data;
		}
	}
});
