define(['ml_module'], function(module){
	"use strict";
	module.controller("ArgsViewerSearch", ArgsViewerSearch);
	ArgsViewerSearch.$inject = ["$rootScope", "$scope", "dataService", "$routeParams", "$location", "$compile", "$window", "$http", "Facets", "facetedSearchUtil"];
	function ArgsViewerSearch($rootScope, $scope, dataService, $routeParams, $location, $compile, $window, $http, Facets, facetedSearchUtil){
		var $ctrl = this;
		
		var ARGS_URL = "/waf/ml_policy/args/para_json";
		var PERSIST_KEY = 'ArgsViewerSearch',
			qlistConfig = null;
		var facets = new Facets();
		var filterColumns = [
			{label: "Argument Name", type: "string", key: "label"},
			{label: "Learning Status", type: "enum", key: "arg_learn_stat", values: [[1, "Collecting"], [2, "Building"], [3, "Testing"], [4, "Running"], [5, "Discarded"]]}
		];
		var extraFacets = facets.genericFacets(filterColumns);
		facets.addFacets(extraFacets);

		$ctrl.facetedSearch = {};
		facetedSearchUtil.facets = facets.byId();
		$ctrl.facetedSearch.facets = facets;
		$ctrl.facetedSearch.options = {
			entries: function(){ return dataService.genArgsEntries([]); },
			source: 'history',
			complex: true,
			filterMerge: {max: 1}
		};
		$ctrl.facetedSearch.model = {};

		$scope.refresh = function() {
			$window.location.reload();
		};


		$scope.$watch('$ctrl.facetedSearch.model', function(value, oldValue) {
			//columns may not be loaded yet
			if (value === undefined) {
				return;
			}
			if (oldValue && oldValue !== value) {
				reloadPage();
			}
		}, true);
		
		function reloadPage(){
			var searchModel = angular.copy($ctrl.facetedSearch.model);
			var filter = $ctrl.facetedSearch.facets.makeQlistFilters(searchModel, false, false);
			var params = {
				mkey: mkey,
				filter: JSON.stringify(filter),
				domain: domain_name, 
				domain_id: domain_id, 
				db_name: db_name,
				hmm_sample_level: hmm_sample_level
			};

			return $http.get(ARGS_URL, {params: params}).then(function(result){
				var filterResult = [];
				if(result.data.status == 2)
					filterResult = result.data.treeData;
				$scope.$emit("ML.FilterArgs", filterResult);
			}, function(){
			});
		}

	}
});
