define(['ml_module'], function(module){
	"use strict";
	module.directive("fMlChart", fMlChart);
	function fMlChart(){
		return {
			restrict: 'A',
			scope: {
				params: "=fMlChart"
			},
			link: function(scope, elem){
				var chart = new Chart({element: elem});
				scope.$watchGroup(["params", "params.data"], function(scopeParams){
                                	scopeParams[0] ? chart.update(scopeParams[0], !0) : chart.update({data: null})
				}), scope.$watch(function(){
					return {width: elem.width(), height: elem.height()}
				}, function(dimensions) {
					dimensions.height && dimensions.width && chart.debounced_check_redraw()
				}, !0), chart.redraw_on_window_resize(!0), scope.$on("$destroy", function() {
					chart.redraw_on_window_resize(!1)
				}), $(window).on("resize", function(){chart.redraw_on_window_resize(!0)})
			}
		};
	}
});
