define(['ml_module'], function(module){
	"use strict";
	module.directive("fMlDlg", fMlDlg);
	function fMlDlg(){
		return {
			restrict: 'E',
			replace: true,
			scope: {
				source: '=',
			},
			templateUrl: "/ng/ml/treeview/views/ml_allow_method.html?q=" + CONFIG_GUI_NO,
			link: function(scope, elem, attr, ctrl){
			},
			controller: 'AllowMethodController',
			controllerAs: '$ctrl'
		};
	}
	module.controller('AllowMethodController', AllowMethodController);
	AllowMethodController.$inject = ["$rootScope", "$scope", "$http", "$routeParams", "dataService"];
	function AllowMethodController($rootScope, $scope, $http, $routeParams, dataService)
	{
		var $ctrl = this;
		$ctrl.is_rw_admin = is_rw_admin;
		$ctrl.refreshMethod = function(ths) {
			if(confirm($.getInfo("confirm_refresh_method"))){
				dataService.refreshMethod($routeParams.leaf).then(function(result) {
					if (result.data && result.data.status === 1) {
						$http.get("/waf/ml_policy/url_statistics"+"?mkey="+mkey+"&domain="+domain_name+"&db_name="+db_name+"&url_id="+$routeParams.leaf+"&domain_id="+domain_id+"&hmm_sample_level="+hmm_sample_level, {cache: false})
							.then(function(result){
								dataService.put(result.data);
								$rootScope.$broadcast("ml.pathChanged");
							});
					} else {
						console.warn('Refresh method error: ', result);
					}
				});
			}
		};
		$ctrl.allow_method_status = allow_method_status;
		$ctrl.setCusAllowMethod = function(ths){
			$http.get("/waf/ml_policy/url_statistics?domain="+domain_name+"&db_name="+db_name+"&url_id="+$routeParams.leaf+"&domain_id="+domain_id+"&hmm_sample_level="+hmm_sample_level)
				.then(function(result){
					//result.data.methods = '[{"GET":2}, {"POST":3}, {"TRACE":6}]';
					if(result.data.details.allow_method !== undefined)
					{
						//dataService.putAllowMethodData(result.data.details.allow_method.am_settings_value);
						result.data.details.allow_method.am_mode = 2;
						$scope.source = result.data.details.allow_method;
					}
					else{
						alert($.getInfo("error_msg_get_am"));
					}
				});
		};
		$ctrl.getUrlAllowMethod = function(ths){
			$http.get("/waf/ml_policy/get_url_allow_method?db_name="+db_name+"&url_id="+$routeParams.leaf)
				.then(function(result){
					//result.data.methods = '[{"GET":2}, {"POST":3}, {"TRACE":6}]';
					if(result.data.methods !== undefined)
					{
						dataService.putAllowMethodData(result.data.methods);
						$scope.source = dataService.getAllowMethodData(false);
					}
					else{
						alert($.getInfo("error_msg_get_am"));
					}
				});
		};
		$ctrl.submitAllowMethod = function(){
			if(emptyCheck()){
				alert($.getInfo("error_msg_empty"));
				return;
			}
			$http({
				method: 'POST',
				url: '/waf/ml_policy/set_url_allow_method',
				params: {
					session_id: session_id,
					pol_am_adjust: $scope.source.am_mode,
					url_id: $routeParams.leaf,
					domain_id: domain_id,
					methods: generateMethodsString()
				}
			}).then(function(result){
				if(result.data.status == 1)
				{
					alert($.getInfo("set_am_success"));
				}
				else
				{
					alert($.getInfo("error_msg_set_am"));
				}
			});
			function generateMethodsString(){
				var methods = dataService.getAllowMethodData(true);
				var settings_value = $scope.source.am_settings_value;
				var sendData = {methods: []};
				for(var key in settings_value)
				{
					if(settings_value[key] == true)
					{
						var tmp = {};
						tmp[key] = methods.am_settings[key];
						sendData.methods.push(tmp);
					}
				}
				return JSON.stringify(sendData);
				
			};
			function emptyCheck(){
				var values = $scope.source.am_settings_value;
				var mode = $scope.source.am_mode;
				var empty = true;
				if(mode == 2)
				{
					for(var key in values)
					{
						if(values[key] == true){
							empty = false;
							break;
						}
					}
				}
				else
					empty = false;
				return empty; 
			}
		};
	}
});
