define(['ml_module', 'highcharts/highcharts'], function(module){
	"use strict";
	module.directive("fMlHighchart", fMlHighcharts);
	function fMlHighcharts(){
		return {
			restrict: 'A',
			scope: {
				params: '=fMlHighchart'
			},
			link: function(scope, elem){
				var chart;
				if(scope.params)
					chart = Highcharts.chart(elem[0], scope.params);

				scope.$watch('params', function(params) {
					if(params)
						chart = Highcharts.chart(elem[0], params);
				});

				scope.$watch(function() {
					return {
						width: elem.width(),
						height: elem.height()
					};
				}, function(dimensions) {
					if (chart && dimensions.height && dimensions.width) {
						chart.setSize(dimensions.width, dimensions.height);
					}
				}, true);
			}
		}
	}
});
