define(['ml_module', 'fweb.util/dom'], function(module, fweb_dom) {
	'use strict';
	var progressBar = function() {
		return {
			restrict: 'A',
			replace: true,
			templateUrl: "/ng/ml/treeview/views/ml_progress_bar.html?q=" + CONFIG_GUI_NO,
			scope: {
				values: '=',
				caption: '=',
				colors: '='
			},
			link: function(scope, element) {
				element.addClass('progress-bar-container');
				scope.$watchGroup(['values', 'colors'], function(watched) {
					var summed;
					var values = watched[0];
					var colors = watched[1];

					if (!Array.isArray(values)) {
						values = [values];
					}
					colors = colors || (values.length > 1 ? ['#63a58a', '#e0e0e0'] : ['#63a58a']);

					scope.calculated = values.map(function(value, index) {
						var width;
						if (index < values.length - 1) {
							width = (value * 100).toFixed(2) + '%';
						}
						return {
							color: colors[index],
							width: width
						};
					});
					$(window).trigger("resize");
				});
			}
		};
	};
	module.directive("mlProgressBar", progressBar);
});
