define(['ml_module'], function(module){
	"use strict";
	var URL = {
		TREE_ROOT: "/waf/ml_policy/tree/root_json",
		TREE_SUB: "/waf/ml_policy/tree/sub_json",
		STATISTICS: "/waf/ml_policy/url_statistics",
		TREE_ARGS_ROOT: "/waf/ml_policy/args/para_json",
		ARG_STATISTICS: "/waf/ml_policy/treeview_arg_json",
		TREE_ALL: "/waf/ml_policy/tree_all_json"
	};

	module.directive("fiMlNav", fiMlNav);
	fiMlNav.$inject = ["$http"];
	function fiMlNav($http){
		return {
			restrict: 'E',
			replace: true,
			scope: {
				config: '='
			},
			templateUrl: "/ng/ml/treeview/views/ml_nav.html?q=" + CONFIG_GUI_NO,
			link: function(scope, elem, attr, ctrl){
			},
			controller: MlNavController,
			controllerAs: '$ctrl'
		};
	}
	
	MlNavController.$inject = ["$rootScope", "$scope", "$http", "$location", "$window", "dataService"];
	function MlNavController($rootScope, $scope, $http, $location, $window, dataService){
		var $ctrl = this;
		$ctrl.onToggle = onToggle;
		$ctrl.onClick = onClick;
		$ctrl.onClickArg = onClickArg;
		$ctrl.domain = domain_name;
		$ctrl.isTreeView = false;
		$ctrl.urlsWithParam = false;
		$scope.$watch("$ctrl.treeNodes", function(newval, oldval){
			$ctrl.treeNodes = newval;
		});
		//$scope.$watch("$ctrl.urlsWithParam", function(newval, oldval){
		//	$scope.$broadcast('angular-ui-tree:collapse-all');
		//	getRootData();
		//});
		$rootScope.$on("ML.FilterArgs", function(event, data){
			$ctrl.treeNodes = data;
			angular.forEach($ctrl.treeNodes, function(obj){
				angular.extend(obj, {icon: "fa-pencil-square-o"});
				return obj;
			});
			onClickArg($ctrl.treeNodes[0]);
		});
		getRootData();
		function getRootData(){
			var data = [];
			var tree_url  = view_type == 0?URL.TREE_ALL:URL.TREE_ARGS_ROOT;
			var args_param = (view_type == 0)?"":("&hmm_sample_level="+hmm_sample_level); // used for arguments view
			var url = tree_url+"?mkey="+mkey+"&domain="+domain_name+"&domain_id="+domain_id+"&db_name="+db_name+args_param;
			$ctrl.isTreeView = (view_type == 0); // tree view, show checkbox
			if ($ctrl.urlsWithParam) {
				url = URL.TREE_ALL+"?domain="+domain_name+"&domain_id="+domain_id+"&db_name="+db_name+args_param;
			}
			$http.get(url).then(function success(result){
				var data = result.data;
				//if ($ctrl.urlsWithParam && data.status == 1) {
				if(data.status == 1) {
					var root_id = undefined;
					var root_is_leaf = false;
					$ctrl.treeNodes = data.treeData;
					// re-construct tree data
					angular.forEach(data.treeData, preProcessTreeNodes);

					if ($ctrl.treeNodes && $ctrl.treeNodes.length > 0) {
						var root_id = $ctrl.treeNodes[0].url_id || 0;
						var locationUrl = $location.url() || '';
						if ($ctrl.treeNodes[0].isLink && ($location.path().indexOf("/log") < 0))
							$location.path("/detail/" + root_id);
						else if(locationUrl.indexOf('/log') < 0)
							$location.path("/no_record/" + root_id);
					}else
						$location.path("/no_record/" + root_id);
				/*} else if(data.status == 1) {
					var root_id = undefined;
					var root_is_leaf = false;
					angular.forEach(data.treeData, function(obj){
						root_id = obj.id;
						root_is_leaf = obj.isLink;
						angular.extend(obj, {icon: "fa-server"});
						return obj;
					});
					$ctrl.treeNodes = data.treeData;
					var locationUrl = $location.url() || '';
					if (locationUrl.length < 1 || locationUrl.indexOf('/log') < 0) {
						if(root_is_leaf)
							$location.path("/detail/"+root_id);
						else
							$location.path("/no_record/"+root_id);
					}
					if(data.treeData.length>0)
					{
						if(data.treeData[0].isLink)
							onClick(data.treeData[0], null);
					}
					*/
				} else if(data.status == 2) {
					var root_id;
					var url_id;
					var arg_name;
					var encode_label;
					var arg_stat;
					var arg_ratio;
					var max_arg_ratio;
					var cur_time;
					var max_time;
					var sample_collecting_mode;
					var arg_sample_cnt;
					data.treeData.sort(function(a,b) {return (a["label"].localeCompare(b["label"]))});
					angular.forEach(data.treeData, function(obj){
						root_id = obj.id;
						url_id = obj.url_id;
						arg_name = obj.label;
						encode_label = obj.encode_label
						arg_stat = obj.arg_learn_stat;
						arg_ratio = obj.arg_ratio;
						max_arg_ratio = obj.max_arg_ratio;
						cur_time = obj.cur_time;
						max_time = obj.max_time;
						sample_collecting_mode = obj.sample_collecting_mode;
						arg_sample_cnt = obj.arg_sample_cnt;
						angular.extend(obj, {icon: "fa-pencil-square-o"});
						return obj;
					});
					$ctrl.treeNodes = data.treeData;
					dataService.genArgsEntries(data.treeData);

					if (data.treeData.length < 1) {
						$location.path("/no_record/"+root_id);
					} else {
						$location.path("/detail/"+url_id+"/"+root_id+"/"+encode_label+"/"+arg_stat+"/"+arg_ratio+"/"+max_arg_ratio+"/"+cur_time+"/"+max_time+"/"+sample_collecting_mode+"/"+arg_sample_cnt);
					}
				} else {
					error_handler(result.data.msg_id);
				}
			}, function(error){
			});
		}
		function getChildData(node){
			var preTreeNodes = $ctrl.treeNodes;
			var url = URL.TREE_SUB+"?domain="+domain_name+"&db_name="+db_name+"&parentId="+node.id;
			$http.get(url).then(function success(result){
				var data = result.data;
				if(data.status == 1)
				{
					angular.forEach(data.treeData, function(obj){
						if(!obj.hasChild)
						{
							var types = ["pdf", "asp", "jsp", "php", "html"];
							var tmp = obj.label.split('.');
							var icon = "ftnt-text";
							if((tmp.length > 0) && types.indexOf(tmp[1]) >= 0)
							{
								icon = "ftnt-"+tmp[1];
							}
							angular.extend(obj, {icon: icon});
						}
						else
						{
							angular.extend(obj, {icon: "ftnt-folder-twotabs"});
						}
						return obj;
					});
					$ctrl.treeNodes = recurveTreeNodes(preTreeNodes, node.id, data.treeData);
				}
				else
				{
					error_handler(result.data.msg_id);
				}
			}, function error(){
			});
		}
		function recurveTreeNodes(node, parentId, childNodes){
			for(var key in node)
			{
				if(typeof node[key] == "object")
					recurveTreeNodes(node[key], parentId, childNodes);
				if(node[key] == parentId)
				{
					angular.extend(node, {nodes: childNodes});
					break;
				}
			}
			return node;
		}
		function onToggle(node, ths){
			if(!node.nodes || node.nodes.length == 0)
			{
				expand(node, ths);
			}
			ths.toggle();
		}
		function expand(node, ths){
			getChildData(node);
		}
		function onClick(node, ths){
			$http.get(URL.STATISTICS+"?mkey="+mkey+"&domain="+domain_name+"&db_name="+db_name+"&url_id="+node.url_id+"&domain_id="+domain_id+"&hmm_sample_level="+hmm_sample_level, {cache: false})
				.then(function(result){
					dataService.put(result.data);
					$rootScope.$broadcast("ml.pathChanged");
				});
		}
		function onClickArg(node){
			if(!node || node == undefined)
				return;
			$location.path("/detail/"+node.url_id+"/"+node.id+"/"+node.encode_label+"/"+node.arg_learn_stat+"/"+node.arg_ratio+"/"+node.max_arg_ratio+"/"+node.cur_time+"/"+node.max_time+"/"+node.sample_collecting_mode+"/"+node.arg_sample_cnt);
		}
		function error_handler(msg_id)
		{
			switch (msg_id){
				case -30:
					top.location.href = "/login";
					break;
				case -37:
					document.location.href = "/noaccess?redir=/waf/ml_policy/dlg?mkey="+mkey;
					break;
				default :
					document.location.href = "/error?msg=" + msg_id;
					break;
			}
		}

		function preProcessTreeNodes(node) {
			if (node.isRoot) {
				angular.extend(node, {icon: "fa-server"});
			} else if (!node.hasChild) {
				var types = ["pdf", "asp", "jsp", "php", "html"];
				var tmp = node.label.split('.');
				var icon = "ftnt-text";
				if ((tmp.length > 0) && types.indexOf(tmp[1]) >= 0)
				{
					icon = "ftnt-"+tmp[1];
				}
				angular.extend(node, {icon: icon});
			} else {
				angular.extend(node, {icon: "ftnt-folder-twotabs"});
			}
			if (node.nodes && node.nodes.length > 0) {
				node.nodes.sort(function(a,b) {return (a["label"].localeCompare(b["label"]))});
				angular.forEach(node.nodes, preProcessTreeNodes);
			}
		}
	}

});
