define(['ml_module'], function(module){
	"use strict";
	module.directive("fMlResizer", fMlResizer);
	fMlResizer.$inject = ["$document"];
	function fMlResizer($document){
		return function($scope, $element, $attrs) {
			$element.on('mousedown', function(event) {
				event.preventDefault();

				$document.on('mousemove', mousemove);
				$document.on('mouseup', mouseup);
			});
			function mousemove(event) {
				if ($attrs.fMlResizer == 'vertical') {
					var x = event.pageX;
					if ($attrs.resizerMax && x > $attrs.resizerMax) {
						x = parseInt($attrs.resizerMax);
					}
					$element.css({
						left: x + 'px'
					});
					$($attrs.resizerLeft).css({
						width: x + 'px'
					});
					$($attrs.resizerRight).css({
						//left: (x + parseInt($attrs.resizerWidth)) + 'px',
						width: $("#treeview_container").width() - x - parseInt($attrs.resizerWidth) + 'px' 
					});
				} else {
					var y = window.innerHeight - event.pageY;
					$element.css({
						bottom: y + 'px'
					});
					$($attrs.resizerTop).css({
						bottom: (y + parseInt($attrs.resizerHeight)) + 'px'
					});
					$($attrs.resizerBottom).css({
						height: y + 'px'
					});
				}
				$(window).trigger("resize");
			}
			function mouseup() {
				$document.unbind('mousemove', mousemove);
				$document.unbind('mouseup', mouseup);
			}
		};
	}
});
