define(['ml_module', 'ng/services/lang'], function(module){
	"use strict";
	var tabs = function() {
		return {
			restrict: 'E',
			scope: {
				tabs: '=',
				langMap: '=',
				hideOptions: '=',
				onChange: '&',
				selectedTab: '@selected'
			},
			replace: true,
			transclude: true,
			templateUrl: '/ng/ml/treeview/directives/tabs.html?q=' + CONFIG_GUI_NO,
			link: function(scope) {
				scope.$watch('tabs', function(tabs, previous) {
					scope.formattedTabs = tabs.map(function(tab) {
						if (!angular.isObject(tab)) {
							tab = {
								value: tab,
								langKey: scope.langMap ? scope.langMap[tab] : tab
							};
						}
						return tab;
					});
					// Intialize by calling "onChange" if "selected" wasn't provided
					if (tabs === previous && !scope.selectedTab) {
						scope.change(scope.formattedTabs[0].value);
					}
				});

				scope.change = function(tab) {
					scope.selectedTab = tab;
					scope.onChange({tab: tab});
				};
			}
		};
	};
	module.directive("fTabs", tabs);	
});
