(function(define, requirejs) {
    "use strict";
    var DEFINITIONS = window.fweb_define && window.fweb_define.DEFINITIONS;
    if ("function" != typeof window.fweb_define || DEFINITIONS) {
        var DEFINED = Object.create(null)
          , LOADED_BY = Object.create(null)
          , REQUIREJS_CONTEXT = "function" == typeof define && define.amd
          , add_loaded_by = function(path, dependencies) {
            Array.isArray(dependencies) || (dependencies = [dependencies]),
            dependencies.forEach(function(dependency) {
                LOADED_BY[dependency] ? LOADED_BY[dependency].push(path) : LOADED_BY[dependency] = [path]
            })
        }
          , fweb_define_collect = function() {
            var COLLECT_DEFINED = {}
              , define_it = fweb_define_collect.define_it = function(name) {
                var def = DEFINITIONS[name];
                fweb_define(name, def.dependencies, def.export_path, def.definition)
            }
            ;
            for (var name in DEFINITIONS)
                name in COLLECT_DEFINED || name in DEFINED || (COLLECT_DEFINED[name] = !0,
                define_it(name));
            DEFINITIONS = null,
            fweb_define_collect.define_it = null
        }
          , fweb_define = window.fweb_define = function(name, dependencies, export_path, definition) {
            var objectKey, object, proxy = function() {
                var mod = definition.apply(null, arguments);
                return DEFINED[name] = mod || null,
                REQUIREJS_CONTEXT || add_loaded_by(name, dependencies),
                mod && object && objectKey && (object[objectKey] = mod),
                mod
            };
            if (export_path && export_path.split(".").forEach(function(key) {
                object = object && objectKey ? object[objectKey] = object[objectKey] || {} : window,
                objectKey = key
            }),
            void 0 !== DEFINED[name])
                throw new Error('fweb_define: "' + name + '" is already defined');
            if (export_path && object[objectKey])
                throw new Error('fweb_define: object "' + export_path + '" already exists');
            REQUIREJS_CONTEXT || (define = function(name, dependencies, definitionFn) {
                var args;
                dependencies && (args = dependencies.map(function(dep) {
                    var depObject = DEFINED[dep]
                      , define_it = fweb_define_collect && fweb_define_collect.define_it;
                    if (void 0 === depObject && ("function" == typeof define_it && (define_it(dep),
                    depObject = DEFINED[dep]),
                    void 0 === depObject))
                        throw new Error('fweb_define: "' + dep + '" is not defined(required by ' + name + ")");
                    return depObject
                })),
                definitionFn.apply(null, args)
            }
            ),
            define(name, dependencies || [], proxy)
        }
        ;
        DEFINITIONS && fweb_define_collect(fweb_define),
        window.fweb_require = function() {
            function inline_require(name, callback) {
                return !callback && "string" == typeof name && DEFINED[name]
            }
            function _require(deps, callback) {
                function defined(name) {
                    return DEFINED[name]
                }
                if ("string" == typeof deps && !callback)
                    return DEFINED[deps];
                if (!Array.isArray(deps) || "function" != typeof callback)
                    throw new Error("Invalid arguments to fweb_require");
                callback.apply(null, deps.map(defined))
            }
            var require = window.require;
            require && REQUIREJS_CONTEXT || (require = _require);
            var result = inline_require.apply(null, arguments);
            return result ? result : require !== _require && (result = require.apply(arguments)) ? result : require.apply(null, arguments)
        }
        ,
        fweb_define.DEFINED = DEFINED,
        fweb_define.LOADED_BY = LOADED_BY,
        REQUIREJS_CONTEXT && (requirejs.onResourceLoad = function(context, map, dep_maps) {
            var name = map.name || map.originalName;
            DEFINED[name] = context.defined[name] || null,
            dep_maps && dep_maps.forEach(function(map) {
                add_loaded_by(name, map.name || map.originalName)
            })
        }
        )
    }
})(window.define, window.requirejs),
(function(require) {
	'use strict';
	var fweb_core = 'js/fweb_core_all'
	    , angular_app = "ng/angular_app"
	    , fweb_extra = "js/fweb_extra_all";
	require.config({
		urlArgs: "q=" + CONFIG_GUI_NO,
		WaitSeconds: 0,
		baseUrl: '/',
		paths: {
			"fweb": fweb_core,
			"ftnt_shared": fweb_core,
			"flot": fweb_core,
			"notify": fweb_core,
			"jquery": fweb_core,
			"jquery.util_core": fweb_core,
			"ng/ftnt": angular_app,
			"ng/services/lang": angular_app,
			"ng/directives/qlist": angular_app,
			"ng/directives/ftnt": angular_app,
			"ng/directives/menu/menu": angular_app,
			qed_list: "js/qed_list_all",
			csrf: fweb_extra,
			"fweb.cmdbClone": fweb_extra,
			"jquery.qtip": fweb_extra,
			"jquery.util": fweb_extra,
			"jquery.maskedinput": fweb_extra,
			"jquery.validate": fweb_extra,
			"jquery.support": fweb_extra,
			"jquery.multilist": fweb_core,
			"jquery.textarea": fweb_extra,
			"jquery.form": fweb_extra,
			"fweb.util/objects": fweb_core,
			"legacy.util": fweb_extra,
			"fweb.util/interface": fweb_core,
			"fweb.util/policy": fweb_core,
			"fweb.util/icon": fweb_core,
			"fweb.util/persist": fweb_core,
			"fweb.util/dom": fweb_core,
			"fweb.util/structure": fweb_core,
			cmdb: fweb_core,
			"join-path": fweb_core,
			"app": 'ng/ml/treeview/app',
			"angular" : 'ng/angular_lib',
			"angular-ui-tree": 'ng/libs/angular-ui-tree.min',
			"angular-route": 'ng/libs/angular-route',
			"nav": 'ng/ml/treeview/directives/nav',
			"f-ml-highchart": 'ng/ml/treeview/directives/f-ml-highchart',
			"f-ml-chart": 'ng/ml/treeview/directives/f-ml-chart',
			"detail_controller": 'ng/ml/treeview/controllers/detail_controller',
			"tabs": 'ng/ml/treeview/directives/tabs',
			"f-ml-dlg": 'ng/ml/treeview/directives/f-ml-dlg',
			"ml_compare_bar": 'ng/ml/treeview/directives/ml_compare_bar',
			"ml_module": 'ng/ml/treeview/ml_module',
			"data": 'ng/ml/treeview/services/data',
			"injector": 'ng/services/faceted_search_util/injector',
			"facets": 'ng/services/faceted_search_util/facets',
			"ml_treeview_arg": 'ng/ml/treeview/controllers/ml_treeview_arg',
			"sidebar-resizer": 'ng/ml/treeview/directives/sidebar-resizer',
			"ml_log_arg": 'ng/ml/treeview/controllers/ml_log_arg',
			"ml_progress_bar": 'ng/ml/treeview/directives/ml_progress_bar',            
            		"search_controller": 'ng/ml/treeview/controllers/search_controller',
			"active_facet": "ng/directives/faceted_search_util/active_facet",
			"faceted_search": "ng/directives/faceted_search_util/faceted_search",
			"facet_input": "ng/directives/faceted_search_util/facet_input",
			"facet_modifier": "ng/directives/faceted_search_util/facet_modifier",
			"search_facet": "ng/directives/faceted_search_util/search_facet"
		},
		shim: {
			'angular': {exports : 'angular'},
			'angular-ui-tree': {deps: ['angular']},
			'angular-route': {deps: ['angular']},
			qed_list: {
				deps: ["fweb", "csrf", "jquery.qtip", "jquery.util", "jquery.maskedinput", 
					"jquery.validate", "jquery.support", "legacy.util", "fweb.util/policy", 
					"fweb.util/interface"
				],
				exports: "jQuery.qlist"
			},
		}
	});
	require(['app'], function(app){
		var $html = angular.element(document.documentElement);
		angular.element(document).ready(function() {
			angular.bootstrap($html, [app.name]);
		});

	});
})(require);
