define(['ml_module'], function(module){
	"use strict";
	module.factory("dataService", dataService);
	var summaryData = {
		summary: {},
		details: {}
	};
	var argsEntries = [];
	dataService.$inject = ["$http"];
	function dataService($http){
		function put(data) {
			//summaryData = {};
			if(data.summary !== undefined)
				summaryData.summary = data.summary;
			if(data.details !== undefined)
				summaryData.details = data.details;
		}
		function putAllowMethodData(data) {
			var allMethodData = getAllowMethodData(false);
			var dataObj = JSON.parse(data);
			var methods = dataObj.methods;
			//allMethodData.am_settings = methods;
			for(var key in allMethodData.am_settings_value)
			{
				var enable = 0;
				angular.forEach(methods, function(obj){
					if(obj[key] !== undefined && obj[key] !== null)
					{
						allMethodData.am_settings_value[key] = true;
						enable = 1;
					}
				});
				if(!enable)
				{
					allMethodData.am_settings_value[key] = false;
				}
			}
			angular.extend(summaryData.details, {allow_method: allMethodData});
		}
		function getInfoData() {
			var options = ['alert', 'block', 'train_start_time', 'access_heat', 'anomaly'];
			var info = {};
			angular.forEach(options, function(opt){
				if(summaryData.summary !== undefined && summaryData.summary[opt] !== undefined)
				{
					info[opt] = summaryData.summary[opt];
				}
			});

			return info;
		}
		function getFlotData() {
			var flot_a = [];
			var flot_b = [];
			if(summaryData.summary !== undefined && summaryData.summary.traffic_trend !== undefined)
			{
				angular.forEach(summaryData.summary.traffic_trend, function(obj){
					var kv_a = [];
					var kv_b = [];
					kv_a.push(new Date(obj.stat_time.replace(/-/g, "/")), obj.alert);
					kv_b.push(new Date(obj.stat_time.replace(/-/g, "/")), obj.block);
					flot_a.push(kv_a);
					flot_b.push(kv_b);
				});
			}
			return {
				'type_alert': flot_a,
				'type_block': flot_b
			}
		}
		function getHighData() {
			var high = [];
			/*
			var numberToPercent = function(num1, num2){
				if(num1 == 0) num1 = 0.001;
				if(num2 == 0) num2 = 0.001;
				return [Math.floor((num1/(num1+num2))*100), Math.floor((num2/(num1+num2))*100)];
			};*/
			if(summaryData.summary !== undefined 
				&& summaryData.summary["anomaly"] !== undefined )
			{
				var d = summaryData.summary["anomaly"];
			//	high.push({name: "potential", y: p?p:0.001});
				high.push({name: "anomaly", y: d?d:0.001});
			}
			else
			{
			//	high.push({name: "potential", y: 0.001});
				high.push({name: "anomaly", y: 0.001});
			}

			return high;
		}
		function getParamsData(){
			if(summaryData.details !== undefined && summaryData.details.parameters !== undefined)
				return summaryData.details.parameters;
			return [];
		}
		function getAllowMethodData(all){
			var allow_method = {
				"am_learning_stage": 1,
				"am_mode": 1,
				"am_settings_value": {
					"GET": false,
					"POST": false,
					"HEAD": false,
					"OPTIONS": false, 
					"TRACE": false,
					"CONNECT": false,
					"DELETE": false,
					"PUT": false,
					"PATCH": false,
					"WEBDAV":false,
					"RPC": false,
					"Others": false
				}
			};
			if(summaryData.details != undefined && summaryData.details.allow_method !== undefined)
			{
				if(all){
					angular.extend(allow_method, summaryData.details.allow_method);
				}
				else{
					angular.extend(allow_method, {am_settings: summaryData.details.allow_method.am_settings, 
								am_settings_value: summaryData.details.allow_method.am_settings_value,
								am_learning_stage: summaryData.details.allow_method.am_learning_stage});	
				}
					
			}
			return allow_method;
		}
		function refreshUrl(url_id, action, path){
			var relearn_type = 0;
			if(action === 10) relearn_type = 2;
			if(action === 11) relearn_type = 1;
			$http({
				method: 'POST',
				transformRequest: transformRequestAsFormPost,
				cache: false,
				url: '/waf/ml_policy/refresh_action',
				data: {
					session_id: session_id,
					type: 2,
					relearn_type:relearn_type,
					url_id: url_id,
					path:path,
					domain_id: domain_id,
					action: action
				}
			})
			.then(function(result){
				put(result.data)
			});
		}

		function getArgData(url_id, arg_id) {
			return $http({
				method: 'GET',
				cache: false,
				url: '/waf/ml_policy/treeview_arg_json',
				params: {
					mkey: mkey,
					db_name: db_name,
					domain_id: domain_id,
					url_id: url_id,
					arg_id: arg_id
				}
			});
		}

		function refreshMethod(url_id){
			return $http({
				method: 'POST',
				transformRequest: transformRequestAsFormPost,
				cache: false,
				url: '/waf/ml_policy/refresh_action',
				data: {
					session_id: session_id,
					domain_id: domain_id,
					url_id: url_id,
					type: 4,
				}
			});
		}

		function refreshArg(url_id, arg_id) {
			return $http({
				method: 'POST',
				transformRequest: transformRequestAsFormPost,
				cache: false,
				url: '/waf/ml_policy/refresh_action',
				data: {
					session_id: session_id,
					domain_id: domain_id,
					url_id: url_id,
					arg_id: arg_id,
					type: 3
				}
			});
		}
		function relearnArg(url_id, arg_id) {
			return $http({
				method: 'POST',
				transformRequest: transformRequestAsFormPost,
				cache: false,
				url: '/waf/ml_policy/refresh_action',
				data: {
					session_id: session_id,
					domain_id: domain_id,
					url_id: url_id,
					arg_id: arg_id,					
					relearn_type: 3,
					type: 0
				}
			});
		}				

		function discardArg(url_id, arg_id) {
			return $http({
				method: 'POST',
				transformRequest: transformRequestAsFormPost,
				cache: false,
				url: '/waf/ml_policy/set_arg_discard',
				data: {
					session_id: session_id,
					domain_id: domain_id,
					url_id: url_id,
					arg_id: arg_id
				}
			});
		}

		function setArg(options) {
			var data = {
				session_id: session_id,
				domain_id: domain_id,
				mkey: mkey
			};
			data = angular.extend(data, options);
			return $http({
				method: 'POST',
				transformRequest: transformRequestAsFormPost,
				cache: false,
				url: '/waf/ml_policy/set_arg_setting',
				data: data
			});
		}

		function transformRequestAsFormPost(data, getHeaders){
			var headers = getHeaders();
			headers[ "Content-type" ] = "application/x-www-form-urlencoded; charset=utf-8";
			return( serializeData( data ) );

			function serializeData( data ) {
				if ( ! angular.isObject( data ) ) {
					return( ( data == null ) ? "" : data.toString() );
				}
				var buffer = [];
				for ( var name in data ) {
					if ( ! data.hasOwnProperty( name ) ) {
						continue;
					}
					var value = data[ name ];
					buffer.push(
						encodeURIComponent( name ) +
						"=" +
						encodeURIComponent( ( value == null ) ? "" : value )
					);
				}
				var source = buffer
					.join( "&" )
					.replace( /%20/g, "+" );
				return( source );
			}
		}
		
		function genArgsEntries(data) {
			argsEntries = ((data !== null) && (data.length !== 0)) ? data : argsEntries;
			return argsEntries;
		} 
		return {
			put: put,
			putAllowMethodData: putAllowMethodData,
			getInfoData: getInfoData,
			getFlotData: getFlotData,
			getHighData: getHighData,
			getParamsData: getParamsData,
			getAllowMethodData: getAllowMethodData,
			refreshUrl: refreshUrl,
			getArgData: getArgData,
			refreshArg: refreshArg,
			relearnArg: relearnArg,
			refreshMethod: refreshMethod,
			discardArg: discardArg,
			setArg: setArg,
			transformRequestAsFormPost: transformRequestAsFormPost,
			genArgsEntries: genArgsEntries
		};
	}
});
